/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.impl.load.CharsReader;
import com.pivotal.gemfirexd.internal.impl.load.ControlInfo;
import com.pivotal.gemfirexd.internal.impl.load.ImportBlobBase;
import com.pivotal.gemfirexd.internal.impl.load.ImportClobBase;
import com.pivotal.gemfirexd.internal.impl.load.ImportLobFile;
import com.pivotal.gemfirexd.internal.impl.load.LoadError;
import com.pivotal.gemfirexd.internal.impl.load.PartialFileInputStream;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;

public final class ImportReadData
implements PrivilegedExceptionAction {
    private String inputFileName;
    private int numberOfCharsReadSoFar;
    private Reader reader;
    private CharsReader charsReader;
    private static final int BUF_SIZE = 65536;
    private char[] charBuf = new char[65536];
    int charBufPos;
    private static final int START_SIZE = 10240;
    private char[] currentToken = new char[10240];
    private int currentTokenMaxSize = 10240;
    boolean foundStartDelimiter;
    int totalCharsSoFar;
    int positionOfNonWhiteSpaceCharInFront;
    int positionOfNonWhiteSpaceCharInBack;
    int lineNumber;
    int fieldStartDelimiterIndex;
    int fieldStopDelimiterIndex;
    int stopDelimiterPosition;
    boolean foundStartAndStopDelimiters;
    boolean streamOpenForReading;
    private boolean hasColumnDefinition;
    private char recordSeparatorChar0;
    private char fieldSeparatorChar0;
    private boolean recordSepStartNotWhite = true;
    private boolean fieldSepStartNotWhite = true;
    protected ControlInfo controlFileReader;
    protected int numberOfColumns;
    protected String[] columnTypes;
    protected char[] fieldSeparator;
    protected int fieldSeparatorLength;
    protected char[] recordSeparator;
    protected int recordSeparatorLength;
    protected String columnDefinition;
    protected String format;
    protected String dataCodeset;
    protected char[] fieldStartDelimiter;
    protected int fieldStartDelimiterLength;
    protected char[] fieldStopDelimiter;
    protected int fieldStopDelimiterLength;
    protected char fieldStartDelimiterChar;
    protected char fieldStopDelimiterChar;
    protected boolean hasDelimiterAtEnd;
    protected boolean canUseOptimizedRecordRead;
    protected boolean canUseOptimizedFieldRead;
    private ImportLobFile[] lobFileHandles;
    private String lobFileName;
    private int lobOffset;
    private int lobLength;
    private final long offset;
    private final long endPosition;
    static final int CONTINUE_READING = 0;
    static final int FOUND_START_DELIM = -1;
    static final int FOUND_STOP_DELIM = -2;
    static final int FOUND_EOL = -3;

    private void loadPropertiesInfo() throws Exception {
        this.fieldSeparator = this.controlFileReader.getFieldSeparator().toCharArray();
        this.fieldSeparatorLength = this.fieldSeparator.length;
        this.recordSeparator = this.controlFileReader.getRecordSeparator().toCharArray();
        this.recordSeparatorLength = this.recordSeparator.length;
        this.columnDefinition = this.controlFileReader.getColumnDefinition();
        this.format = this.controlFileReader.getFormat();
        this.dataCodeset = this.controlFileReader.getDataCodeset();
        this.fieldStartDelimiter = this.controlFileReader.getFieldStartDelimiter().toCharArray();
        this.fieldStartDelimiterLength = this.fieldStartDelimiter.length;
        if (this.fieldStartDelimiterLength == 1) {
            this.fieldStartDelimiterChar = this.fieldStartDelimiter[0];
        }
        this.fieldStopDelimiter = this.controlFileReader.getFieldEndDelimiter().toCharArray();
        this.fieldStopDelimiterLength = this.fieldStopDelimiter.length;
        if (this.fieldStopDelimiterLength == 1) {
            this.fieldStopDelimiterChar = this.fieldStopDelimiter[0];
        }
        this.hasDelimiterAtEnd = this.controlFileReader.getHasDelimiterAtEnd();
        if (this.recordSeparatorLength > 0) {
            this.recordSeparatorChar0 = this.recordSeparator[0];
            boolean bl = this.recordSepStartNotWhite = !Character.isWhitespace(this.recordSeparatorChar0);
        }
        if (this.fieldSeparatorLength > 0) {
            this.fieldSeparatorChar0 = this.fieldSeparator[0];
            boolean bl = this.fieldSepStartNotWhite = !Character.isWhitespace(this.fieldSeparatorChar0);
        }
        if (this.fieldStartDelimiterLength == 1 && this.fieldStopDelimiterLength == 1 && (this.recordSeparatorLength == 1 && (this.recordSeparator[0] == '\r' || this.recordSeparator[0] == '\n') || this.recordSeparatorLength == 2 && this.recordSeparator[0] == '\r' && this.recordSeparator[1] == '\n')) {
            this.canUseOptimizedRecordRead = true;
            boolean bl = this.canUseOptimizedFieldRead = this.fieldSeparatorLength == 1;
        }
        if (GemFireXDUtils.TraceImport) {
            SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("Import: optimizedRecordRead=" + this.canUseOptimizedRecordRead + " optimizedFieldRead=" + this.canUseOptimizedFieldRead));
        }
    }

    public static void main(String[] args) throws Exception {
        ControlInfo controlFileReader = new ControlInfo();
        controlFileReader.setControlProperties("\"", ",", "UTF-8");
        long size = new File(args[0]).length();
        for (int i = 1; i <= 3; ++i) {
            ImportReadData readData = new ImportReadData(args[0], 0L, 0L, controlFileReader);
            int numLines = 0;
            long start = System.currentTimeMillis();
            while (readData.readNextLine() != null) {
                ++numLines;
            }
            long timeTaken = System.currentTimeMillis() - start;
            System.out.println("Total time taken: " + timeTaken + " millis for " + numLines + " lines at " + size * 1000L / (timeTaken * 1024L * 1024L) + " MB/s");
            readData.closeStream();
        }
    }

    ImportReadData(String inputFileName, long offset, long endPosition, ControlInfo controlFileReader) throws Exception {
        this.offset = offset;
        this.endPosition = endPosition;
        this.inputFileName = inputFileName;
        this.controlFileReader = controlFileReader;
        this.loadPropertiesInfo();
        this.loadMetaData();
        this.lobFileHandles = new ImportLobFile[this.numberOfColumns];
    }

    int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    protected void ignoreFirstRow() throws Exception {
        this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true);
    }

    protected void loadColumnTypes() throws Exception {
        this.findNumberOfColumnsInARow();
        this.closeStream();
        this.openFile();
        String[] metaDataArray = new String[this.numberOfColumns];
        this.readNextDelimitedRow(metaDataArray);
        this.columnTypes = new String[this.numberOfColumns / 2];
        for (int idx = 0; idx < this.numberOfColumns; idx += 2) {
            this.columnTypes[idx / 2] = metaDataArray[idx + 1];
        }
        this.closeStream();
        this.openFile();
        this.numberOfColumns = 0;
    }

    private void openFile() throws Exception {
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public final Object run() throws Exception {
        this.realOpenFile();
        return null;
    }

    private void realOpenFile() throws Exception {
        InputStream inputStream;
        FileInputStream fileStream = null;
        try {
            try {
                URL url = new URL(this.inputFileName);
                if (url.getProtocol().equals("file")) {
                    this.inputFileName = url.getFile();
                    throw new MalformedURLException();
                }
                inputStream = url.openStream();
            }
            catch (MalformedURLException ex) {
                if (this.endPosition > 0L) {
                    fileStream = new PartialFileInputStream(this.inputFileName, this.offset, this.endPosition);
                } else {
                    fileStream = new FileInputStream(this.inputFileName);
                    if (this.offset > 0L) {
                        fileStream.skip(this.offset);
                    }
                }
                inputStream = fileStream;
            }
        }
        catch (FileNotFoundException ex) {
            throw LoadError.dataFileNotFound(this.inputFileName, ex);
        }
        catch (SecurityException se) {
            throw LoadError.dataFileNotFound(this.inputFileName, se);
        }
        String codeSet = this.dataCodeset == null ? "UTF-8" : this.dataCodeset;
        Reader rd = inputStream instanceof FileInputStream ? Channels.newReader((ReadableByteChannel)((FileInputStream)inputStream).getChannel(), codeSet) : new InputStreamReader(inputStream, codeSet);
        this.reader = rd;
        this.streamOpenForReading = true;
        this.charBufPos = this.charBuf.length;
    }

    void setCharsReader(CharsReader reader) {
        this.charsReader = reader;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        this.charBuf = null;
        this.streamOpenForReading = true;
    }

    void resetCharsReader(char[] chars, int offset, int len) {
        this.charsReader.reset(chars, offset, len);
        this.streamOpenForReading = true;
    }

    private void loadMetaData() throws Exception {
        this.openFile();
        if (this.columnDefinition.toUpperCase(Locale.ENGLISH).equals("True".toUpperCase(Locale.ENGLISH)) && this.offset == 0L) {
            this.hasColumnDefinition = true;
            this.ignoreFirstRow();
        }
        this.findNumberOfColumnsInARow();
        this.closeStream();
    }

    void closeStream() throws Exception {
        if (this.streamOpenForReading) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.charBufPos = 0;
            this.streamOpenForReading = false;
        }
        if (this.lobFileHandles != null) {
            for (int i = 0; i < this.numberOfColumns; ++i) {
                if (this.lobFileHandles[i] == null) continue;
                this.lobFileHandles[i].close();
            }
        }
    }

    int findNumberOfColumnsInARow() throws Exception {
        this.numberOfColumns = 1;
        while (!this.readTokensUntilEndOfRecord()) {
            ++this.numberOfColumns;
        }
        if (this.hasDelimiterAtEnd) {
            --this.numberOfColumns;
        }
        if (this.numberOfCharsReadSoFar == 0) {
            this.numberOfColumns = 0;
        }
        return this.numberOfColumns;
    }

    private void checkForWhiteSpaceInFront() {
        char currentChar;
        if (!(this.positionOfNonWhiteSpaceCharInFront + 1 != this.totalCharsSoFar || this.foundStartDelimiter || this.foundStartAndStopDelimiters || !Character.isWhitespace(currentChar = this.currentToken[this.positionOfNonWhiteSpaceCharInFront]) || !this.recordSepStartNotWhite && currentChar == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && currentChar == this.fieldSeparatorChar0)) {
            ++this.positionOfNonWhiteSpaceCharInFront;
        }
    }

    private void checkForWhiteSpaceInBack() {
        boolean onlyWhiteSpaceSoFar = true;
        this.positionOfNonWhiteSpaceCharInBack = 0;
        for (int i = this.totalCharsSoFar; i > this.stopDelimiterPosition && onlyWhiteSpaceSoFar; --i) {
            char currentChar = this.currentToken[i];
            if (Character.isWhitespace(currentChar)) {
                if (!this.recordSepStartNotWhite && currentChar == this.recordSeparatorChar0 || !this.fieldSepStartNotWhite && currentChar == this.fieldSeparatorChar0) continue;
                ++this.positionOfNonWhiteSpaceCharInBack;
                continue;
            }
            onlyWhiteSpaceSoFar = false;
        }
    }

    boolean readTokensUntilEndOfRecord() throws Exception {
        int nextChar;
        int fieldSeparatorIndex = 0;
        int recordSeparatorIndex = 0;
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.foundStartDelimiter = false;
        this.foundStartAndStopDelimiters = false;
        this.numberOfCharsReadSoFar = 0;
        do {
            if ((nextChar = this.readChar()) == -1) {
                return true;
            }
            ++this.numberOfCharsReadSoFar;
            this.currentToken[this.totalCharsSoFar++] = (char)nextChar;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] tempArray = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, tempArray, 0, this.totalCharsSoFar);
                this.currentToken = tempArray;
            }
            if ((fieldSeparatorIndex = this.lookForPassedSeparator(this.fieldSeparator, fieldSeparatorIndex, this.fieldSeparatorLength, nextChar, false)) != -1) continue;
            return false;
        } while (this.foundStartDelimiter || (recordSeparatorIndex = this.lookForPassedSeparator(this.recordSeparator, recordSeparatorIndex, this.recordSeparatorLength, nextChar, true)) != -1);
        return true;
    }

    private int lookForPassedSeparator(char[] delimiter, int delimiterIndex, int delimiterLength, int nextChar, boolean lookForRecordSeperator) throws IOException {
        if (!this.foundStartDelimiter) {
            if (this.fieldStartDelimiterLength != 0 && !this.foundStartAndStopDelimiters && this.totalCharsSoFar != this.positionOfNonWhiteSpaceCharInFront && this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront <= this.fieldStartDelimiterLength) {
                if (nextChar == this.fieldStartDelimiter[this.fieldStartDelimiterIndex]) {
                    ++this.fieldStartDelimiterIndex;
                    if (this.fieldStartDelimiterIndex == this.fieldStartDelimiterLength) {
                        this.foundStartDelimiter = true;
                        this.totalCharsSoFar = 0;
                        this.positionOfNonWhiteSpaceCharInFront = 0;
                        return 0;
                    }
                } else if (this.fieldStartDelimiterIndex > 0) {
                    this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStartDelimiterIndex, this.fieldStartDelimiter, this.fieldStartDelimiterLength);
                }
            }
            if (lookForRecordSeperator) {
                if (nextChar == 13 || nextChar == 10) {
                    this.recordSeparatorChar0 = (char)nextChar;
                    if (nextChar == 13) {
                        this.omitLineFeed();
                    }
                    --this.totalCharsSoFar;
                    return -1;
                }
                return delimiterIndex;
            }
            if (nextChar == delimiter[delimiterIndex]) {
                if (++delimiterIndex == delimiterLength) {
                    this.totalCharsSoFar -= delimiterLength;
                    return -1;
                }
                return delimiterIndex;
            }
            if (delimiterIndex > 0) {
                return this.reCheckRestOfTheCharacters(this.totalCharsSoFar - delimiterIndex, delimiter, delimiterLength);
            }
        } else {
            if (nextChar == this.fieldStopDelimiter[this.fieldStopDelimiterIndex]) {
                ++this.fieldStopDelimiterIndex;
                if (this.fieldStopDelimiterIndex == this.fieldStopDelimiterLength) {
                    boolean skipped = this.skipDoubleDelimiters(this.fieldStopDelimiter);
                    if (!skipped) {
                        this.foundStartDelimiter = false;
                        this.totalCharsSoFar -= this.fieldStopDelimiterLength;
                        this.stopDelimiterPosition = this.totalCharsSoFar;
                        this.foundStartAndStopDelimiters = true;
                    } else {
                        this.fieldStopDelimiterIndex = 0;
                    }
                    return 0;
                }
                return 0;
            }
            if (this.fieldStopDelimiterIndex > 0) {
                this.reCheckRestOfTheCharacters(this.totalCharsSoFar - this.fieldStopDelimiterIndex, this.fieldStopDelimiter, this.fieldStopDelimiterLength);
                return 0;
            }
        }
        return 0;
    }

    private int reCheckRestOfTheCharacters(int startFrom, char[] delimiter, int delimiterLength) {
        int delimiterIndex = 0;
        for (int i = startFrom; i < this.totalCharsSoFar; ++i) {
            if (this.currentToken[i] == delimiter[delimiterIndex]) {
                ++delimiterIndex;
                continue;
            }
            delimiterIndex = 0;
        }
        return delimiterIndex;
    }

    private boolean skipDoubleDelimiters(char[] characterDelimiter) throws IOException {
        boolean skipped = true;
        int cDelLength = characterDelimiter.length;
        int currentPos = this.mark(cDelLength);
        for (int i = 0; i < cDelLength; ++i) {
            int nextChar = this.readChar();
            if (nextChar == characterDelimiter[i]) continue;
            this.resetForMark(currentPos);
            skipped = false;
            break;
        }
        return skipped;
    }

    private boolean skipDoubleDelimiters(char characterDelimiter) throws IOException {
        int currentPos = this.mark(1);
        int nextChar = this.readChar();
        if (nextChar != characterDelimiter) {
            this.resetForMark(currentPos);
            return false;
        }
        return true;
    }

    private boolean omitLineFeed() throws IOException {
        int currentPos = this.mark(1);
        int nextChar = this.readChar();
        if (nextChar != 10) {
            this.resetForMark(currentPos);
            return false;
        }
        return true;
    }

    int getCurrentRowNumber() {
        return this.lineNumber;
    }

    boolean readNextRow(String[] returnStringArray) throws Exception {
        if (!this.streamOpenForReading) {
            this.openFile();
            if (this.hasColumnDefinition) {
                this.ignoreFirstRow();
            }
        }
        boolean readVal = this.readNextDelimitedRow(returnStringArray);
        return readVal;
    }

    final char[] readNextLine() throws Exception {
        int offset;
        boolean hasRecord;
        if (!this.streamOpenForReading) {
            this.openFile();
            if (this.hasColumnDefinition) {
                this.ignoreFirstRow();
            }
        }
        if (this.canUseOptimizedRecordRead) {
            hasRecord = this.readNextRecordOpt();
            offset = 0;
        } else {
            hasRecord = this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true);
            offset = this.positionOfNonWhiteSpaceCharInFront;
        }
        if (hasRecord) {
            char[] line;
            char lastChar;
            int len = this.totalCharsSoFar - offset;
            if (len < 0) {
                len = 0;
            }
            if (this.totalCharsSoFar <= 0 || (lastChar = this.currentToken[this.totalCharsSoFar - 1]) != '\n' && lastChar != '\r') {
                line = new char[len + 2];
                line[len] = 10;
                line[len + 1] = 32;
            } else {
                line = new char[len + 1];
                line[len] = 32;
            }
            System.arraycopy(this.currentToken, offset, line, 0, len);
            if (GemFireXDUtils.TraceImport) {
                SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("Read a new line from file: " + new String(line)));
            }
            ++this.lineNumber;
            return line;
        }
        return null;
    }

    final boolean readNextRecordOpt() throws Exception {
        int bufPos;
        this.totalCharsSoFar = 0;
        boolean foundStartDelimiter = false;
        char fieldStartDelimiter = this.fieldStartDelimiterChar;
        char fieldStopDelimiter = this.fieldStopDelimiterChar;
        char[] cbuf = this.charBuf;
        int lastPos = bufPos = this.charBufPos;
        while (true) {
            try {
                char nextChar;
                while (true) {
                    int returnValue;
                    if ((returnValue = this.lookForPassedRecordSeparatorOpt(nextChar = cbuf[bufPos++], foundStartDelimiter, fieldStartDelimiter, fieldStopDelimiter)) == 0) {
                        continue;
                    }
                    if (returnValue == -1) {
                        foundStartDelimiter = true;
                        continue;
                    }
                    assert (returnValue == -3 || returnValue == -2) : returnValue;
                    this.charBufPos = bufPos;
                    this.appendToCurrentToken(cbuf, lastPos, bufPos - lastPos);
                    if (returnValue != -2) break;
                    boolean skipped = this.skipDoubleDelimiters(this.fieldStopDelimiterChar);
                    if (skipped) {
                        this.appendToCurrentToken(cbuf, this.charBufPos - 1, 1);
                    } else {
                        foundStartDelimiter = false;
                    }
                    cbuf = this.charBuf;
                    lastPos = bufPos = this.charBufPos;
                }
                if (nextChar == '\r') {
                    this.omitLineFeed();
                }
                return true;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.charBufPos = bufPos;
                this.appendToCurrentToken(cbuf, lastPos, cbuf.length - lastPos);
                if (this.fillBuffer(0) > 0) {
                    cbuf = this.charBuf;
                    lastPos = bufPos = this.charBufPos;
                    continue;
                }
                return false;
            }
            break;
        }
    }

    private final void appendToCurrentToken(char[] cbuf, int lastPos, int len) {
        if (len > 0) {
            int tokLen = this.currentToken.length;
            if (len > tokLen - this.totalCharsSoFar) {
                int newLen = Math.max(tokLen, len) + tokLen;
                char[] newToken = new char[newLen];
                System.arraycopy(this.currentToken, 0, newToken, 0, tokLen);
                this.currentToken = newToken;
            }
            System.arraycopy(cbuf, lastPos, this.currentToken, this.totalCharsSoFar, len);
            this.totalCharsSoFar += len;
        }
    }

    private final int lookForPassedRecordSeparatorOpt(int nextChar, boolean foundStartDelimiter, char fieldStartDelimiterChar, char fieldStopDelimiterChar) throws IOException {
        if (!foundStartDelimiter) {
            if (fieldStartDelimiterChar != '\u0000') {
                if (nextChar != fieldStartDelimiterChar) {
                    if (nextChar != 13 && nextChar != 10) {
                        return 0;
                    }
                    return -3;
                }
                return -1;
            }
            if (nextChar == 13 || nextChar == 10) {
                return -3;
            }
            return 0;
        }
        if (nextChar != fieldStopDelimiterChar) {
            return 0;
        }
        return -2;
    }

    private boolean readNextDelimitedRow(String[] returnStringArray) throws Exception {
        int i;
        int upperLimit = this.numberOfColumns - 1;
        if (upperLimit < 0) {
            return false;
        }
        for (i = 0; i < upperLimit; ++i) {
            if (!this.readNextToken(this.fieldSeparator, 0, this.fieldSeparatorLength, false)) {
                if (i == 0) {
                    return false;
                }
                throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
            }
            if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
                for (int k = this.stopDelimiterPosition + 1; k < this.totalCharsSoFar; ++k) {
                    if (Character.isWhitespace(this.currentToken[k])) continue;
                    throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, i + 1);
                }
                this.totalCharsSoFar = this.stopDelimiterPosition;
            }
            returnStringArray[i] = this.totalCharsSoFar != -1 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
        }
        if (!this.readNextToken(this.recordSeparator, 0, this.recordSeparatorLength, true)) {
            if (upperLimit == 0) {
                return false;
            }
            throw LoadError.unexpectedEndOfFile(this.lineNumber + 1);
        }
        if (this.stopDelimiterPosition != 0 && this.stopDelimiterPosition != this.totalCharsSoFar) {
            for (i = this.stopDelimiterPosition + 1; i < this.totalCharsSoFar; ++i) {
                if (Character.isWhitespace(this.currentToken[i])) continue;
                throw LoadError.dataAfterStopDelimiter(this.lineNumber + 1, this.numberOfColumns);
            }
            this.totalCharsSoFar = this.stopDelimiterPosition;
        }
        if (this.hasDelimiterAtEnd && this.fieldStopDelimiterLength <= 0) {
            --this.totalCharsSoFar;
        }
        if (this.totalCharsSoFar > -1) {
            if (!this.hasDelimiterAtEnd) {
                returnStringArray[upperLimit] = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
            } else if (this.totalCharsSoFar == this.fieldSeparatorLength && this.isFieldSep(this.currentToken)) {
                String currentStr = new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar);
                returnStringArray[upperLimit] = this.currentToken[this.totalCharsSoFar + 1] == this.fieldStopDelimiter[0] ? currentStr : null;
            } else {
                returnStringArray[upperLimit] = this.totalCharsSoFar > 0 ? new String(this.currentToken, this.positionOfNonWhiteSpaceCharInFront, this.totalCharsSoFar) : null;
            }
        } else {
            returnStringArray[upperLimit] = null;
        }
        ++this.lineNumber;
        if (GemFireXDUtils.TraceImport) {
            SanityManager.DEBUG_PRINT((String)"TraceImport", (String)("Read a new line from file: " + Arrays.toString(returnStringArray)));
        }
        return true;
    }

    private final int readChar() throws IOException {
        if (this.charsReader == null) {
            try {
                return this.charBuf[this.charBufPos++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.fillBuffer(0) > 0) {
                    return this.charBuf[this.charBufPos++];
                }
                return -1;
            }
        }
        return this.charsReader.read();
    }

    private final int fillBuffer(int offset) throws IOException {
        int newSize;
        int readBytes;
        int size = this.charBuf.length;
        for (newSize = offset; newSize < size && (readBytes = this.reader.read(this.charBuf, newSize, size - newSize)) >= 0; newSize += readBytes) {
        }
        this.charBufPos = 0;
        if (newSize >= 0 && newSize != size) {
            char[] newBuf = new char[newSize + 4];
            System.arraycopy(this.charBuf, 0, newBuf, 0, newSize);
            this.charBuf = newBuf;
        }
        return newSize;
    }

    private final int mark(int readAheadLimit) throws IOException {
        if (this.charsReader == null) {
            int bufSize = this.charBuf.length;
            int unreadChars = bufSize - this.charBufPos;
            if (unreadChars > readAheadLimit) {
                return this.charBufPos;
            }
            if (readAheadLimit < bufSize) {
                if (unreadChars > 0) {
                    System.arraycopy(this.charBuf, this.charBufPos, this.charBuf, 0, unreadChars);
                }
                this.fillBuffer(unreadChars);
                return 0;
            }
            throw new IOException("mark() readAheadLimit=" + readAheadLimit + " greater or equal to bufferSize=" + bufSize);
        }
        this.charsReader.mark(readAheadLimit);
        return 0;
    }

    private final void resetForMark(int pos) throws IOException {
        if (this.charsReader == null) {
            this.charBufPos = pos;
        } else {
            this.charsReader.reset();
        }
    }

    private boolean isFieldSep(char[] chrArray) {
        for (int i = 0; i < chrArray.length && i < this.fieldSeparatorLength; ++i) {
            if (chrArray[i] == this.fieldSeparator[i]) continue;
            return false;
        }
        return true;
    }

    boolean readNextToken(char[] delimiter, int delimiterIndex, int delimiterLength, boolean isRecordSeperator) throws Exception {
        this.fieldStopDelimiterIndex = 0;
        this.fieldStartDelimiterIndex = 0;
        this.totalCharsSoFar = 0;
        this.positionOfNonWhiteSpaceCharInFront = 0;
        this.stopDelimiterPosition = 0;
        this.foundStartAndStopDelimiters = false;
        this.foundStartDelimiter = false;
        int nextChar;
        while ((nextChar = this.readChar()) != -1) {
            int returnValue;
            this.currentToken[this.totalCharsSoFar++] = (char)nextChar;
            this.checkForWhiteSpaceInFront();
            if (this.totalCharsSoFar == this.currentTokenMaxSize) {
                this.currentTokenMaxSize *= 2;
                char[] tempArray = new char[this.currentTokenMaxSize];
                System.arraycopy(this.currentToken, 0, tempArray, 0, this.totalCharsSoFar);
                this.currentToken = tempArray;
            }
            if ((returnValue = this.lookForPassedSeparator(delimiter, delimiterIndex, delimiterLength, nextChar, isRecordSeperator)) == -1) {
                if (!this.foundStartAndStopDelimiters) {
                    if (this.totalCharsSoFar == 0) {
                        this.totalCharsSoFar = -1;
                    } else {
                        this.checkForWhiteSpaceInBack();
                        this.totalCharsSoFar = this.totalCharsSoFar - this.positionOfNonWhiteSpaceCharInFront - this.positionOfNonWhiteSpaceCharInBack;
                        if (this.totalCharsSoFar < -1) {
                            this.totalCharsSoFar = -1;
                        }
                    }
                }
                return true;
            }
            delimiterIndex = returnValue;
        }
        return false;
    }

    String getClobColumnFromExtFileAsString(String lobLocationStr, int colIndex) throws SQLException {
        try {
            this.initExternalLobFile(lobLocationStr, colIndex);
            if (this.lobLength == -1) {
                return null;
            }
            return this.lobFileHandles[colIndex - 1].getString(this.lobOffset, this.lobLength);
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    Clob getClobColumnFromExtFile(String lobLocationStr, int colIndex) throws SQLException {
        try {
            this.initExternalLobFile(lobLocationStr, colIndex);
            if (this.lobLength == -1) {
                return null;
            }
            return new ImportClobBase(this.lobFileHandles[colIndex - 1], this.lobOffset, this.lobLength);
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    Blob getBlobColumnFromExtFile(String lobLocationStr, int colIndex) throws SQLException {
        this.initExternalLobFile(lobLocationStr, colIndex);
        if (this.lobLength == -1) {
            return null;
        }
        return new ImportBlobBase(this.lobFileHandles[colIndex - 1], this.lobOffset, this.lobLength);
    }

    private void initExternalLobFile(String lobLocationStr, int colIndex) throws SQLException {
        int lengthIndex = lobLocationStr.lastIndexOf(".");
        int offsetIndex = lobLocationStr.lastIndexOf(".", lengthIndex - 1);
        this.lobLength = Integer.parseInt(lobLocationStr.substring(lengthIndex + 1, lobLocationStr.length() - 1));
        this.lobOffset = Integer.parseInt(lobLocationStr.substring(offsetIndex + 1, lengthIndex));
        this.lobFileName = lobLocationStr.substring(0, offsetIndex);
        if (this.lobFileHandles[colIndex - 1] == null) {
            try {
                File lobsFile = new File(this.lobFileName);
                if (lobsFile.getParentFile() == null) {
                    lobsFile = new File(new File(this.inputFileName).getParentFile(), this.lobFileName);
                }
                this.lobFileHandles[colIndex - 1] = new ImportLobFile(lobsFile, this.controlFileReader.getDataCodeset());
            }
            catch (Exception ex) {
                throw LoadError.unexpectedError(ex);
            }
        }
    }
}

