/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import java.io.IOException;
import java.io.Reader;

public final class CharsReader
extends Reader {
    private char[] chars;
    private int len;
    private int cursor;
    private int mark;

    public CharsReader(char[] chars) {
        this.reset(chars, 0, chars.length);
    }

    public CharsReader(char[] chars, int offset, int len) {
        this.reset(chars, offset, len);
    }

    public void reset(char[] chars, int offset, int len) {
        if (offset < 0 || len < 0) {
            throw new IllegalArgumentException();
        }
        this.chars = chars;
        this.len = len;
        this.cursor = offset;
        this.mark = -1;
    }

    @Override
    public final int read() {
        try {
            return this.chars[this.cursor++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    @Override
    public int read(char[] cbuf, int offset, int len) {
        if (len == 0) {
            return 0;
        }
        if (len < 0 || offset + len > cbuf.length) {
            throw new IndexOutOfBoundsException();
        }
        int nCopy = this.len - this.cursor;
        if (nCopy > 0) {
            if (nCopy > len) {
                nCopy = len;
            }
            System.arraycopy(this.chars, this.cursor, cbuf, offset, nCopy);
            this.cursor += nCopy;
            return nCopy;
        }
        return -1;
    }

    @Override
    public long skip(long ns) {
        if (this.cursor < this.len) {
            long n = Math.min((long)(this.len - this.cursor), ns);
            n = Math.max((long)(-this.cursor), n);
            this.cursor = (int)((long)this.cursor + n);
            return n;
        }
        return 0L;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.mark = this.cursor;
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0) {
            throw new IOException("Stream not marked");
        }
        this.cursor = this.mark;
        this.mark = -1;
    }

    public String asString() {
        return this.chars != null ? new String(this.chars) : null;
    }

    @Override
    public void close() {
        this.cursor = this.len + 1;
    }
}

