/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineLOB;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedBlob;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DriverManager;
import java.sql.SQLException;

public class LOBStoredProcedure {
    public static final int MAX_RETURN_LENGTH = 32672;

    public static int CLOBCREATELOCATOR() throws SQLException {
        EmbedConnection conn = LOBStoredProcedure.getEmbedConnection();
        EmbedClob clob = conn.createClob();
        int locator = clob.getLocator();
        conn.closingNestedConnection();
        return locator;
    }

    public static void CLOBRELEASELOCATOR(int LOCATOR) throws SQLException {
        EmbedConnection conn = LOBStoredProcedure.getEmbedConnection();
        Object blob = conn.getLOBMapping(LOCATOR);
        if (blob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        ((EngineLOB)blob).free();
        conn.removeLOBMapping(LOCATOR);
        conn.closingNestedConnection();
    }

    public static long CLOBGETPOSITIONFROMSTRING(int LOCATOR, String searchLiteral, long fromPosition) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).position(searchLiteral, fromPosition);
    }

    public static long CLOBGETPOSITIONFROMLOCATOR(int LOCATOR, int searchLocator, long fromPosition) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).position(LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(searchLocator), fromPosition);
    }

    public static long CLOBGETLENGTH(int LOCATOR) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).length();
    }

    public static String CLOBGETSUBSTRING(int LOCATOR, long pos, int len) throws SQLException {
        len = Math.min(len, 32672);
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).getSubString(pos, len);
    }

    public static void CLOBSETSTRING(int LOCATOR, long pos, int length, String str) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).setString(pos, str, 0, length);
    }

    public static void CLOBTRUNCATE(int LOCATOR, long length) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(LOCATOR).truncate(length);
    }

    private static Clob getClobObjectCorrespondingtoLOCATOR(int LOCATOR) throws SQLException {
        EmbedConnection conn = LOBStoredProcedure.getEmbedConnection();
        Clob clob = (Clob)conn.getLOBMapping(LOCATOR);
        conn.closingNestedConnection();
        if (clob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return clob;
    }

    public static int BLOBCREATELOCATOR() throws SQLException {
        EmbedConnection conn = LOBStoredProcedure.getEmbedConnection();
        EmbedBlob blob = conn.createBlob();
        int locator = blob.getLocator();
        conn.closingNestedConnection();
        return locator;
    }

    public static void BLOBRELEASELOCATOR(int LOCATOR) throws SQLException {
        EmbedConnection conn = LOBStoredProcedure.getEmbedConnection();
        Object blob = conn.getLOBMapping(LOCATOR);
        if (blob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        ((EngineLOB)blob).free();
        conn.removeLOBMapping(LOCATOR);
        conn.closingNestedConnection();
    }

    public static long BLOBGETPOSITIONFROMLOCATOR(int LOCATOR, int searchLocator, long pos) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).position(LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(searchLocator), pos);
    }

    public static long BLOBGETPOSITIONFROMBYTES(int LOCATOR, byte[] searchBytes, long pos) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).position(searchBytes, pos);
    }

    public static long BLOBGETLENGTH(int LOCATOR) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).length();
    }

    public static byte[] BLOBGETBYTES(int LOCATOR, long pos, int len) throws SQLException {
        len = Math.min(len, 32672);
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).getBytes(pos, len);
    }

    public static void BLOBSETBYTES(int LOCATOR, long pos, int len, byte[] replaceBytes) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).setBytes(pos, replaceBytes, 0, len);
    }

    public static void BLOBTRUNCATE(int LOCATOR, long length) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(LOCATOR).truncate(length);
    }

    private static Blob getBlobObjectCorrespondingtoLOCATOR(int LOCATOR) throws SQLException {
        EmbedConnection conn = LOBStoredProcedure.getEmbedConnection();
        Blob blob = (Blob)conn.getLOBMapping(LOCATOR);
        conn.closingNestedConnection();
        if (blob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return blob;
    }

    private static EmbedConnection getEmbedConnection() throws SQLException {
        return (EmbedConnection)DriverManager.getConnection("jdbc:default:connection");
    }

    private static SQLException newSQLException(String messageId) {
        return Util.generateCsSQLException(messageId);
    }
}

