/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.GenericColumnDescriptor;
import java.sql.SQLException;

public class EmbedResultSetMetaData
implements TableMetaData {
    private final ResultColumnDescriptor[] columnInfo;
    private final TObjectIntHashMap columnNameToPosition;
    private boolean qualifiedNamesPopulated;
    private int schemaVersion;

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        return interfaces.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        try {
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw Util.generateCsSQLException("XJ128.S", interfaces);
        }
    }

    public final short primaryKey(int column, EngineConnection conn) throws SQLException {
        this.validColumnNumber(column);
        ResultColumnDescriptor rcd = this.columnInfo[column - 1];
        try {
            short pks = rcd.primaryKey(conn);
            return pks > 0 ? pks : (short)0;
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    public EmbedResultSetMetaData(ResultColumnDescriptor[] columnInfo) {
        this.columnInfo = columnInfo;
        this.columnNameToPosition = null;
    }

    public EmbedResultSetMetaData(ResultColumnDescriptor[] columnInfo, boolean forTableMetaData, int schemaVersion) {
        this.columnInfo = columnInfo;
        if (forTableMetaData) {
            this.columnNameToPosition = new TObjectIntHashMap(columnInfo.length);
            int columnPos = 1;
            for (ResultColumnDescriptor rcd : columnInfo) {
                String columnName = rcd.getName();
                if (columnName != null) {
                    this.columnNameToPosition.putIfAbsent((Object)columnName, columnPos, 0);
                }
                ++columnPos;
            }
        } else {
            this.columnNameToPosition = null;
        }
        this.schemaVersion = schemaVersion;
    }

    @Override
    public int getColumnPosition(String columnName) throws SQLException {
        if (this.columnNameToPosition != null && columnName != null) {
            int column = this.columnNameToPosition.get((Object)columnName);
            if (column > 0) {
                return column;
            }
            String ucolumnName = StringUtil.SQLToUpperCase(columnName);
            column = this.columnNameToPosition.get((Object)ucolumnName);
            if (column > 0) {
                return column;
            }
            if (this.populateQualifiedColumnNames()) {
                column = this.columnNameToPosition.get((Object)columnName);
                if (column > 0) {
                    return column;
                }
                column = this.columnNameToPosition.get((Object)ucolumnName);
                if (column > 0) {
                    return column;
                }
            }
        }
        throw Util.generateCsSQLException("42X04", columnName);
    }

    @Override
    public int getTableColumnPosition(int columnPosition) {
        return columnPosition;
    }

    public ResultColumnDescriptor getColumnDescriptor(int column) throws SQLException {
        this.validColumnNumber(column);
        return this.columnInfo[column - 1];
    }

    public final boolean isTableReadOnly() {
        return this.columnNameToPosition != null;
    }

    public final boolean isDefiniteWritable_(int column) {
        return false;
    }

    @Override
    public int getDeclaredColumnWidth(int column) throws SQLException {
        return this.getColumnTypeDescriptor(column).getMaximumWidth();
    }

    @Override
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    private boolean populateQualifiedColumnNames() {
        if (this.columnInfo != null && !this.qualifiedNamesPopulated) {
            int columnPos = 1;
            for (ResultColumnDescriptor rcd : this.columnInfo) {
                String columnName = rcd.getName();
                String tableName = rcd.getSourceTableName();
                if (tableName != null && tableName.length() > 0) {
                    this.columnNameToPosition.putIfAbsent((Object)(tableName + '.' + columnName), columnPos, 0);
                    String schemaName = rcd.getSourceSchemaName();
                    if (schemaName != null && schemaName.length() > 0) {
                        this.columnNameToPosition.putIfAbsent((Object)(schemaName + '.' + tableName + '.' + columnName), columnPos, 0);
                    }
                }
                ++columnPos;
            }
            this.qualifiedNamesPopulated = true;
            return true;
        }
        return false;
    }

    @Override
    public final int getColumnCount() {
        return this.columnInfo.length;
    }

    @Override
    public final boolean isAutoIncrement(int column) throws SQLException {
        this.validColumnNumber(column);
        ResultColumnDescriptor rcd = this.columnInfo[column - 1];
        return rcd.isAutoincrement();
    }

    @Override
    public final boolean isCaseSensitive(int column) throws SQLException {
        return DataTypeUtilities.isCaseSensitive(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final boolean isSearchable(int column) throws SQLException {
        this.validColumnNumber(column);
        return true;
    }

    @Override
    public final boolean isCurrency(int column) throws SQLException {
        return DataTypeUtilities.isCurrency(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final int isNullable(int column) throws SQLException {
        return DataTypeUtilities.isNullable(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final boolean isSigned(int column) throws SQLException {
        return DataTypeUtilities.isSigned(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final int getColumnDisplaySize(int column) throws SQLException {
        return DataTypeUtilities.getColumnDisplaySize(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final String getColumnLabel(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getName();
        return s == null ? "Column" + Integer.toString(column) : s;
    }

    @Override
    public final String getColumnName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getName();
        return s == null ? "" : s;
    }

    @Override
    public final String getSchemaName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getSourceSchemaName();
        return s == null ? "" : s;
    }

    @Override
    public final int getPrecision(int column) throws SQLException {
        return DataTypeUtilities.getDigitPrecision(this.getColumnTypeDescriptor(column));
    }

    @Override
    public final int getScale(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getScale();
    }

    @Override
    public final String getTableName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getSourceTableName();
        return s == null ? "" : s;
    }

    @Override
    public final String getCatalogName(int column) throws SQLException {
        this.validColumnNumber(column);
        return "";
    }

    @Override
    public final int getColumnType(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getTypeId().getJDBCTypeId();
    }

    @Override
    public final String getColumnTypeName(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getTypeId().getSQLTypeName();
    }

    @Override
    public final boolean isReadOnly(int column) throws SQLException {
        this.validColumnNumber(column);
        return this.isTableReadOnly();
    }

    @Override
    public final boolean isWritable(int column) throws SQLException {
        this.validColumnNumber(column);
        return this.columnInfo[column - 1].updatableByCursor();
    }

    @Override
    public final boolean isDefinitelyWritable(int column) throws SQLException {
        this.validColumnNumber(column);
        return this.isDefiniteWritable_(column);
    }

    private void validColumnNumber(int column) throws SQLException {
        if (column < 1 || column > this.getColumnCount()) {
            throw Util.generateCsSQLException("S0022", new Integer(column));
        }
    }

    private DataTypeDescriptor getColumnTypeDescriptor(int column) throws SQLException {
        this.validColumnNumber(column);
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        return cd.getType();
    }

    @Override
    public final String getColumnClassName(int column) throws SQLException {
        return this.getColumnTypeDescriptor(column).getTypeId().getResultSetMetaDataTypeName();
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, int jdcbTypeId, boolean nullable) {
        return new GenericColumnDescriptor(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdcbTypeId, nullable));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, int jdcbTypeId, boolean nullable, int length) {
        return new GenericColumnDescriptor(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdcbTypeId, nullable, length));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, DataTypeDescriptor dtd) {
        return new GenericColumnDescriptor(name, dtd);
    }
}

