/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import javax.transaction.xa.Xid;

class DRDAXid
implements Xid {
    private final int format_id;
    private final byte[] global_id;
    private final byte[] branch_id;

    DRDAXid(int formatid, byte[] globalid, byte[] branchid) {
        this.format_id = formatid;
        this.global_id = globalid;
        this.branch_id = branchid;
    }

    @Override
    public int getFormatId() {
        return this.format_id;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.global_id;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branch_id;
    }

    public String toString() {
        String s = "{DRDAXid: formatId(" + this.format_id + "), globalTransactionId(" + DRDAXid.convertToHexString(this.global_id) + ")branchQualifier(" + DRDAXid.convertToHexString(this.branch_id) + ")";
        return s;
    }

    private static String convertToHexString(byte[] buf) {
        if (buf == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        str.append("0x");
        for (int i = 0; i < buf.length; ++i) {
            int byteVal = buf[i] & 0xFF;
            String val = Integer.toHexString(byteVal);
            if (val.length() < 2) {
                str.append("0");
            }
            str.append(val);
        }
        return str.toString();
    }
}

