/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.spark.unsafe.Platform;

abstract class BinaryDecimal
extends NumberDataType
implements VariableSizeDataValue {
    protected byte[] data2c;
    protected int sqlScale;

    BinaryDecimal() {
    }

    @Override
    public final int typeToBigDecimal() {
        return 3;
    }

    @Override
    public final int typePrecedence() {
        return 70;
    }

    @Override
    public final String getTypeName() {
        return "DECIMAL";
    }

    @Override
    public final int getTypeFormatId() {
        return 200;
    }

    @Override
    public boolean isNull() {
        return this.data2c == null;
    }

    @Override
    public void restoreToNull() {
        this.data2c = null;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && (this.data2c[0] & 0x80) != 0;
    }

    @Override
    public void setValue(long theValue) {
        byte[] rd = this.data2c;
        if (rd == null || rd.length < 8) {
            rd = new byte[]{(byte)(theValue >>> 56), (byte)(theValue >>> 48), (byte)(theValue >>> 40), (byte)(theValue >>> 32), (byte)(theValue >>> 24), (byte)(theValue >>> 16), (byte)(theValue >>> 8), (byte)theValue};
        }
        this.data2c = rd;
        this.sqlScale = 0;
        try {
            if (theValue != this.getLong()) {
                SanityManager.THROWASSERT((String)("BinaryDecimal invalid long conversion before reduce in " + theValue + " out " + this.getLong()));
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((Throwable)se);
        }
        this.data2c = BinaryDecimal.reduceBytes2c(rd, 0, 8);
        this.sqlScale = 0;
        try {
            if (theValue != this.getLong()) {
                SanityManager.THROWASSERT((String)("BinaryDecimal invalid long conversion after reduce in " + theValue + " out " + this.getLong()));
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((Throwable)se);
        }
    }

    @Override
    public final void setValue(int theValue) {
        byte[] rd = this.data2c;
        if (rd == null || rd.length < 4) {
            rd = new byte[]{(byte)(theValue >>> 24), (byte)(theValue >>> 16), (byte)(theValue >>> 8), (byte)theValue};
        }
        this.data2c = BinaryDecimal.reduceBytes2c(rd, 0, 4);
        this.sqlScale = 0;
    }

    @Override
    public void setValue(boolean theValue) {
        int intValue = theValue ? 1 : 0;
        this.setValue(intValue);
    }

    @Override
    public final void setValue(double theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(theValue));
    }

    @Override
    public final void setValue(float theValue) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(theValue));
    }

    private void setCoreValue(double theValue) throws StandardException {
        this.setValue(Double.toString(theValue));
    }

    @Override
    public void setValue(Number theValue) throws StandardException {
        if (theValue != null && !(theValue instanceof Long)) {
            SanityManager.THROWASSERT((String)("BinaryDecimal.setValue(Number) passed a " + theValue.getClass()));
        }
        if (theValue == null) {
            this.setToNull();
        } else {
            this.setValue(theValue.longValue());
        }
    }

    @Override
    protected void setFrom(DataValueDescriptor dvd) throws StandardException {
        switch (dvd.typeToBigDecimal()) {
            case 1: 
            case 3: {
                this.setValue(dvd.getString());
                break;
            }
            case -5: {
                this.setValue(dvd.getLong());
                break;
            }
            default: {
                super.setFrom(dvd);
            }
        }
    }

    @Override
    public final int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                return (int)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
    }

    @Override
    public final byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -128L && lv <= 127L) {
                return (byte)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
    }

    @Override
    public final short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long lv = this.getLong();
            if (lv >= -32768L && lv <= 32767L) {
                return (short)lv;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", (Object)"SMALLINT", (Object)null);
    }

    @Override
    public final NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        return this.plusNN(addend1, addend2, result);
    }

    @Override
    public final NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        return this.timesNN(left, right, result);
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        return this.divide(dividend, divisor, result, -1);
    }

    @Override
    public final NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result, int scale) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        return this.divideNN(dividend, divisor, result, scale);
    }

    @Override
    public final NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = (NumberDataValue)this.getNewNull();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        return this.minusNN(left, right, result);
    }

    public NumberDataValue minusNN(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        return this.plusNN(left, right.minus(result), result);
    }

    public abstract NumberDataValue timesNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue plusNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3) throws StandardException;

    public abstract NumberDataValue divideNN(NumberDataValue var1, NumberDataValue var2, NumberDataValue var3, int var4) throws StandardException;

    private static byte[] reduceBytes2c(byte[] rd, int offset, int dataLength) {
        int leading;
        for (leading = 0; leading < dataLength - 1 && rd[offset + leading] == 0 && (rd[offset + leading + 1] & 0x80) == 0; ++leading) {
        }
        if (leading == 0) {
            while (leading < dataLength - 1 && rd[offset + leading] == -1 && (rd[offset + leading + 1] & 0xFFFFFF80) != 0) {
                ++leading;
            }
        }
        if (leading != 0 || rd.length != dataLength) {
            byte[] reduced = new byte[dataLength - leading];
            System.arraycopy(rd, offset + leading, reduced, 0, reduced.length);
            return reduced;
        }
        return rd;
    }

    @Override
    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        return this.sqlScale;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeByte(this.sqlScale);
        out.writeByte(this.data2c.length);
        out.write(this.data2c);
    }

    @Override
    public void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeByte(this.sqlScale);
        DataSerializer.writeByteArray((byte[])this.data2c, (DataOutput)dos);
    }

    @Override
    public void fromDataForOptimizedResultHolder(DataInput dis) throws IOException {
        this.sqlScale = dis.readByte();
        this.data2c = DataSerializer.readByteArray((DataInput)dis);
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) {
        if (!this.isNull()) {
            return this.data2c.length + 1;
        }
        return 0;
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        outBytes[offset] = (byte)this.sqlScale;
        System.arraycopy(this.data2c, 0, outBytes, offset + 1, this.data2c.length);
        return this.data2c.length + 1;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        this.data2c = new byte[columnWidth - 1];
        this.sqlScale = inBytes[offset++];
        System.arraycopy(inBytes, offset, this.data2c, 0, columnWidth - 1);
        return columnWidth;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        int numBytes = columnWidth - 1;
        this.data2c = new byte[numBytes];
        this.sqlScale = Platform.getByte(null, (long)memOffset++);
        UnsafeMemoryChunk.readUnsafeBytes((long)memOffset, (byte[])this.data2c, (int)numBytes);
        return columnWidth;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        int typeId = this.getTypeFormatId();
        hash = ResolverUtils.addByteToBucketHash((byte)((byte)this.sqlScale), (int)hash, (int)typeId);
        hash = ResolverUtils.addBytesToBucketHash((byte[])this.data2c, (int)hash, (int)typeId);
        return hash;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.sqlScale = in.readUnsignedByte();
        int size = in.readUnsignedByte();
        if (this.data2c == null || size != this.data2c.length) {
            this.data2c = new byte[size];
        }
        in.readFully(this.data2c);
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.sqlScale = in.readUnsignedByte();
        int size = in.readUnsignedByte();
        if (this.data2c == null || size != this.data2c.length) {
            this.data2c = new byte[size];
        }
        in.readFully(this.data2c);
    }

    @Override
    public final int getLength() {
        return this.getDecimalValuePrecision();
    }

    @Override
    public DataValueDescriptor getClone() {
        BinaryDecimal dvd = (BinaryDecimal)this.getNewNull();
        if (this.data2c != null) {
            dvd.data2c = new byte[this.data2c.length];
            System.arraycopy(this.data2c, 0, dvd.data2c, 0, this.data2c.length);
            dvd.sqlScale = this.sqlScale;
        }
        return dvd;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
        this.setValue(resultSet.getString(colNumber));
    }

    @Override
    public int estimateMemoryUsage() {
        return 0;
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        try {
            return (int)this.getLong();
        }
        catch (StandardException se) {
            return 0;
        }
    }
}

