/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DDdependableFinder;

public class TablePermsDescriptor
extends PermissionsDescriptor {
    private UUID tableUUID;
    private String tableName;
    private String selectPriv;
    private String deletePriv;
    private String insertPriv;
    private String updatePriv;
    private String referencesPriv;
    private String triggerPriv;
    private String alterPriv;

    public TablePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID, String selectPriv, String deletePriv, String insertPriv, String updatePriv, String referencesPriv, String triggerPriv, String alterPriv) throws StandardException {
        super(dd, grantee, grantor);
        this.tableUUID = tableUUID;
        this.selectPriv = selectPriv;
        this.deletePriv = deletePriv;
        this.insertPriv = insertPriv;
        this.updatePriv = updatePriv;
        this.referencesPriv = referencesPriv;
        this.triggerPriv = triggerPriv;
        this.alterPriv = alterPriv;
        if (tableUUID != null) {
            this.tableName = dd.getTableDescriptor(tableUUID).getName();
        }
    }

    public TablePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID) throws StandardException {
        this(dd, grantee, grantor, tableUUID, null, null, null, null, null, null, null);
    }

    public TablePermsDescriptor(DataDictionary dd, UUID tablePermsUUID) throws StandardException {
        this(dd, null, null, null, null, null, null, null, null, null, null);
        this.oid = tablePermsUUID;
    }

    @Override
    public int getCatalogNumber() {
        return 16;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public String getSelectPriv() {
        return this.selectPriv;
    }

    public String getDeletePriv() {
        return this.deletePriv;
    }

    public String getInsertPriv() {
        return this.insertPriv;
    }

    public String getUpdatePriv() {
        return this.updatePriv;
    }

    public String getReferencesPriv() {
        return this.referencesPriv;
    }

    public String getTriggerPriv() {
        return this.triggerPriv;
    }

    public String getAlterPriv() {
        return this.alterPriv;
    }

    public String toString() {
        return "tablePerms: grantee=" + this.getGrantee() + ",tablePermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",ldapGroup=" + this.getLdapGroup() + ",tableUUID=" + this.getTableUUID() + ",selectPriv=" + this.getSelectPriv() + ",deletePriv=" + this.getDeletePriv() + ",insertPriv=" + this.getInsertPriv() + ",updatePriv=" + this.getUpdatePriv() + ",referencesPriv=" + this.getReferencesPriv() + ",triggerPriv=" + this.getTriggerPriv() + ",alterPriv=" + this.getAlterPriv();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TablePermsDescriptor)) {
            return false;
        }
        TablePermsDescriptor otherTablePerms = (TablePermsDescriptor)other;
        return super.keyEquals(otherTablePerms) && this.tableUUID.equals(otherTablePerms.tableUUID);
    }

    public int hashCode() {
        return super.keyHashCode() + this.tableUUID.hashCode();
    }

    @Override
    public boolean checkOwner(String authorizationId) throws StandardException {
        SchemaDescriptor sd = this.getDataDictionary().getTableDescriptor(this.tableUUID).getSchemaDescriptor();
        String schemaOwner = sd.getAuthorizationId();
        return schemaOwner.equals(authorizationId) || Misc.checkLDAPGroupOwnership(sd.getSchemaName(), schemaOwner, authorizationId);
    }

    @Override
    public String getObjectName() {
        return "Table Privilege on " + this.tableName;
    }

    @Override
    public String getClassType() {
        return "TablePrivilege";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return new DDdependableFinder(462);
    }
}

