/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;

public abstract class PermissionsDescriptor
extends TupleDescriptor
implements Cloneable,
Provider {
    protected UUID oid;
    private String grantee;
    private final String grantor;
    private String ldapGroup;

    PermissionsDescriptor(DataDictionary dd, String grantee, String grantor) {
        super(dd);
        this.grantee = grantee;
        this.grantor = grantor;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            SanityManager.THROWASSERT((String)("Could not clone a " + this.getClass().getName()), (Throwable)cnse);
            return null;
        }
    }

    public abstract int getCatalogNumber();

    protected boolean keyEquals(PermissionsDescriptor other) {
        return this.grantee.equals(other.grantee);
    }

    protected int keyHashCode() {
        return this.grantee.hashCode();
    }

    public void setGrantee(String grantee) {
        this.grantee = grantee;
    }

    public final String getGrantee() {
        return this.grantee;
    }

    public final String getGrantor() {
        return this.grantor;
    }

    public UUID getUUID() {
        return this.oid;
    }

    public void setUUID(UUID oid) {
        this.oid = oid;
    }

    public abstract boolean checkOwner(String var1) throws StandardException;

    @Override
    public UUID getObjectID() {
        return this.oid;
    }

    @Override
    public boolean isDescriptorPersistent() {
        return true;
    }

    public String getLdapGroup() {
        return this.ldapGroup;
    }

    public void setLdapGroup(String ldapGroup) {
        this.ldapGroup = ldapGroup;
    }
}

