/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.UniqueTupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import java.util.Arrays;

public abstract class ConstraintDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Provider,
Dependent {
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int ALL = 3;
    public static final int SYSCONSTRAINTS_STATE_FIELD = 6;
    TableDescriptor table;
    final String constraintName;
    private final boolean deferrable;
    private final boolean initiallyDeferred;
    boolean isEnabled;
    private int[] referencedColumns;
    final UUID constraintId;
    private SchemaDescriptor schemaDesc;
    private ColumnDescriptorList colDL;

    ConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] referencedColumns, UUID constraintId, SchemaDescriptor schemaDesc, boolean isEnabled) {
        super(dataDictionary);
        this.table = table;
        this.constraintName = constraintName;
        this.deferrable = deferrable;
        this.initiallyDeferred = initiallyDeferred;
        this.referencedColumns = referencedColumns;
        this.constraintId = constraintId;
        this.schemaDesc = schemaDesc;
        this.isEnabled = isEnabled;
    }

    public UUID getTableId() {
        return this.table.getUUID();
    }

    @Override
    public UUID getUUID() {
        return this.constraintId;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public abstract int getConstraintType();

    public abstract UUID getConglomerateId();

    public String getConstraintText() {
        return null;
    }

    public boolean deferrable() {
        return this.deferrable;
    }

    public boolean initiallyDeferred() {
        return this.initiallyDeferred;
    }

    public int[] getReferencedColumns() {
        return this.referencedColumns;
    }

    public void setReferencedColumns(int[] referencedCols) {
        this.referencedColumns = referencedCols;
    }

    public void refreshDescriptors(TransactionController tc) throws StandardException {
        this.schemaDesc = this.getDataDictionary().getSchemaDescriptor(this.schemaDesc.getUUID(), tc);
        this.table = this.getDataDictionary().getTableDescriptor(this.getTableId());
        this.colDL = null;
        this.getColumnDescriptors();
    }

    public abstract boolean hasBackingIndex();

    public SchemaDescriptor getSchemaDescriptor() {
        return this.schemaDesc;
    }

    public int[] getKeyColumns() {
        return this.getReferencedColumns();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled() {
        this.isEnabled = true;
    }

    public void setDisabled() {
        this.isEnabled = false;
    }

    public boolean isReferenced() {
        return false;
    }

    public int getReferenceCount() {
        return 0;
    }

    public abstract boolean needsToFire(int var1, int[] var2);

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public ColumnDescriptorList getColumnDescriptors() throws StandardException {
        if (this.colDL == null) {
            DataDictionary dd = this.getDataDictionary();
            this.colDL = new ColumnDescriptorList();
            int[] refCols = this.getReferencedColumns();
            for (int i = 0; i < refCols.length; ++i) {
                this.colDL.add(this.table.getColumnDescriptor(refCols[i]));
            }
        }
        return this.colDL;
    }

    public boolean areColumnsComparable(ColumnDescriptorList otherColumns) throws StandardException {
        int index;
        ColumnDescriptorList myColDl = this.getColumnDescriptors();
        if (otherColumns.size() != myColDl.size()) {
            return false;
        }
        int mySize = myColDl.size();
        int otherSize = otherColumns.size();
        for (index = 0; index < mySize && index < otherSize; ++index) {
            ColumnDescriptor myColumn = myColDl.elementAt(index);
            ColumnDescriptor otherColumn = otherColumns.elementAt(index);
            if (!myColumn.getType().isExactTypeAndLengthMatch(otherColumn.getType())) break;
        }
        return index == mySize && index == otherSize;
    }

    public boolean columnIntersects(int[] columnArray) {
        return ConstraintDescriptor.doColumnsIntersect(this.getReferencedColumns(), columnArray);
    }

    static boolean doColumnsIntersect(int[] otherColumns, int[] referencedColumns) {
        if (otherColumns == null || referencedColumns == null) {
            return true;
        }
        for (int outer = 0; outer < referencedColumns.length; ++outer) {
            for (int inner = 0; inner < otherColumns.length; ++inner) {
                if (referencedColumns[outer] != otherColumns[inner]) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String tableDesc = "table: " + this.table.getQualifiedName() + "(" + this.table.getUUID() + "," + this.table.getTableType() + ")";
        return tableDesc + "\nconstraintName: " + this.constraintName + "\nconstraintId: " + this.constraintId + "\ndeferrable: " + this.deferrable + "\ninitiallyDeferred: " + this.initiallyDeferred + "\nreferencedColumns: " + Arrays.toString(this.referencedColumns) + "\nschemaDesc: " + this.schemaDesc + "\n";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(208);
    }

    @Override
    public String getObjectName() {
        return this.constraintName;
    }

    @Override
    public UUID getObjectID() {
        return this.constraintId;
    }

    @Override
    public String getClassType() {
        return "Constraint";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 44: {
                break;
            }
            default: {
                throw StandardException.newException("X0Y25.S", dm.getActionString(action), (Object)p.getObjectName(), (Object)"CONSTRAINT", (Object)this.constraintName);
            }
        }
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        if (action == 44) {
            ConglomerateDescriptor newBackingConglomCD = this.drop(lcc, true);
            if (newBackingConglomCD != null) {
                SanityManager.THROWASSERT((String)"Dropped shared conglomerate due to a REVOKE and found that a new conglomerate was needed to replace it...but that shouldn't happen!");
            }
            return;
        }
        if (action != 21 && action != 20 && action != 29 && action != 30) {
            DependencyManager dm = this.getDataDictionary().getDependencyManager();
            SanityManager.THROWASSERT((String)("makeInvalid(" + dm.getActionString(action) + ") not expected to get called"));
        }
    }

    public ConglomerateDescriptor drop(LanguageConnectionContext lcc, boolean clearDependencies) throws StandardException {
        ConglomerateDescriptor[] conglomDescs;
        DataDictionary dd = this.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        if (clearDependencies) {
            dm.clearDependencies(lcc, this);
        }
        dd.dropConstraintDescriptor(this, tc);
        ConglomerateDescriptor newBackingConglomCD = null;
        if (this.hasBackingIndex() && (conglomDescs = dd.getConglomerateDescriptors(this.getConglomerateId())).length != 0) {
            for (int i = 0; i < conglomDescs.length; ++i) {
                if (!conglomDescs[i].isConstraint()) continue;
                newBackingConglomCD = conglomDescs[i].drop(lcc, this.table);
                break;
            }
        }
        this.table.removeConstraintDescriptor(this);
        return newBackingConglomCD;
    }

    @Override
    public String getDescriptorName() {
        return this.constraintName;
    }

    @Override
    public String getDescriptorType() {
        return "Constraint";
    }
}

