/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.context;

import com.gemstone.gemfire.GemFireException;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.ErrorStringBuilder;
import com.pivotal.gemfirexd.internal.iapi.error.PassThroughException;
import com.pivotal.gemfirexd.internal.iapi.error.ShutdownException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.Context;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextImpl;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.LocaleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class ContextManager {
    private final ContextMap ctxTable = new ContextMap();
    private final ArrayList holder = new ArrayList();
    private Locale messageLocale;
    final ContextService owningCsf;
    private int logSeverityLevel;
    private HeaderPrintWriter errorStream;
    private ErrorStringBuilder errorStringBuilder;
    private boolean shutdown;
    private LocaleFinder finder;
    Thread activeThread;
    int activeCount;

    public final Thread getActiveThread() {
        return this.activeThread;
    }

    public void pushContext(Context newContext) {
        this.checkInterrupt();
        String contextId = newContext.getIdName();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        if (idStack == null) {
            idStack = new CtxStack();
            this.ctxTable.put(contextId, idStack);
        }
        idStack.push(newContext);
        this.holder.add(newContext);
    }

    public Context getContext(String contextId) {
        this.checkInterrupt();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        SanityManager.ASSERT((idStack == null || idStack.isEmpty() || idStack.top().getIdName().equals(contextId) ? 1 : 0) != 0);
        return idStack == null ? null : idStack.top();
    }

    public void popContext() {
        this.checkInterrupt();
        if (this.holder.isEmpty()) {
            return;
        }
        Context theContext = (Context)this.holder.remove(this.holder.size() - 1);
        String contextId = theContext.getIdName();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        SanityManager.ASSERT((idStack != null && !idStack.isEmpty() && idStack.top().getIdName() == contextId ? 1 : 0) != 0);
        idStack.pop();
    }

    void popContext(Context theContext) {
        this.checkInterrupt();
        SanityManager.ASSERT((!this.holder.isEmpty() ? 1 : 0) != 0);
        int contextIdx = this.holder.lastIndexOf(theContext);
        if (contextIdx < 0) {
            return;
        }
        this.holder.remove(contextIdx);
        String contextId = theContext.getIdName();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        idStack.remove(theContext);
    }

    public final boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public final List getContextStack(String contextId) {
        CtxStack cs = (CtxStack)this.ctxTable.get(contextId);
        return cs == null ? Collections.EMPTY_LIST : cs.getUnmodifiableList();
    }

    public boolean cleanupOnError(Throwable error) {
        boolean reportError;
        StandardException se;
        if (this.shutdown) {
            return true;
        }
        if (this.errorStringBuilder == null) {
            this.errorStringBuilder = new ErrorStringBuilder(this.errorStream.getHeader());
        }
        ThreadDeath seenThreadDeath = null;
        if (error instanceof ThreadDeath) {
            seenThreadDeath = (ThreadDeath)error;
        }
        if (error instanceof PassThroughException) {
            error = ((PassThroughException)error).getException();
        }
        if (error instanceof GemFireException && (se = Misc.processKnownGemFireException((GemFireException)error, error, "cleanupOnError", false)) != null) {
            error = se;
        }
        if (reportError = this.reportError(error)) {
            ContextImpl sc;
            ContextImpl lcc = null;
            StringBuilder sb = null;
            if (!this.shutdown && (lcc = (ContextImpl)this.getContext("LanguageConnectionContext")) != null) {
                sb = lcc.appendErrorInfo();
            }
            if (!this.shutdown && (sc = (ContextImpl)this.getContext("StatementContext")) != null && (sb = sc.appendErrorInfo()) != null) {
                this.errorStringBuilder.appendln(sb.toString());
            }
        }
        block4: while (true) {
            int errorSeverity;
            int n = errorSeverity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 0;
            if (reportError) {
                if (this.printStackTrace(error)) {
                    this.errorStringBuilder.stackTrace(error);
                } else {
                    this.errorStringBuilder.appendln(error.toString());
                }
                this.flushErrorString();
            }
            boolean lastHandler = false;
            for (int index = this.holder.size() - 1; index >= 0; --index) {
                try {
                    if (lastHandler) break block4;
                    Context ctx = (Context)this.holder.get(index);
                    lastHandler = ctx.isLastHandler(errorSeverity);
                    ctx.cleanupOnError(error);
                    continue;
                }
                catch (StandardException se2) {
                    if (error instanceof StandardException && se2.getSeverity() > ((StandardException)error).getSeverity()) {
                        error = se2;
                        reportError = this.reportError(se2);
                        if (!reportError) continue block4;
                        this.errorStream.println("New exception raised during cleanup " + error.getMessage());
                        this.errorStream.flush();
                        continue block4;
                    }
                    if (!this.reportError(se2)) continue;
                    this.errorStringBuilder.appendln("Less severe exception raised during cleanup (ignored) " + se2.getMessage());
                    this.errorStringBuilder.stackTrace(se2);
                    this.flushErrorString();
                    continue;
                }
                catch (IndexOutOfBoundsException se2) {
                    continue;
                }
                catch (Throwable t) {
                    reportError = this.reportError(t);
                    if (error instanceof StandardException) {
                        error = t;
                        if (!reportError) continue block4;
                        this.errorStream.println("New exception raised during cleanup " + error.getMessage());
                        this.errorStream.flush();
                        continue block4;
                    }
                    if (reportError) {
                        this.errorStringBuilder.appendln("Equally severe exception raised during cleanup (ignored) " + t.getMessage());
                        this.errorStringBuilder.stackTrace(t);
                        this.flushErrorString();
                    }
                    if (!(t instanceof ThreadDeath)) continue;
                    if (seenThreadDeath != null) {
                        throw seenThreadDeath;
                    }
                    seenThreadDeath = (ThreadDeath)t;
                }
            }
            break;
        }
        if (reportError) {
            this.errorStream.flush();
        }
        if (seenThreadDeath != null) {
            throw seenThreadDeath;
        }
        return false;
    }

    synchronized boolean setInterrupted(Context c) {
        boolean interruptMe;
        boolean bl = interruptMe = c == null || this.holder.contains(c);
        if (interruptMe) {
            this.shutdown = true;
        }
        return interruptMe;
    }

    private void checkInterrupt() {
        if (this.shutdown) {
            throw new ShutdownException();
        }
    }

    public void setLocaleFinder(LocaleFinder finder) {
        this.finder = finder;
    }

    public void setMessageLocale(String localeID) throws StandardException {
        this.messageLocale = Monitor.getLocaleFromString(localeID);
    }

    public Locale getMessageLocale() {
        if (this.messageLocale != null) {
            return this.messageLocale;
        }
        if (this.finder != null) {
            try {
                return this.finder.getCurrentLocale();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        return Locale.getDefault();
    }

    private void flushErrorString() {
        this.errorStream.print(this.errorStringBuilder.get().toString());
        this.errorStream.flush();
        this.errorStringBuilder.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reportError(Throwable t) {
        if (t instanceof StandardException) {
            StandardException se = (StandardException)t;
            switch (se.report()) {
                case 0: {
                    int level = se.getSeverity();
                    ContextManager contextManager = this;
                    synchronized (contextManager) {
                        if (this.logSeverityLevel == -1) {
                            this.logSeverityLevel = PropertyUtil.getSystemInt("gemfirexd.stream.error.logSeverityLevel", this.errorStream.getLogSeverityLevel());
                        }
                    }
                    return level >= this.logSeverityLevel || level == 0;
                }
                case 1: {
                    return false;
                }
            }
            return true;
        }
        return !(t instanceof ShutdownException);
    }

    private boolean printStackTrace(Throwable error) {
        return this.errorStream == null || this.errorStream.printStackTrace(error, this.logSeverityLevel);
    }

    ContextManager(ContextService csf, HeaderPrintWriter stream) {
        this.errorStream = stream;
        this.owningCsf = csf;
        this.logSeverityLevel = -1;
    }

    static final class ContextMap
    extends HashMap<Object, Object> {
        private static final long serialVersionUID = 5096306325259730193L;
        private Object lcc;
        private Object tranCtx;
        private Object connCtx;
        private Object stmtCtx;
        private Object compCtx;

        ContextMap() {
            super(32);
        }

        @Override
        public final Object get(Object contextId) {
            if (contextId == "LanguageConnectionContext") {
                return this.lcc;
            }
            if (contextId == "JDBC_ConnectionContext") {
                return this.connCtx;
            }
            if (contextId == "UserTransaction") {
                return this.tranCtx;
            }
            if (contextId == "StatementContext") {
                return this.stmtCtx;
            }
            if (contextId == "CompilerContext") {
                return this.compCtx;
            }
            return super.get(contextId);
        }

        @Override
        public final Object put(Object contextId, Object context) {
            if (contextId == "LanguageConnectionContext") {
                Object oldVal = this.lcc;
                this.lcc = context;
                return oldVal;
            }
            if (contextId == "JDBC_ConnectionContext") {
                Object oldVal = this.connCtx;
                this.connCtx = context;
                return oldVal;
            }
            if (contextId == "UserTransaction") {
                Object oldVal = this.tranCtx;
                this.tranCtx = context;
                return oldVal;
            }
            if (contextId == "StatementContext") {
                Object oldVal = this.stmtCtx;
                this.stmtCtx = context;
                return oldVal;
            }
            if (contextId == "CompilerContext") {
                Object oldVal = this.compCtx;
                this.compCtx = context;
                return oldVal;
            }
            return super.put(contextId, context);
        }

        @Override
        public final Object remove(Object contextId) {
            if (contextId == "LanguageConnectionContext") {
                Object oldVal = this.lcc;
                this.lcc = null;
                return oldVal;
            }
            if (contextId == "JDBC_ConnectionContext") {
                Object oldVal = this.connCtx;
                this.connCtx = null;
                return oldVal;
            }
            if (contextId == "UserTransaction") {
                Object oldVal = this.tranCtx;
                this.tranCtx = null;
                return oldVal;
            }
            if (contextId == "StatementContext") {
                Object oldVal = this.stmtCtx;
                this.stmtCtx = null;
                return oldVal;
            }
            if (contextId == "CompilerContext") {
                Object oldVal = this.compCtx;
                this.compCtx = null;
                return oldVal;
            }
            return super.remove(contextId);
        }

        @Override
        public final boolean containsKey(Object contextId) {
            if (contextId == "LanguageConnectionContext") {
                return this.lcc != null;
            }
            if (contextId == "JDBC_ConnectionContext") {
                return this.connCtx != null;
            }
            if (contextId == "UserTransaction") {
                return this.tranCtx != null;
            }
            if (contextId == "StatementContext") {
                return this.stmtCtx != null;
            }
            if (contextId == "CompilerContext") {
                return this.compCtx != null;
            }
            return super.containsKey(contextId);
        }
    }

    private static final class CtxStack {
        private final ArrayList stack_ = new ArrayList(4);
        private final List view_ = Collections.unmodifiableList(this.stack_);
        private Context top_ = null;

        private CtxStack() {
        }

        void push(Context context) {
            this.stack_.add(context);
            this.top_ = context;
        }

        void pop() {
            this.stack_.remove(this.stack_.size() - 1);
            this.top_ = this.stack_.isEmpty() ? null : (Context)this.stack_.get(this.stack_.size() - 1);
        }

        void remove(Context context) {
            if (context == this.top_) {
                this.pop();
                return;
            }
            this.stack_.remove(this.stack_.lastIndexOf(context));
        }

        Context top() {
            return this.top_;
        }

        boolean isEmpty() {
            return this.stack_.isEmpty();
        }

        List getUnmodifiableList() {
            return this.view_;
        }
    }
}

