/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.pivotal.gemfirexd.internal.engine.store.NonUpdatableRowsResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class SingleColumnLongResultSet
extends NonUpdatableRowsResultSet {
    private final long v;

    public SingleColumnLongResultSet(long v) {
        this.v = v;
    }

    @Override
    public boolean next() throws SQLException {
        return false;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return Long.toString(this.v);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.v != 0L;
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            if (this.v >= -128L && this.v <= 127L) {
                return (byte)this.v;
            }
            throw this.outOfRangeException("BIGINT", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            if (this.v >= -32768L && this.v <= 32767L) {
                return (short)this.v;
            }
            throw this.outOfRangeException("BIGINT", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            if (this.v >= Integer.MIN_VALUE && this.v <= Integer.MAX_VALUE) {
                return (int)this.v;
            }
            throw this.outOfRangeException("BIGINT", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.v;
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.v;
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.v;
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "BigDecimal", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "byte[]", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Date", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Time", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Timestamp", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "InputStream(ASCII)", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "InputStream(Unicode)", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "InputStream(BINARY)", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "InputStream(CHAR)", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "BigDecimal", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Blob", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Clob", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Date", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Time", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex == 1) {
            throw this.dataConversionException("long", "Timestamp", columnIndex);
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.v;
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        throw this.columnNotFoundException(columnLabel);
    }
}

