/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;

final class HasAggregateVisitor
extends VisitorAdaptor {
    private boolean isAggregateFound = false;

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return this.isAggregateFound;
    }

    public boolean hasAggregates() {
        return this.isAggregateFound;
    }

    public void reset() {
        this.isAggregateFound = false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (AggregateNode.class.isInstance(node)) {
            this.isAggregateFound = true;
            return node;
        }
        if (ColumnReference.class.isInstance(node)) {
            ColumnReference cr = (ColumnReference)node;
            this.isAggregateFound = cr.getColumnName().startsWith("##aggregate result");
            if (this.isAggregateFound) {
                return node;
            }
            cr.getSource().accept(this);
        }
        return node;
    }
}

