/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.locks;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.LeaseExpiredException;
import com.gemstone.gemfire.distributed.LockNotHeldException;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyMonitor;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyMonitorManager;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockReleaseProcessor;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockRequestProcessor;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLocalLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdReadWriteLock;
import com.pivotal.gemfirexd.internal.engine.locks.impl.GfxdRWLockDependencyMonitor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GfxdDRWLockService
extends DLockService
implements GfxdLockService,
MembershipListener {
    private static final Map<String, GfxdDRWLockService> rwServices = new HashMap<String, GfxdDRWLockService>();
    private final GfxdLocalLockService localLockMap;
    private final MembershipListener beforeMemberDeparted;
    private final boolean traceOn;

    protected GfxdDRWLockService(String serviceName, DistributedSystem ds, boolean isDistributed, boolean destroyOnDisconnect, boolean automateFreeResources, long maxVMWriteLockWaitTime, GfxdReadWriteLock lockTemplate, MembershipListener beforeMemberDeparted) {
        super(serviceName, ds, isDistributed, destroyOnDisconnect, automateFreeResources);
        this.localLockMap = new GfxdLocalLockService(serviceName, lockTemplate, maxVMWriteLockWaitTime);
        this.beforeMemberDeparted = beforeMemberDeparted;
        this.traceOn = this.getLogWriter().fineEnabled() || GemFireXDUtils.TraceLock || SanityManager.TRACE_ON((String)"TraceLock_DD");
        this.getDistributionManager().addMembershipListener((MembershipListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GfxdDRWLockService create(String serviceName, DistributedSystem ds, boolean distributed, boolean destroyOnDisconnect, boolean automateFreeResources, long maxVMLockWaitTime, GfxdReadWriteLock lockTemplate, MembershipListener beforeMemberDeparted) throws IllegalArgumentException, IllegalStateException {
        Object object = creationLock;
        synchronized (object) {
            Map map = services;
            synchronized (map) {
                ds.getCancelCriterion().checkCancelInProgress(null);
                GfxdDRWLockService.readyThreadGroup();
                if (services.get(serviceName) != null) {
                    throw new IllegalArgumentException(LocalizedStrings.DLockService_SERVICE_NAMED_0_ALREADY_CREATED.toLocalizedString(new Object[]{serviceName}));
                }
                return GfxdDRWLockService.basicCreate(serviceName, ds, distributed, destroyOnDisconnect, automateFreeResources, maxVMLockWaitTime, lockTemplate, beforeMemberDeparted);
            }
        }
    }

    private static GfxdDRWLockService basicCreate(String serviceName, DistributedSystem ds, boolean isDistributed, boolean destroyOnDisconnect, boolean automateFreeResources, long maxVMLockWaitTime, GfxdReadWriteLock lockTemplate, MembershipListener beforeMemberDeparted) throws IllegalArgumentException {
        GfxdDRWLockService svc;
        Assert.assertTrue((boolean)Thread.holdsLock(services));
        LogWriterI18n log = ds.getLogWriter().convertToLogWriterI18n();
        if (log.fineEnabled()) {
            log.fine("About to create DistributedLockService <" + serviceName + ">");
        }
        if ((svc = new GfxdDRWLockService(serviceName, ds, isDistributed, destroyOnDisconnect, automateFreeResources, maxVMLockWaitTime, lockTemplate, beforeMemberDeparted)).init(log)) {
            rwServices.put(svc.getName(), svc);
        }
        return svc;
    }

    public long getMaxVMWriteLockWait() {
        return this.localLockMap.maxVMWriteLockWait;
    }

    @Override
    public boolean readLock(Object name, Object owner, long waitTimeMillis) {
        return this.localLockMap.readLock(name, owner, waitTimeMillis);
    }

    @Override
    public boolean readLock(GfxdLockable lockable, Object owner, long waitTimeMillis) {
        return this.localLockMap.readLock(lockable, owner, waitTimeMillis);
    }

    @Override
    public void readUnlock(Object name) {
        this.localLockMap.readUnlock(name);
    }

    @Override
    public void readUnlock(GfxdLockable lockable) {
        this.localLockMap.readUnlock(lockable);
    }

    @Override
    public GfxdLockService.ReadLockState hasReadLock(Object name) {
        this.checkDestroyed();
        return this.localLockMap.hasReadLock(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean writeLock(Object name, Object owner, long waitTimeMillis, long leaseTimeMillis) {
        block13: {
            if (owner != null && !(owner instanceof GfxdLocalLockService.DistributedLockOwner)) {
                throw new IllegalArgumentException("unexpected distributed lock owner of class " + owner.getClass().getName() + ": " + owner.toString() + ", expected an instance of DistributedLockOwner");
            }
            logger = this.getLogWriter();
            if (this.traceOn) {
                logger.info(LocalizedStrings.DEBUG, (Object)(this.toString() + " writeLock for object [" + name + "] with owner=" + owner + ", timeout=" + waitTimeMillis + ", leaseTime=" + leaseTimeMillis));
            }
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
            responseCode = GfxdResponseCode.GRANT(1);
            failureEx = null;
            this.localLockMap.getOrCreateLock(name);
            if (super.lock(name, waitTimeMillis, leaseTimeMillis)) {
                try {
                    response = GfxdDRWLockRequestProcessor.requestDRWLock(this, name, owner, this.getDistributionManager(), waitTimeMillis, true, logger);
                    if (response != null && (responseCode = response.getResponseCode()).isException()) {
                        failureEx = response.getReplyException();
                    }
                    ** if (failureEx == null) goto lbl-1000
                }
                catch (InterruptedException ie) {
                    try {
                        Thread.currentThread().interrupt();
                        responseCode = GfxdResponseCode.EXCEPTION;
                        failureEx = ie;
                        ** if (failureEx == null) goto lbl-1000
                    }
                    catch (Throwable var11_10) {
                        if (failureEx != null) {
                            Misc.checkIfCacheClosing(failureEx);
                        }
                        throw var11_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        Misc.checkIfCacheClosing(failureEx);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block13;
                    }
                }
lbl-1000:
                // 1 sources

                {
                    Misc.checkIfCacheClosing(failureEx);
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                }
            }
            responseCode = GfxdResponseCode.TIMEOUT;
        }
        if (this.traceOn) {
            logger.info(LocalizedStrings.DEBUG, (Object)(this.toString() + " writeLock for object [" + name + "] with owner=" + owner + ", result was " + responseCode), (Throwable)failureEx);
        }
        if (failureEx != null) {
            throw new InternalGemFireException("unexpected failure in write lock acquisition", (Throwable)failureEx);
        }
        return responseCode.isGrant();
    }

    @Override
    public boolean writeLock(GfxdLockable lockable, Object owner, long waitTimeMillis, long leaseTimeMillis) {
        return this.writeLock(lockable.getName(), owner, waitTimeMillis, leaseTimeMillis);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeUnlock(Object name, Object owner) {
        LogWriterI18n logger = this.getLogWriter();
        if (this.traceOn) {
            if (owner != null && !(owner instanceof GfxdLocalLockService.DistributedLockOwner)) {
                Assert.fail((Object)("unexpected distributed lock owner of class " + owner.getClass().getName() + ": " + owner.toString()));
            }
            logger.info(LocalizedStrings.DEBUG, (Object)(this.toString() + " writeUnlock for object [" + name + "] for owner=" + owner));
        }
        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
        Throwable unlockEx = null;
        try {
            GfxdDRWLockReleaseProcessor.releaseDRWLock(this.getDistributionManager(), this.serviceName, name, owner, logger);
            super.unlock(name);
            if (!this.traceOn) return;
        }
        catch (LockNotHeldException ex) {
            try {
                unlockEx = ex;
                throw ex;
                catch (LeaseExpiredException ex2) {
                    unlockEx = ex2;
                    throw ex2;
                }
                catch (RuntimeException ex3) {
                    unlockEx = ex3;
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                if (!this.traceOn) throw throwable;
                logger.info(LocalizedStrings.DEBUG, (Object)(this.toString() + " writeUnlock for object [" + name + "] for owner=" + owner + (unlockEx != null ? ", threw exception" : ", was successful")), unlockEx);
                throw throwable;
            }
        }
        logger.info(LocalizedStrings.DEBUG, (Object)(this.toString() + " writeUnlock for object [" + name + "] for owner=" + owner + (unlockEx != null ? ", threw exception" : ", was successful")), unlockEx);
    }

    @Override
    public final void writeUnlock(GfxdLockable lockable, Object owner) {
        this.writeUnlock(lockable.getName(), owner);
    }

    @Override
    public final GfxdLocalLockService.DistributedLockOwner newCurrentOwner() {
        return new GfxdLocalLockService.DistributedLockOwner(this.getDistributionManager().getDistributionManagerId());
    }

    @Override
    public final GfxdLocalLockService getLocalLockService() {
        return this.localLockMap;
    }

    @Override
    public boolean hasWriteLock(Object name, Object owner) {
        this.checkDestroyed();
        return this.localLockMap.hasWriteLock(name, owner);
    }

    @Override
    public Object getWriteLockOwner(Object name) {
        this.checkDestroyed();
        return this.localLockMap.getWriteLockOwner(name);
    }

    @Override
    public final TimeoutException getLockTimeoutRuntimeException(Object lockObject, Object owner, boolean dumpAllLocks) {
        if (dumpAllLocks) {
            this.dumpAllRWLocks("LOCK TABLE at the time of failure", true, false, true);
        }
        return this.localLockMap.getLockTimeoutRuntimeException(lockObject, owner, false);
    }

    @Override
    public final StandardException getLockTimeoutException(Object lockObject, Object owner, boolean dumpAllLocks) {
        if (dumpAllLocks) {
            this.dumpAllRWLocks("LOCK TABLE at the time of failure", true, false, true);
        }
        return this.localLockMap.getLockTimeoutException(lockObject, owner, false);
    }

    public void dumpAllRWLocks(String logPrefix, boolean allVMs, boolean stdout, boolean force) {
        this.localLockMap.dumpAllRWLocks(logPrefix, stdout ? new PrintWriter(System.out) : null, force);
        if (allVMs) {
            GfxdDRWLockRequestProcessor.GfxdDRWLockDumpMessage.send(this.ds, this.serviceName, logPrefix, stdout, this.getLogWriter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpAllDLockServices(StringBuilder msg) {
        Map map = services;
        synchronized (map) {
            for (Map.Entry entry : services.entrySet()) {
                msg.append((String)entry.getKey()).append(": ");
                DLockService svc = (DLockService)entry.getValue();
                svc.dumpService(msg, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postDestroyAction() {
        Map map = services;
        synchronized (map) {
            GfxdDRWLockService currentService = rwServices.remove(this.serviceName);
            assert (currentService == this) : "Unexpected service " + currentService + " in GFXD ReadWriteLock services map";
        }
    }

    protected Object removeTokenFromMap(Object name) {
        this.localLockMap.freeResources(name);
        return super.removeTokenFromMap(name);
    }

    public void checkDestroyed() {
        if (this.isDestroyed()) {
            LockServiceDestroyedException ex = this.generateLockServiceDestroyedException(this.generateLockServiceDestroyedMessage());
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ex);
            throw ex;
        }
    }

    public void memberDeparted(InternalDistributedMember member, boolean crashed) {
        if (this.beforeMemberDeparted != null) {
            this.beforeMemberDeparted.memberDeparted(member, crashed);
        }
        LogWriterI18n logger = this.getLogWriter();
        for (Map.Entry entry : this.localLockMap.entrySet()) {
            Object name = entry.getKey();
            Object lockOwner = ((GfxdReadWriteLock)entry.getValue()).getWriteLockOwner();
            if (!(lockOwner instanceof GfxdLocalLockService.DistributedLockOwner) || !member.equals(((GfxdLocalLockService.DistributedLockOwner)lockOwner).getOwnerMember())) continue;
            if (this.traceOn) {
                logger.info(LocalizedStrings.DEBUG, (Object)(this.toString() + " releasing writeLock for object [" + name + "] with owner=" + lockOwner + ", due to memberDeparted for " + member));
            }
            try {
                this.localLockMap.writeUnlock(entry.getKey(), lockOwner);
            }
            catch (LockNotHeldException e) {
                if (!this.traceOn) continue;
                logger.info(LocalizedStrings.DEBUG, (Object)(this.toString() + " ignoring LockNotHeldException for object [" + name + "] lock=" + entry.getValue()));
            }
        }
    }

    public void memberJoined(InternalDistributedMember member) {
        if (this.beforeMemberDeparted != null) {
            this.beforeMemberDeparted.memberJoined(member);
        }
    }

    public void memberSuspect(InternalDistributedMember member, InternalDistributedMember whoSuspected) {
        if (this.beforeMemberDeparted != null) {
            this.beforeMemberDeparted.memberSuspect(member, whoSuspected);
        }
    }

    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        if (this.beforeMemberDeparted != null) {
            this.beforeMemberDeparted.quorumLost(failures, remaining);
        }
    }

    public String toString() {
        return "[GfxdDRWLockService: " + this.serviceName + "]";
    }

    static {
        DependencyMonitorManager.addMonitor((DependencyMonitor)GfxdRWLockDependencyMonitor.INSTANCE);
    }
}

