/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jdbc;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.shared.CommonRunTimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.sql.SQLException;

public final class GemFireXDRuntimeException
extends RuntimeException
implements CommonRunTimeException {
    private static final long serialVersionUID = -4374956473222420893L;
    private DistributedMember origin;

    public GemFireXDRuntimeException() {
    }

    public GemFireXDRuntimeException(String message) {
        super(GemFireXDRuntimeException.appendMyOrigin(message));
    }

    private GemFireXDRuntimeException(String message, Throwable cause) {
        super(GemFireXDRuntimeException.appendMyOrigin(message), cause);
    }

    public GemFireXDRuntimeException(Throwable cause) {
        this(null, cause);
    }

    private static String appendMyOrigin(String message) {
        try {
            InternalDistributedMember myId = StandardException.getMyId();
            return message != null ? message + ", myID: " + myId : "myID: " + myId;
        }
        catch (Exception ex) {
            return message;
        }
    }

    public static RuntimeException newRuntimeException(String message, Throwable t) {
        try {
            return GemFireXDRuntimeException.getOrThrowSQLException(t, false, message);
        }
        catch (StandardException | SQLException exception) {
            throw new GemFireXDRuntimeException(message, t);
        }
    }

    public static void throwSQLOrRuntimeException(String message, Throwable t) throws StandardException, SQLException {
        throw GemFireXDRuntimeException.getOrThrowSQLException(t, true, message);
    }

    private static GemFireXDRuntimeException createRuntimeException(String message, Throwable t) {
        if (message != null) {
            return new GemFireXDRuntimeException(message, t);
        }
        return new GemFireXDRuntimeException(t);
    }

    protected static RuntimeException getOrThrowSQLException(Throwable ex, boolean throwSQLEx, String wrapMsg) throws StandardException, SQLException {
        for (Throwable t = ex; t != null; t = t.getCause()) {
            Exception sqlEx;
            if (t instanceof SQLException) {
                sqlEx = (SQLException)t;
                if ((t = StandardException.getJavaException(sqlEx, ((SQLException)sqlEx).getSQLState())) != null) continue;
                if (throwSQLEx) {
                    throw sqlEx;
                }
                return GemFireXDRuntimeException.createRuntimeException(wrapMsg, sqlEx);
            }
            if (!(t instanceof StandardException) || (t = StandardException.getJavaException(sqlEx = (StandardException)t, ((StandardException)sqlEx).getSQLState())) != null) continue;
            if (throwSQLEx) {
                throw sqlEx;
            }
            return GemFireXDRuntimeException.createRuntimeException(wrapMsg, sqlEx);
        }
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        return GemFireXDRuntimeException.createRuntimeException(wrapMsg, ex);
    }

    public final void setOrigin(DistributedMember member) {
        this.origin = member;
    }

    public final DistributedMember getOrigin() {
        return this.origin;
    }

    public Throwable getRootCause() {
        if (this.getCause() == null) {
            return null;
        }
        Throwable root = this.getCause();
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    @Override
    public String toString() {
        String result = super.toString();
        Throwable cause = this.getCause();
        String originStr = "";
        if (this.origin != null) {
            originStr = ", on member " + this.origin.toString();
        }
        if (cause != null) {
            String causeStr = cause.toString();
            String glue = ", caused by ";
            StringBuilder sb = new StringBuilder(result.length() + originStr.length() + causeStr.length() + ", caused by ".length());
            sb.append(result).append(originStr).append(", caused by ").append(causeStr);
            result = sb.toString();
        }
        return result;
    }

    public RuntimeException newRunTimeException(String msg, Throwable cause) {
        return GemFireXDRuntimeException.newRuntimeException(msg, cause);
    }
}

