/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.fabricservice;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.jmx.Agent;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.pivotal.gemfirexd.FabricAgent;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceImpl;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class FabricAgentImpl
extends FabricServiceImpl
implements FabricAgent {
    private Agent _impl;

    @Override
    public void start(Properties bootProperties) throws SQLException {
        this.start(bootProperties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start(Properties bootProperties, boolean ignoreIfStarted) throws SQLException {
        if (bootProperties == null) {
            bootProperties = new Properties();
        }
        bootProperties.setProperty("host-data", "false");
        try {
            bootProperties.setProperty("gemfirexd.__rt.fabricapi", GfxdConstants.BT_INDIC.FABRICAGENT.toString());
            this.startImpl(bootProperties, ignoreIfStarted, true);
            this._impl = Misc.getMemStore().getGemFireAgent();
        }
        catch (Throwable t) {
            Error err;
            if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                FabricServiceUtils.clearSystemProperties(this.monitorlite, this.sysProps);
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            SystemFailure.checkFailure();
            this.handleThrowable(t);
        }
        finally {
            bootProperties.remove("gemfirexd.__rt.fabricapi");
        }
    }

    public ObjectName connectToSystem() throws AdminException, MalformedObjectNameException {
        this.checkNull(this._impl);
        assert (this._impl.isConnected());
        return this._impl.getObjectName();
    }

    public void disconnectFromSystem() {
        try {
            this.checkNull(this._impl);
            this.stop(null);
        }
        catch (SQLException sqle) {
            SanityManager.DEBUG_PRINT((String)"error:FabricServiceAPI", (String)(sqle.getSQLState() + " error occurred while starting server : " + sqle));
            throw GemFireXDRuntimeException.newRuntimeException("GemFireXD:FabricAgent#disconnectToSystem exception occurred ", sqle);
        }
    }

    public AgentConfig getConfig() {
        this.checkNull(this._impl);
        return this._impl.getConfig();
    }

    public AdminDistributedSystem getDistributedSystem() {
        this.checkNull(this._impl);
        return this._impl.getDistributedSystem();
    }

    public LogWriter getLogWriter() {
        this.checkNull(this._impl);
        return this._impl.getLogWriter();
    }

    public MBeanServer getMBeanServer() {
        this.checkNull(this._impl);
        return this._impl.getMBeanServer();
    }

    public ObjectName getObjectName() {
        this.checkNull(this._impl);
        return this._impl.getObjectName();
    }

    public boolean isConnected() {
        this.checkNull(this._impl);
        return this._impl.isConnected();
    }

    public ObjectName manageDistributedSystem() throws MalformedObjectNameException {
        this.checkNull(this._impl);
        return this._impl.manageDistributedSystem();
    }

    public void saveProperties() {
        this.checkNull(this._impl);
        this._impl.saveProperties();
    }

    public void start() {
        throw new GemFireXDRuntimeException("Operation UnSupported. Use FabricAgent#start(bootProperties) variants");
    }

    public void stop() {
        throw new GemFireXDRuntimeException("Operation UnSupported. Use FabricAgent#stop(shutdownCredentials) variant");
    }

    private void checkNull(Agent impl) {
        if (impl == null) {
            throw new GemFireXDRuntimeException("Agent Not Connected");
        }
    }
}

