/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.expression;

import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;

class AlignToResultSetVisitor
extends VisitorAdaptor {
    private final int resultSetNumber;

    public AlignToResultSetVisitor(int resultsetnumber) {
        this.resultSetNumber = resultsetnumber;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ResultColumn) {
            ((ResultColumn)node).setResultSetNumber(this.resultSetNumber);
        } else if (node instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)node;
            ResultColumn rc = cr.getSource();
            DataTypeDescriptor rctype = rc.getType();
            if (rctype.getTypeId().getCorrespondingJavaTypeName().equals(DVDSet.class.getName())) {
                cr.setSource(null);
                rc.setType(cr.getTypeServices());
                cr.setSource(rc);
            }
            rc.accept(this);
        } else if (node instanceof VirtualColumnNode) {
            ((VirtualColumnNode)node).getSourceColumn().accept(this);
        }
        return node;
    }
}

