/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.LogWriter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterizedConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueListQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.ListRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class InQueryInfo
extends ComparisonQueryInfo {
    private QueryInfo runTimePruner = null;
    private boolean rightOperandIsArray;

    public InQueryInfo(QueryInfo leftOp, boolean isListDynamic, ValueQueryInfo[] rhsOps) throws StandardException {
        super(leftOp, new ValueListQueryInfo(rhsOps, isListDynamic), 1);
        if (leftOp instanceof ColumnQueryInfo) {
            ColumnQueryInfo left = (ColumnQueryInfo)leftOp;
            for (ValueQueryInfo right : rhsOps) {
                this.adjustConstantType(left, right);
            }
        }
    }

    Object[] isConvertibleToGet(int pkColumn, TableQueryInfo tqi) throws StandardException {
        ColumnQueryInfo cqi;
        Object[] pks = null;
        assert (this.opType == 1);
        if (this.leftOperand instanceof ColumnQueryInfo && this.rightOperand instanceof ValueQueryInfo && (cqi = (ColumnQueryInfo)this.leftOperand).getActualColumnPosition() == pkColumn && cqi.getTableNumber() == tqi.getTableNumber() && (pks = (Object[])this.rightOperand.getPrimaryKey()).length > 1 && tqi.getRegion().getPartitionAttributes() == null) {
            return null;
        }
        return pks;
    }

    Object[] isConvertibleToGet(int[][] pkColumns, TableQueryInfo tqi) throws StandardException {
        if (pkColumns.length == 1) {
            Object[] pks = this.isConvertibleToGet(pkColumns[0][0], tqi);
            if (pks != null) {
                GemFireContainer container = (GemFireContainer)tqi.getRegion().getUserAttribute();
                int len = pks.length;
                for (int i = 0; i < len; ++i) {
                    Object pk = pks[i];
                    if (!(pk instanceof DataValueDescriptor)) continue;
                    pks[i] = GemFireXDUtils.convertIntoGemfireRegionKey((DataValueDescriptor)pk, container, false);
                }
            }
            return pks;
        }
        return null;
    }

    Object[] isConvertibleToGetOnLocalIndex(int ikColumn, TableQueryInfo tqi) throws StandardException {
        ColumnQueryInfo cqi;
        Object[] fks = null;
        assert (this.opType == 1);
        if (this.leftOperand instanceof ColumnQueryInfo && this.rightOperand instanceof ValueQueryInfo && (cqi = (ColumnQueryInfo)this.leftOperand).getActualColumnPosition() == ikColumn && cqi.getTableNumber() == tqi.getTableNumber() && (fks = (Object[])this.rightOperand.getIndexKey()).length > 1 && tqi.getRegion().getPartitionAttributes() == null) {
            return null;
        }
        return fks;
    }

    Object[] isConvertibleToGetOnLocalIndex(int[][] ikColumns, TableQueryInfo tqi) throws StandardException {
        if (ikColumns.length == 1) {
            Object[] fks = this.isConvertibleToGetOnLocalIndex(ikColumns[0][0], tqi);
            return fks;
        }
        return null;
    }

    @Override
    QueryInfo[] getOperands() {
        QueryInfo[] temp = new QueryInfo[1 + ((ValueListQueryInfo)this.rightOperand).getSize()];
        temp[0] = this.leftOperand;
        ValueQueryInfo[] vqiArr = ((ValueListQueryInfo)this.rightOperand).getOperands();
        for (int i = 1; i < temp.length; ++i) {
            temp[i] = vqiArr[i - 1];
        }
        return temp;
    }

    @Override
    public boolean isWhereClauseDynamic() {
        return this.rightOperand.isDynamic() || this.leftOperand.isDynamic();
    }

    @Override
    public boolean isEquiJoinCondition() {
        return true;
    }

    @Override
    public String isEquiJoinColocationCriteriaFullfilled(TableQueryInfo ncjTqi) {
        return this.colocationMatrixPRTableCount <= 1 ? null : "more than one partitioned tables with an IN clause";
    }

    @Override
    AbstractConditionQueryInfo createOrAddToGroup(AbstractConditionQueryInfo operand, boolean createConstantConditionsWrapper, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        AbstractConditionQueryInfo retVal = null;
        if (activation == null && (this.isWhereClauseDynamic() || operand.isWhereClauseDynamic())) {
            retVal = new ParameterizedConditionsWrapperQueryInfo(this, operand);
        } else if (createConstantConditionsWrapper) {
            retVal = new ConstantConditionsWrapperQueryInfo(this, operand);
        }
        return retVal;
    }

    @Override
    QueryInfo getRuntimeNodesPruner(boolean forSingleHopPreparePhase) {
        if (this.runTimePruner == null) {
            this.runTimePruner = this.createRuntimeNodesPruner(forSingleHopPreparePhase);
        }
        return this.runTimePruner;
    }

    private QueryInfo createRuntimeNodesPruner(boolean forSingleHopPreparePhase) {
        ColumnQueryInfo cqi;
        GfxdPartitionResolver rslvr;
        QueryInfo pruner = null;
        pruner = this.leftOperand instanceof ColumnQueryInfo ? ((rslvr = (cqi = (ColumnQueryInfo)this.leftOperand).getResolverIfSingleColumnPartition()) != null ? InQueryInfo.getResolverBasedPruner(rslvr, (ValueListQueryInfo)this.rightOperand, forSingleHopPreparePhase, this.rightOperandIsArray) : (!forSingleHopPreparePhase ? InQueryInfo.attemptToGetGlobalIndexBasedPruner((ValueListQueryInfo)this.rightOperand, cqi, this.rightOperandIsArray) : QueryInfoConstants.NON_PRUNABLE)) : QueryInfoConstants.NON_PRUNABLE;
        return pruner;
    }

    private static QueryInfo getResolverBasedPruner(final GfxdPartitionResolver rslvr, final ValueListQueryInfo vlqi, boolean forSingleHopPreparePhase, final boolean rightOperandIsArray) {
        final LogWriter logger = Misc.getCacheLogWriter();
        AbstractQueryInfo pruner = new AbstractQueryInfo(){

            @Override
            public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                assert (routingKeysToExecute.size() == 1);
                assert (routingKeysToExecute.contains(ResolverUtils.TOK_ALL_NODES));
                if (logger.fineEnabled()) {
                    logger.fine("InQueryInfo::computeNodes: Resolver being used = " + rslvr);
                }
                if (!forSingleHopPreparePhase) {
                    DataValueDescriptor[] keys = vlqi.evaluateToGetDataValueDescriptorArray(activation);
                    if (logger.fineEnabled()) {
                        for (DataValueDescriptor key : keys) {
                            logger.fine("InQueryInfo::computeNodes: Key of In predicate  = " + key);
                        }
                    }
                    if (rightOperandIsArray) {
                        SanityManager.ASSERT((keys.length == 1 ? 1 : 0) != 0);
                        SanityManager.ASSERT((boolean)(keys[0] instanceof DVDSet));
                        keys = ((DVDSet)keys[0]).getValues();
                    }
                    Object[] routingObjects = rslvr.getRoutingObjectsForList(keys);
                    assert (routingObjects != null);
                    routingKeysToExecute.remove(ResolverUtils.TOK_ALL_NODES);
                    for (Object key : routingObjects) {
                        if (logger.fineEnabled()) {
                            logger.fine("InQueryInfo::computeNodes: Routing Key for In predicate  = " + key);
                        }
                        routingKeysToExecute.add(key);
                    }
                } else {
                    int size = vlqi.getSize();
                    ValueQueryInfo[] operands = vlqi.getOperands();
                    ColumnRoutingObjectInfo[] colRobjInfo = new ColumnRoutingObjectInfo[size];
                    block6: for (int i = 0; i < size; ++i) {
                        ValueQueryInfo vqi = operands[i];
                        int type = vqi.typeOfValue();
                        switch (type) {
                            case 1: 
                            case 2: {
                                colRobjInfo[i] = ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, rslvr);
                                continue block6;
                            }
                            case 0: {
                                colRobjInfo[i] = ComparisonQueryInfo.getAppropriateRoutingObjectInfo(activation, vqi, rslvr);
                                continue block6;
                            }
                            default: {
                                throw new GemFireXDRuntimeException("unexpected type: " + type + " encountered");
                            }
                        }
                    }
                    ListRoutingObjectInfo lrobjInfo = new ListRoutingObjectInfo(colRobjInfo, (Object)rslvr);
                    routingKeysToExecute.remove(ResolverUtils.TOK_ALL_NODES);
                    routingKeysToExecute.add(lrobjInfo);
                }
            }
        };
        return pruner;
    }

    private static QueryInfo attemptToGetGlobalIndexBasedPruner(final ValueListQueryInfo vlqi, ColumnQueryInfo cqi, final boolean rightOperandIsArray) {
        final LogWriter logger = Misc.getCacheLogWriter();
        List<ConglomerateDescriptor> globalIndexes = cqi.getAvailableGlobalHashIndexForColumn();
        ConglomerateDescriptor cd = null;
        Iterator<ConglomerateDescriptor> itr = globalIndexes.iterator();
        QueryInfo pruner = null;
        while (itr.hasNext()) {
            ConglomerateDescriptor temp = itr.next();
            if (temp.getIndexDescriptor().baseColumnPositions().length != 1) continue;
            cd = temp;
            break;
        }
        if (cd != null) {
            final long conglomID = cd.getConglomerateNumber();
            pruner = new AbstractQueryInfo(){

                @Override
                public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                    assert (routingKeysToExecute.size() == 1);
                    assert (routingKeysToExecute.contains(ResolverUtils.TOK_ALL_NODES));
                    if (logger.fineEnabled()) {
                        logger.fine("InQueryInfo::computeNodes: Conglom ID of the Global Index  being used = " + conglomID);
                    }
                    TransactionController tc = activation.getTransactionController();
                    DataValueDescriptor[] keys = vlqi.evaluateToGetDataValueDescriptorArray(activation);
                    if (logger.fineEnabled()) {
                        for (DataValueDescriptor key : keys) {
                            logger.fine("InQueryInfo::computeNodes: Key of In predicate  = " + key);
                        }
                    }
                    if (rightOperandIsArray) {
                        SanityManager.ASSERT((keys.length == 1 ? 1 : 0) != 0);
                        SanityManager.ASSERT((boolean)(keys[0] instanceof DVDSet));
                        keys = ((DVDSet)keys[0]).getValues();
                    }
                    routingKeysToExecute.clear();
                    for (DataValueDescriptor keyDVD : keys) {
                        DataValueDescriptor[] dvdKeyArr = new DataValueDescriptor[]{keyDVD};
                        ScanController scan = tc.openScan(conglomID, false, 0, 7, 5, null, dvdKeyArr, 1, null, dvdKeyArr, 1, null);
                        if (scan.next()) {
                            DataValueDescriptor[] fetchKey = new DataValueDescriptor[2];
                            fetchKey[0] = keyDVD;
                            while (scan.next()) {
                                GlobalRowLocation grl = new GlobalRowLocation();
                                fetchKey[1] = grl;
                                scan.fetch(new DataValueDescriptor[]{keyDVD, grl});
                                Serializable routingObject = grl.getRoutingObject();
                                if (logger.fineEnabled()) {
                                    logger.fine("ComparisonQueryInfo::pruneUsingGlobalIndex: Scan of Global index found a row = " + grl);
                                    logger.fine("ComparisonQueryInfo::pruneUsingGlobalIndex: Scan of Global index found routing object = " + routingObject);
                                }
                                assert (routingObject != null);
                                routingKeysToExecute.add(routingObject);
                            }
                        } else if (logger.fineEnabled()) {
                            logger.fine("ComparisonQueryInfo::pruneUsingGlobalIndex: Scan of Global index found NO row");
                        }
                        scan.close();
                    }
                }
            };
        } else {
            pruner = QueryInfoConstants.NON_PRUNABLE;
        }
        return pruner;
    }

    public void setRightOperandArray() {
        this.rightOperandIsArray = true;
    }
}

