/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdSerializable;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public final class ProjectionRow
extends BucketRegion.RawValue
implements GfxdSerializable {
    private transient RowFormatter formatter;
    private transient int[] fixedColumns;
    private transient int[] varColumns;
    private transient int[] lobColumns;
    private transient int targetFormatOffsetBytes;
    private transient boolean hasProjection;

    public ProjectionRow() {
        super(null);
    }

    ProjectionRow(Object value) {
        super(value);
    }

    final void setProjectionInfo(RowFormatter rf, int[] fixedColumns, int[] varColumns, int[] lobColumns, int offsetBytes) {
        this.formatter = rf;
        this.fixedColumns = fixedColumns;
        this.varColumns = varColumns;
        this.lobColumns = lobColumns;
        this.targetFormatOffsetBytes = offsetBytes;
        this.hasProjection = true;
    }

    public static final AbstractCompactExecRow getCompactExecRow(Object rawValue, GemFireContainer container, RowFormatter targetFormat, int[] allColumns, int[] lobColumns) {
        RowFormatter formatter;
        Class<?> rawValueClass = rawValue.getClass();
        if (lobColumns == null) {
            byte[] bytes;
            if (rawValueClass == byte[].class) {
                bytes = (byte[])rawValue;
            } else if (rawValueClass == byte[][].class) {
                bytes = ((byte[][])rawValue)[0];
            } else {
                OffHeapByteSource bs = (OffHeapByteSource)((Object)rawValue);
                RowFormatter formatter2 = container.getRowFormatter(bs);
                return container.newExecRowFromBytes(formatter2.generateColumns(bs, allColumns, targetFormat), targetFormat);
            }
            RowFormatter formatter3 = container.getRowFormatter(bytes);
            return container.newExecRowFromBytes(formatter3.generateColumns(bytes, allColumns, targetFormat), targetFormat);
        }
        byte[][] heapByteArrays = null;
        byte[] heapBytes = null;
        OffHeapByteSource ohBytes = null;
        OffHeapRowWithLobs ohByteArrays = null;
        if (rawValueClass == byte[][].class) {
            heapByteArrays = (byte[][])rawValue;
            heapBytes = heapByteArrays[0];
            formatter = container.getRowFormatter(heapBytes);
        } else if (rawValueClass == byte[].class) {
            heapBytes = (byte[])rawValue;
            formatter = container.getRowFormatter(heapBytes);
        } else if (rawValueClass == OffHeapRowWithLobs.class) {
            ohByteArrays = (OffHeapRowWithLobs)((Object)rawValue);
            ohBytes = ohByteArrays;
            formatter = container.getRowFormatter(ohByteArrays);
        } else if (rawValueClass == OffHeapRow.class) {
            OffHeapRow ohRow = (OffHeapRow)((Object)rawValue);
            ohBytes = ohRow;
            formatter = container.getRowFormatter(ohRow);
        } else {
            formatter = container.getCurrentRowFormatter();
        }
        byte[][] result = new byte[lobColumns.length + 1][];
        if (allColumns != null) {
            result[0] = allColumns.length - lobColumns.length != formatter.getNumColumns() - formatter.numLobs() || targetFormat.schemaVersion != formatter.schemaVersion ? (ohBytes != null ? formatter.generateColumns(ohBytes, allColumns, targetFormat) : formatter.generateColumns(heapBytes, allColumns, targetFormat)) : (ohBytes != null ? ohBytes.getRowBytes() : heapBytes);
        }
        for (int index = 0; index < lobColumns.length; ++index) {
            result[index + 1] = ohByteArrays != null ? formatter.getLob(ohByteArrays, lobColumns[index]) : formatter.getLob(heapByteArrays, lobColumns[index]);
        }
        return container.newExecRowFromByteArrays(result, targetFormat);
    }

    public final int getDSFID() {
        return -20;
    }

    public final void toData(DataOutput out) throws IOException {
        if (this.hasProjection) {
            if (this.lobColumns == null) {
                this.serializeColumns(out);
            } else {
                assert (this.formatter.hasLobs()) : "unexpected LOB columns " + Arrays.toString(this.lobColumns) + " for " + this.formatter;
                byte[][] byteArrays = null;
                OffHeapRowWithLobs byteSource = null;
                InternalDataSerializer.writeArrayLength((int)(this.lobColumns.length + 1), (DataOutput)out);
                this.serializeColumns(out);
                Class<?> rawValueClass = this.rawValue.getClass();
                if (rawValueClass == byte[][].class) {
                    byteArrays = (byte[][])this.rawValue;
                } else if (rawValueClass == OffHeapRowWithLobs.class) {
                    byteSource = (OffHeapRowWithLobs)((Object)this.rawValue);
                }
                for (int index = 0; index < this.lobColumns.length; ++index) {
                    if (byteSource != null) {
                        this.formatter.serializeLob(byteSource, this.lobColumns[index], out);
                        continue;
                    }
                    DataSerializer.writeByteArray((byte[])this.formatter.getLob(byteArrays, this.lobColumns[index]), (DataOutput)out);
                }
            }
        } else {
            Object v = this.rawValue;
            if (v != null) {
                Class<?> vclass = v.getClass();
                if (vclass == byte[].class) {
                    out.writeByte(46);
                    DataSerializer.writeByteArray((byte[])((byte[])v), (DataOutput)out);
                } else if (vclass == byte[][].class) {
                    out.writeByte(91);
                    DataSerializer.writeArrayOfByteArrays((byte[][])((byte[][])v), (DataOutput)out);
                } else {
                    ((OffHeapByteSource)((Object)v)).sendTo(out);
                }
            } else {
                out.writeByte(46);
                DataSerializer.writeByteArray(null, (DataOutput)out);
            }
        }
    }

    private void serializeColumns(DataOutput out) throws IOException {
        RowFormatter targetFormatter = this.formatter.container.getCurrentRowFormatter();
        int targetFormatOffsetIsDefault = RowFormatter.getOffsetValueForDefault(this.targetFormatOffsetBytes);
        Class<?> rawValueClass = this.rawValue.getClass();
        if (rawValueClass == byte[][].class) {
            this.formatter.serializeColumns(((byte[][])this.rawValue)[0], out, this.fixedColumns, this.varColumns, this.targetFormatOffsetBytes, targetFormatOffsetIsDefault, targetFormatter);
        } else if (rawValueClass == byte[].class) {
            this.formatter.serializeColumns((byte[])this.rawValue, out, this.fixedColumns, this.varColumns, this.targetFormatOffsetBytes, targetFormatOffsetIsDefault, targetFormatter);
        } else if (rawValueClass == OffHeapRowWithLobs.class) {
            this.formatter.serializeColumns((OffHeapRowWithLobs)((Object)this.rawValue), out, this.fixedColumns, this.varColumns, this.targetFormatOffsetBytes, targetFormatOffsetIsDefault, targetFormatter);
        } else {
            this.formatter.serializeColumns((OffHeapRow)((Object)this.rawValue), out, this.fixedColumns, this.varColumns, this.targetFormatOffsetBytes, targetFormatOffsetIsDefault, targetFormatter);
        }
    }

    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.rawValue = DataSerializer.readObject((DataInput)in);
    }

    public byte getGfxdID() {
        if (this.hasProjection) {
            if (this.lobColumns == null) {
                return 86;
            }
            return 87;
        }
        return 83;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProjectionRow(value=").append(this.rawValue);
        sb.append(",isByteArray=").append(this.isValueByteArray());
        if (this.fromCacheLoader) {
            sb.append(",fromCacheLoader=").append(this.fromCacheLoader);
        }
        if (this.hasProjection) {
            if (this.fixedColumns != null) {
                sb.append(",fixedColumns=").append(Arrays.toString(this.fixedColumns));
            }
            if (this.varColumns != null) {
                sb.append(",varColumns=").append(Arrays.toString(this.varColumns));
            }
            if (this.lobColumns != null) {
                sb.append(",lobColumns=").append(Arrays.toString(this.lobColumns));
            }
            if (this.targetFormatOffsetBytes != 0) {
                sb.append(",targetFormatOffsetBytes=").append(this.targetFormatOffsetBytes);
            }
        } else {
            sb.append(",sendFullRow=true");
        }
        return sb.append(')').toString();
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public static final class ProjectionRowFactory
    extends BucketRegion.RawValueFactory {
        private static final ProjectionRowFactory _instance = new ProjectionRowFactory();

        protected ProjectionRow newInstance(Object rawVal) {
            return new ProjectionRow(rawVal);
        }

        public static ProjectionRowFactory getFactory() {
            return _instance;
        }
    }
}

