/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.TXChanges;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.DVDIOUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdHeapDataOutputStream;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollectorHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactExecRowWithLobs;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.OffHeapCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.OffHeapCompactExecRowWithLobs;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public final class ResultHolder
extends GfxdDataSerializable {
    private static final byte HAS_EXCEPTION = 1;
    private static final byte DO_PROJECTION = 2;
    private static final byte HAS_OUTER_JOIN_KEYINFO = 4;
    private static final byte HAS_ARRAY_OF_BYTES = 8;
    private static final short STATS_ENABLED = 16;
    private static final byte HAS_TX_CHANGES = 32;
    private static final byte HAS_STREAMING = 64;
    private final EmbedResultSet ers;
    private final transient EmbedStatement es;
    private final transient int origLCCFlags;
    private GfxdResultCollector<?> streamingCollector;
    private GfxdResultCollectorHelper streamingHelper;
    private PreparedStatement gps;
    private byte state = 0;
    private transient boolean firstCall = true;
    private ByteArrayDataInput dis;
    private int numEightColGrps = -1;
    private int numPartialCols = -1;
    private volatile Throwable exception = null;
    private volatile DistributedMember exceptionMember = null;
    private RowFormatter rowFormatter;
    public int stream_size;
    private DataTypeDescriptor distinctAggUnderlyingType = null;
    private final transient StatementStats stats;
    private final GfxdConnectionWrapper wrapper;
    private final StatementExecutorMessage<?> sourceMessage;
    private final transient GfxdHeapThresholdListener thresholdListener;
    private final GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
    private boolean recordStats;
    public transient int rows_returned;
    public transient Timestamp construct_time = null;
    public transient long ser_deser_time;
    public transient long throttle_time;
    public transient long process_time;
    private transient int numEightColGroups;
    private transient int numPartCols;
    private transient int numRows;
    private transient GfxdHeapDataOutputStream hdos;
    private transient long begin = -1L;
    private transient boolean hasRows;
    private transient boolean doProjection;
    private transient boolean hasLobs;
    private transient boolean isOffHeap;
    private transient RowFormatter rf;
    private transient TXChanges txChanges;
    private transient ExecRow[] candidateRowArray;
    private final transient int batchSize = GemFireXDUtils.DML_BULK_FETCH_SIZE;
    private transient int nextRowIndex;
    private transient int candidateRowArraySize;
    private transient boolean hasMoreRows;

    public ResultHolder() {
        if (this.recordStats) {
            this.construct_time = XPLAINUtil.currentTimeStamp();
        }
        this.ers = null;
        this.es = null;
        this.origLCCFlags = 0;
        this.wrapper = null;
        this.sourceMessage = null;
        this.stats = null;
        GemFireStore store = GemFireStore.getBootingInstance();
        this.thresholdListener = store != null ? store.thresholdListener() : null;
    }

    public ResultHolder(EmbedResultSet rs, EmbedStatement es, GfxdConnectionWrapper wrapper, int origLCCFlags, StatementExecutorMessage<?> sourceMessage, boolean sendRgnAndKeyInfo) {
        if (rs == null) {
            throw new IllegalArgumentException("result set must not be null");
        }
        if (sourceMessage != null) {
            boolean bl = this.recordStats = sourceMessage.statsEnabled() || sourceMessage.timeStatsEnabled() || sourceMessage.explainConnectionEnabled();
        }
        if (this.recordStats) {
            this.construct_time = XPLAINUtil.currentTimeStamp();
        }
        this.ers = rs;
        this.es = es;
        this.origLCCFlags = origLCCFlags;
        this.wrapper = wrapper;
        this.sourceMessage = sourceMessage;
        this.stats = es.getStatementStats();
        if (this.recordStats) {
            this.state = (byte)(this.state | 0x10);
        }
        if (sendRgnAndKeyInfo) {
            this.state = (byte)(this.state | 4);
        }
        this.thresholdListener = Misc.getMemStoreBooting().thresholdListener();
    }

    public final void setRowFormatter(RowFormatter rf, boolean allownull) {
        assert (rf != null || allownull);
        this.rowFormatter = rf;
    }

    private boolean hasOuterJoinKeyInfo() {
        return GemFireXDUtils.isSet(this.state, (byte)4);
    }

    public final void setDistinctAggUnderlyingType(DataTypeDescriptor distinctUnderlyingType) {
        this.distinctAggUnderlyingType = distinctUnderlyingType;
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("setting input type in RH as " + this.distinctAggUnderlyingType));
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        byte status;
        super.fromData(in);
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"ResultHolder::fromData: about to read row bytes");
        }
        if (GemFireXDUtils.isSet((short)(status = in.readByte()), (short)16)) {
            this.recordStats = true;
            this.construct_time = XPLAINUtil.currentTimeStamp();
        }
        if (GemFireXDUtils.isSet(status, (byte)32)) {
            this.txChanges = TXChanges.fromData((DataInput)in);
        }
        if (GemFireXDUtils.isSet(status, (byte)1)) {
            Throwable t = (Throwable)DataSerializer.readObject((DataInput)in);
            DistributedMember m = (DistributedMember)DataSerializer.readObject((DataInput)in);
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::fromData: From member [" + m + "] received exception: " + t));
            }
            this.exception = t;
            this.exceptionMember = m;
            this.dis = null;
            return;
        }
        this.state = (byte)(this.state | status);
        int numBytes = InternalDataSerializer.readArrayLength((DataInput)in);
        Misc.checkMemoryRuntime(this.thresholdListener, "ResultHolder:fromData", numBytes);
        byte[] rawData = DataSerializer.readByteArray((DataInput)in, (int)numBytes);
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::fromData: Status=0x" + Integer.toHexString(this.state) + " Number of bytes read=" + rawData.length));
        }
        Version v = InternalDataSerializer.getVersionForDataStreamOrNull((DataInput)in);
        this.dis = new ByteArrayDataInput();
        this.dis.initialize(rawData, v);
        this.stream_size = this.dis.available();
    }

    public boolean prepareSend(Version v) throws IOException, SQLException {
        try {
            Object tx;
            long beginRemainingProcessTime;
            GemFireXDQueryObserver observer = this.observer;
            boolean hasOuterJoinKeyInfo = this.hasOuterJoinKeyInfo();
            this.exception = null;
            if (this.hdos == null) {
                long beginitertime;
                boolean collectStats;
                if (observer != null) {
                    observer.beforeResultHolderExecution(this.wrapper, this.es);
                }
                ResultSetMetaData rsmd = this.ers.getMetaData();
                int numCols = rsmd.getColumnCount();
                this.numEightColGroups = numCols / 8 + (numCols % 8 == 0 ? 0 : 1);
                this.numPartCols = numCols % 8;
                if (this.numPartCols == 0) {
                    this.numPartCols = 8;
                }
                this.doProjection = true;
                this.hasLobs = false;
                this.isOffHeap = false;
                boolean bl = collectStats = this.stats != null;
                if (collectStats) {
                    this.begin = this.stats.getStatTime();
                }
                if (observer != null) {
                    observer.beforeResultHolderIteration(this.wrapper, this.es);
                }
                long l = beginitertime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
                if (this.ers.lightWeightNext()) {
                    long beginsertime;
                    ExecRow row = this.ers.getCurrentRow();
                    if (beginitertime != 0L) {
                        beginsertime = XPLAINUtil.recordTiming(-1L);
                        this.process_time += beginsertime - beginitertime;
                    } else {
                        beginsertime = 0L;
                    }
                    if (observer != null) {
                        observer.afterResultHolderIteration(this.wrapper, this.es);
                        observer.beforeResultHolderSerialization(this.wrapper, this.es);
                    }
                    this.hasRows = true;
                    Class<?> rowClass = row.getClass();
                    if (rowClass == CompactExecRow.class) {
                        this.doProjection = false;
                        this.hdos = new GfxdHeapDataOutputStream(this.thresholdListener, this.es.getSQLText(), true, v);
                        CompactExecRow crow = (CompactExecRow)row;
                        this.rf = crow.getRowFormatter();
                        this.isOffHeap = this.rf.container != null && this.rf.container.isOffHeap();
                        byte[] brow = crow.getRowBytes();
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::prepareSend: CompactExecRow bytes: " + Arrays.toString(brow)));
                        }
                        DataSerializer.writeByteArray((byte[])brow, (DataOutput)((Object)this.hdos));
                    } else if (rowClass == CompactExecRowWithLobs.class) {
                        this.doProjection = false;
                        this.hasLobs = true;
                        this.hdos = new GfxdHeapDataOutputStream(this.thresholdListener, this.es.getSQLText(), true, v);
                        CompactExecRowWithLobs crow = (CompactExecRowWithLobs)row;
                        this.rf = crow.getRowFormatter();
                        this.isOffHeap = this.rf.container != null && this.rf.container.isOffHeap();
                        byte[][] brow = crow.getRowByteArrays();
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::prepareSend: CompactExecRowWithLobs bytes: " + ArrayUtils.objectStringNonRecursive((Object)brow)));
                        }
                        this.state = (byte)(this.state | 8);
                        DataSerializer.writeArrayOfByteArrays((byte[][])brow, (DataOutput)((Object)this.hdos));
                    } else if (rowClass == OffHeapCompactExecRow.class) {
                        this.doProjection = false;
                        this.isOffHeap = true;
                        this.hdos = new GfxdHeapDataOutputStream(this.thresholdListener, this.es.getSQLText(), true, v);
                        OffHeapCompactExecRow crow = (OffHeapCompactExecRow)row;
                        this.rf = crow.getRowFormatter();
                        Object brow = crow.getBaseByteSource();
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::prepareSend: OffHeapCompactExecRow bytes: " + Arrays.toString(crow.getRowBytes())));
                        }
                        if (brow != null) {
                            Class<?> rclass = brow.getClass();
                            if (rclass == OffHeapRow.class) {
                                ((OffHeapRow)((Object)brow)).toData((DataOutput)((Object)this.hdos));
                            } else if (rclass == byte[].class) {
                                DataSerializer.writeByteArray((byte[])((byte[])brow), (DataOutput)((Object)this.hdos));
                            } else {
                                ((OffHeapRowWithLobs)((Object)brow)).serializeGfxdBytesWithStats(0, (DataOutput)((Object)this.hdos));
                            }
                        } else {
                            DataSerializer.writeByteArray(null, (DataOutput)((Object)this.hdos));
                        }
                    } else if (rowClass == OffHeapCompactExecRowWithLobs.class) {
                        this.doProjection = false;
                        this.hasLobs = true;
                        this.isOffHeap = true;
                        this.hdos = new GfxdHeapDataOutputStream(this.thresholdListener, this.es.getSQLText(), true, v);
                        OffHeapCompactExecRowWithLobs crow = (OffHeapCompactExecRowWithLobs)row;
                        this.rf = crow.getRowFormatter();
                        Object brow = crow.getBaseByteSource();
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::prepareSend: OffHeapCompactExecRowWithLobs bytes: " + ArrayUtils.objectStringNonRecursive((Object)crow.getRowByteArrays())));
                        }
                        this.state = (byte)(this.state | 8);
                        if (brow != null) {
                            Class<?> bclass = brow.getClass();
                            if (bclass == OffHeapRowWithLobs.class) {
                                ((OffHeapRowWithLobs)((Object)brow)).toData((DataOutput)((Object)this.hdos));
                            } else if (bclass == byte[][].class) {
                                DataSerializer.writeArrayOfByteArrays((byte[][])((byte[][])brow), (DataOutput)((Object)this.hdos));
                            } else {
                                int numLobs = this.rf.numLobs();
                                InternalDataSerializer.writeArrayLength((int)(numLobs + 1), (DataOutput)((Object)this.hdos));
                                ((OffHeapRow)((Object)brow)).toData((DataOutput)((Object)this.hdos));
                                for (int i = 1; i <= numLobs; ++i) {
                                    DataSerializer.writeByteArray(null, (DataOutput)((Object)this.hdos));
                                }
                            }
                        } else {
                            DataSerializer.writeArrayOfByteArrays((byte[][])null, (DataOutput)((Object)this.hdos));
                        }
                    } else {
                        DataValueDescriptor[] dvdArr = row.getRowArray();
                        boolean hasUserType = false;
                        for (DataValueDescriptor dvd : dvdArr) {
                            if (dvd.getTypeFormatId() != 266) continue;
                            hasUserType = true;
                            break;
                        }
                        this.hdos = new GfxdHeapDataOutputStream(this.numEightColGroups > 4 ? this.numEightColGroups * 8 : GfxdHeapDataOutputStream.MIN_SIZE, this.thresholdListener, this.es.getSQLText(), !hasUserType, v);
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::prepareSend: ExecRow: " + row));
                        }
                        this.state = (byte)(this.state | 2);
                        DVDIOUtil.writeDVDArray(dvdArr, this.numEightColGroups, this.numPartCols, (DataOutput)((Object)this.hdos));
                    }
                    if (hasOuterJoinKeyInfo) {
                        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"ResultHolder::prepareSend: Case of outer join. Writing key info.");
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::prepareSend: keys contained: " + row.getAllRegionAndKeyInfo()));
                        }
                        this.state = (byte)(this.state | 4);
                        DataSerializer.writeTreeSet(row.getAllRegionAndKeyInfo(), (DataOutput)((Object)this.hdos));
                    }
                    ++this.numRows;
                    if (beginsertime != 0L) {
                        this.ser_deser_time += XPLAINUtil.recordTiming(beginsertime);
                    }
                    if ((long)this.hdos.size() >= GemFireXDUtils.DML_MAX_CHUNK_SIZE) {
                        return true;
                    }
                }
            } else {
                this.hdos.clearForReuse();
            }
            if (this.hasRows) {
                boolean result;
                if (this.doProjection) {
                    if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + "::prepareSend: Serializing using DVD ExecRow"));
                    }
                    result = this.processRows(this.numEightColGroups, this.numPartCols, hasOuterJoinKeyInfo, this.hasLobs, this.isOffHeap, this.rf, this.hdos);
                } else {
                    if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                        if (!this.hasLobs) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + "::prepareSend: Serializing CompactExecRows"));
                        } else {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.toString() + "::prepareSend: Serializing CompactExecRowWithLobs"));
                        }
                    }
                    result = this.processRows(0, 0, hasOuterJoinKeyInfo, this.hasLobs, this.isOffHeap, this.rf, this.hdos);
                }
                if (!result) {
                    return true;
                }
            }
            long l = beginRemainingProcessTime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
            if (this.begin != -1L) {
                this.stats.incExecutionTimeDataNode(this.begin);
                this.stats.incNumRowsReturnedFromDataNode(this.numRows);
            }
            this.rows_returned = this.numRows;
            this.closeEmbedResultSet(this.es instanceof EmbedPreparedStatement, this.ers.getSourceResultSet().getActivation());
            if (this.sourceMessage != null) {
                tx = this.sourceMessage.getTXState();
                if (tx != null) {
                    this.txChanges = this.handleTXFinish((TXStateInterface)tx);
                    if (this.txChanges != null) {
                        this.state = (byte)(this.state | 0x20);
                    }
                }
            } else {
                GemFireTransaction tran;
                LanguageConnectionContext lcc;
                tx = this.es != null && (lcc = this.es.getEmbedConnection().getLanguageConnectionContext()) != null && (tran = (GemFireTransaction)lcc.getTransactionExecute()) != null ? tran.getActiveTXState() : null;
            }
            if (tx != null) {
                tx.flushPendingOps(null);
            }
            if (beginRemainingProcessTime != 0L) {
                this.process_time += XPLAINUtil.recordTiming(beginRemainingProcessTime);
            }
            if (observer != null) {
                observer.afterResultHolderIteration(this.wrapper, this.es);
                observer.beforeResultHolderSerialization(this.wrapper, this.es);
            }
            return false;
        }
        catch (Throwable t2) {
            RuntimeException t2;
            Error err;
            if (t2 instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t2))) {
                SystemFailure.initiateFailure((Error)err);
                throw err;
            }
            SystemFailure.checkFailure();
            if (t2 instanceof SQLException && "XCL32".equals(((SQLException)t2).getSQLState())) {
                throw (SQLException)t2;
            }
            try {
                Misc.checkIfCacheClosing(t2);
            }
            catch (RuntimeException re) {
                t2 = re;
            }
            this.state = (byte)(this.state | 1);
            this.exception = t2;
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"ResultHolder::prepareSend: got exception while sending", (Throwable)t2);
            } else if (GemFireXDUtils.TraceFunctionException | GemFireXDUtils.TraceExecution) {
                boolean printStack = false;
                for (Throwable fail = t2; fail != null; fail = fail.getCause()) {
                    if (!(fail instanceof Error) && (!(fail instanceof RuntimeException) || fail instanceof GemFireException || fail instanceof GemFireXDRuntimeException)) continue;
                    printStack = true;
                    break;
                }
                if (printStack) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"ResultHolder::prepareSend: got exception while sending", (Throwable)t2);
                } else {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::prepareSend: got exception while sending: " + t2));
                }
            }
            try {
                TXStateInterface tx;
                if (this.sourceMessage != null && (tx = this.sourceMessage.getTXState()) != null) {
                    this.txChanges = this.handleTXFinish(tx);
                    if (this.txChanges != null) {
                        this.state = (byte)(this.state | 0x20);
                    }
                }
            }
            catch (Throwable ex) {
                Error e;
                if (ex instanceof Error && SystemFailure.isJVMFailureError((Error)(e = (Error)ex))) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                SystemFailure.checkFailure();
                SanityManager.DEBUG_PRINT((String)"severe:QueryDistribution", (String)"ResultHolder::prepareSend: exception in TX proxy cleanup: ", (Throwable)ex);
                try {
                    Misc.checkIfCacheClosing(ex);
                }
                catch (RuntimeException re) {
                    t2 = re;
                }
            }
            this.state = (byte)(this.state | 1);
            this.exception = t2;
            return false;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        GemFireXDQueryObserver observer = this.observer;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("writing hasException false and doProjection=" + this.doProjection + " status=0x" + Integer.toHexString(this.state)));
        }
        long beginsertime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
        out.writeByte(this.state);
        if (this.txChanges != null) {
            this.txChanges.toData(out);
        }
        if (this.exception == null) {
            int numBytes = 0;
            long beginWrite = -1L;
            if (this.begin != -1L) {
                beginWrite = this.stats.getStatTime();
            }
            if (this.hdos != null) {
                numBytes = this.hdos.size();
                InternalDataSerializer.writeArrayLength((int)numBytes, (DataOutput)out);
                this.hdos.sendTo(out);
                this.stream_size = numBytes;
            } else {
                InternalDataSerializer.writeArrayLength((int)numBytes, (DataOutput)out);
            }
            if (this.begin != -1L) {
                assert (beginWrite != -1L);
                this.stats.incWriteResutlSetDataNode(beginWrite);
                this.stats.incNumBytesWrittenPreQuery(numBytes);
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::toData: Number of rows written=" + this.numRows + " Number of bytes (may be off by 1 or 2 bytes) written=" + (numBytes + 5)));
            }
            if (GemFireXDUtils.TraceRSIter & SanityManager.isFinerEnabled && this.hdos != null) {
                this.hdos.rewind();
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::toData: bytes written: " + Arrays.toString(this.hdos.toByteArray())));
            }
        } else {
            DataSerializer.writeObject((Object)this.exception, (DataOutput)out);
            DataSerializer.writeObject((Object)GemFireStore.getMyId(), (DataOutput)out);
        }
        this.ser_deser_time += beginsertime != 0L ? XPLAINUtil.recordTiming(beginsertime) : 0L;
        if (this.recordStats && this.ser_deser_time == 0L && this.process_time == 0L) {
            ++this.process_time;
        }
        if (observer != null) {
            observer.afterResultHolderSerialization(this.wrapper, this.es);
            observer.afterResultHolderExecution(this.wrapper, this.es, this.es.getSQLText());
        }
    }

    public String toString() {
        TXChanges txChanges;
        int ssize;
        StringBuilder sb = new StringBuilder("ResultHolder@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        Throwable t = this.exception;
        if (t != null) {
            sb.append(' ').append(t.toString());
            return sb.toString();
        }
        int numRows = this.numRows;
        if (numRows > 0) {
            sb.append(" numRows=").append(numRows);
        }
        if ((ssize = this.stream_size) > 0) {
            sb.append(" numBytes=").append(ssize);
        }
        if ((txChanges = this.txChanges) != null) {
            sb.append(' ').append(txChanges.toString());
        }
        return sb.toString();
    }

    private TXChanges handleTXFinish(TXStateInterface tx) {
        TXStateProxy txProxy = tx.getProxy();
        TXChanges txChanges = TXChanges.fromMessage(this.sourceMessage, (TXStateProxy)txProxy);
        if (this.sourceMessage.finishTXProxyRead() && !txProxy.isSnapshot()) {
            txProxy.removeSelfFromHostedIfEmpty(null);
        }
        return txChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupResults(GfxdResultCollector<?> collector, Activation act) throws SQLException {
        boolean hasNext;
        long beginitertime;
        block27: {
            beginitertime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
            this.nextRowIndex = 0;
            this.ers.setIsLocallyProcessing(true);
            if (this.ers.isForUpdate()) {
                ArrayList<ExecRow> allRows = new ArrayList<ExecRow>();
                boolean rowsCopiedOk = false;
                try {
                    while (this.ers.lightWeightNext()) {
                        Object byteSource;
                        ExecRow row = this.ers.getCurrentRow();
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::localResults: read row for update " + row));
                        }
                        ExecRow rowClone = row.getNewNullRow();
                        rowClone.setRowArrayClone(row, row.getAllRegionAndKeyInfo());
                        if (rowClone instanceof AbstractCompactExecRow && (byteSource = ((AbstractCompactExecRow)rowClone).getByteSource()) instanceof OffHeapByteSource) {
                            ((OffHeapByteSource)((Object)byteSource)).retain();
                        }
                        row.clearAllRegionAndKeyInfo();
                        allRows.add(rowClone);
                    }
                    this.candidateRowArraySize = allRows.size();
                    if (this.candidateRowArraySize > 0) {
                        this.candidateRowArray = new ExecRow[this.candidateRowArraySize];
                        allRows.toArray(this.candidateRowArray);
                    } else {
                        this.candidateRowArray = null;
                    }
                    rowsCopiedOk = true;
                }
                finally {
                    if (!rowsCopiedOk) {
                        this.freeOffHeapForCachedRows(allRows);
                    }
                }
                hasNext = false;
                TXStateProxy tx = this.sourceMessage.getTXProxy();
                if (tx != null) {
                    tx.flushPendingOps(null);
                }
            } else {
                hasNext = this.ers.lightWeightNext();
                if (hasNext) {
                    this.candidateRowArray = new ExecRow[this.batchSize];
                    int index = 0;
                    try {
                        while (true) {
                            Object byteSource;
                            ExecRow row = this.ers.getCurrentRow();
                            if (GemFireXDUtils.TraceRSIter) {
                                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::localResults: read row " + row));
                            }
                            ExecRow rowClone = row.getNewNullRow();
                            rowClone.setRowArrayClone(row, row.getAllRegionAndKeyInfo());
                            if (rowClone instanceof AbstractCompactExecRow && (byteSource = ((AbstractCompactExecRow)rowClone).getByteSource()) instanceof OffHeapByteSource) {
                                ((OffHeapByteSource)((Object)byteSource)).retain();
                            }
                            row.clearAllRegionAndKeyInfo();
                            this.candidateRowArray[index] = rowClone;
                            if (++index < this.batchSize && (hasNext = this.ers.lightWeightNext())) {
                                row = this.ers.getCurrentRow();
                                continue;
                            }
                            break block27;
                            break;
                        }
                    }
                    finally {
                        this.candidateRowArraySize = index;
                    }
                }
                this.candidateRowArray = null;
                this.candidateRowArraySize = 0;
            }
        }
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::localResults: hasNext=" + hasNext + ", candidateRowArraySize=" + this.candidateRowArraySize));
        }
        if (hasNext) {
            if (collector != null && (this.streamingHelper = collector.getStreamingHelper()) != null) {
                this.streamingHelper.addReference();
                this.streamingCollector = collector;
            } else {
                this.streamingHelper = null;
                this.streamingCollector = null;
            }
            this.state = (byte)(this.state | 0x40);
            this.hasMoreRows = true;
        } else {
            Misc.checkIfCacheClosing(null);
            this.close(act, this.es.getEmbedConnection());
            this.hasMoreRows = false;
        }
        if (beginitertime != 0L) {
            this.process_time += XPLAINUtil.recordTiming(beginitertime);
        }
        return hasNext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moveNextResults() throws StandardException {
        if (!this.hasMoreRows) {
            return false;
        }
        boolean hasNext = true;
        this.nextRowIndex = 0;
        this.candidateRowArraySize = 0;
        int index = -1;
        EmbedConnection conn = this.es.getEmbedConnection();
        Object object = conn.getConnectionSynchronization();
        synchronized (object) {
            conn.getTR().setupContextStack();
            this.ers.pushStatementContext(conn.getLanguageConnection(), true);
            this.ers.setIsLocallyProcessing(false);
            try {
                while (++index < this.batchSize) {
                    Object byteSource;
                    hasNext = false;
                    hasNext = this.ers.lightWeightNext();
                    if (!hasNext) break;
                    ExecRow row = this.ers.getCurrentRow();
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::localResults: read row " + row));
                    }
                    ExecRow candidateRow = this.candidateRowArray[index];
                    candidateRow.setColumns(null, row);
                    if (candidateRow instanceof AbstractCompactExecRow && (byteSource = ((AbstractCompactExecRow)candidateRow).getByteSource()) instanceof OffHeapByteSource) {
                        ((OffHeapByteSource)((Object)byteSource)).retain();
                    }
                    candidateRow.setAllRegionAndKeyInfo(row.getAllRegionAndKeyInfo());
                    row.clearAllRegionAndKeyInfo();
                }
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::localResults: hasNext=" + hasNext + ", candidateRowArraySize=" + this.candidateRowArraySize));
                }
                if (hasNext) {
                    boolean byteSource = true;
                    return byteSource;
                }
                Misc.checkIfCacheClosing(null);
                boolean byteSource = false;
                return byteSource;
            }
            catch (SQLException sqle) {
                throw Misc.wrapSQLException(sqle, sqle);
            }
            finally {
                this.candidateRowArraySize = index;
                GfxdConnectionWrapper.restoreContextStack(this.es, this.ers);
                this.hasMoreRows = hasNext;
                if (!this.hasMoreRows) {
                    this.close(null, conn);
                }
            }
        }
    }

    public final boolean isLocallyExecuted() {
        return this.sourceMessage != null && this.sourceMessage.isLocallyExecuted();
    }

    public final boolean isGenuinelyLocallyExecuted() {
        return this.ers != null;
    }

    public final void close(Activation act, EmbedConnection conn) {
        if (this.es != null) {
            if (this.streamingCollector != null) {
                this.streamingHelper.closeContainers(this.streamingCollector, false);
                this.streamingCollector = null;
                this.streamingHelper = null;
            }
            boolean isPrepStmt = this.es instanceof EmbedPreparedStatement;
            if (act == null) {
                act = this.ers.getSourceResultSet().getActivation();
            }
            this.closeEmbedResultSet(isPrepStmt, act);
            LanguageConnectionContext lcc = act.getLanguageConnectionContext();
            if (act != null) {
                act.setFlags(0);
                act.setFunctionContext(null);
            }
            if (lcc != null) {
                if (conn == null) {
                    conn = this.es.getEmbedConnection();
                }
                lcc.setFlags(this.origLCCFlags);
                lcc.setPossibleDuplicate(false);
                if (!isPrepStmt) {
                    lcc.setConstantValueSet(null, null);
                }
                if (!this.wrapper.isCached()) {
                    try {
                        if (isPrepStmt && !this.es.isClosed()) {
                            this.es.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.wrapper.close(false, false);
                }
            }
        }
    }

    public final void clear() {
        this.gps = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeEmbedResultSet(boolean isPrepStmt, Activation act) {
        this.gps = act.getPreparedStatement();
        if (this.es.getEmbedConnection().isClosed()) {
            return;
        }
        try {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("ResultHolder::closeERS: lightWeightClose isLocallyExecuted=" + this.isLocallyExecuted()));
            }
            if (this.isLocallyExecuted()) {
                this.ers.getSourceResultSet().markLocallyExecuted();
            }
            this.ers.lightWeightClose();
        }
        catch (Exception ex) {
            if (GemFireXDUtils.TraceFunctionException) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"ResultHolder::closeERS: Unexpected exception in ResultSet lightWeightClose", (Throwable)ex);
            }
        }
        finally {
            block17: {
                if (!isPrepStmt) {
                    try {
                        this.es.close();
                    }
                    catch (Exception ex) {
                        if (!GemFireXDUtils.TraceFunctionException) break block17;
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"ResultHolder::closeERS: Unexpected exception in statement close", (Throwable)ex);
                    }
                }
            }
        }
    }

    private boolean processRows(int numEightColGroups, int numPartCols, boolean hasOuterJoinKeyInfo, boolean hasLobs, boolean isOffHeap, RowFormatter rf, GfxdHeapDataOutputStream hdos) throws SQLException, IOException, StandardException {
        boolean result = true;
        int rowNumber = 1;
        long startSampleTime = 0L;
        long processTime = 0L;
        long serDeserTime = 0L;
        long throttleTime = 0L;
        while (true) {
            int resultSize;
            long beginsertime;
            long beginitertime;
            long l = beginitertime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
            if (!this.ers.lightWeightNext()) break;
            ExecRow row = this.ers.getCurrentRow();
            if (beginitertime != 0L) {
                beginsertime = XPLAINUtil.recordTiming(-1L);
                processTime += beginsertime - beginitertime;
            } else {
                beginsertime = 0L;
            }
            if (this.observer != null) {
                this.observer.afterResultHolderIteration(this.wrapper, this.es);
                this.observer.beforeResultHolderSerialization(this.wrapper, this.es);
            }
            if (numPartCols == 0) {
                Object brow;
                if (!hasLobs) {
                    if (!isOffHeap) {
                        brow = row.getRowBytes(rf);
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::processRows: CompactExecRow bytes: " + Arrays.toString((byte[])brow)));
                        }
                        DataSerializer.writeByteArray((byte[])brow, (DataOutput)((Object)hdos));
                    } else {
                        brow = row.getBaseByteSource();
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::processRows: OffHeapCompactExecRow bytes: " + Arrays.toString(row.getRowBytes(rf))));
                        }
                        if (brow != null) {
                            Class<?> rclass = brow.getClass();
                            if (rclass == OffHeapRow.class) {
                                ((OffHeapRow)((Object)brow)).toData((DataOutput)((Object)hdos));
                            } else if (rclass == byte[].class) {
                                DataSerializer.writeByteArray((byte[])((byte[])brow), (DataOutput)((Object)hdos));
                            } else {
                                ((OffHeapRowWithLobs)((Object)brow)).serializeGfxdBytesWithStats(0, (DataOutput)((Object)hdos));
                            }
                        } else {
                            DataSerializer.writeByteArray(null, (DataOutput)((Object)hdos));
                        }
                    }
                } else if (!isOffHeap) {
                    brow = row.getRowByteArrays(rf);
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::processRows: CompactExecRowWithLobs bytes: " + ArrayUtils.objectStringNonRecursive((Object)brow)));
                    }
                    DataSerializer.writeArrayOfByteArrays((byte[][])brow, (DataOutput)((Object)hdos));
                } else {
                    brow = row.getBaseByteSource();
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::processRows: OffHeapCompactExecRowWithLobs bytes: " + ArrayUtils.objectStringNonRecursive((Object)row.getRowByteArrays(rf))));
                    }
                    if (brow != null) {
                        Class<?> bclass = brow.getClass();
                        if (bclass == OffHeapRowWithLobs.class) {
                            ((OffHeapRowWithLobs)((Object)brow)).toData((DataOutput)((Object)hdos));
                        } else if (bclass == byte[][].class) {
                            DataSerializer.writeArrayOfByteArrays((byte[][])((byte[][])brow), (DataOutput)((Object)hdos));
                        } else {
                            int numLobs = rf.numLobs();
                            InternalDataSerializer.writeArrayLength((int)(numLobs + 1), (DataOutput)((Object)hdos));
                            ((OffHeapRow)((Object)brow)).toData((DataOutput)((Object)hdos));
                            for (int i = 1; i <= numLobs; ++i) {
                                DataSerializer.writeByteArray(null, (DataOutput)((Object)hdos));
                            }
                        }
                    } else {
                        DataSerializer.writeArrayOfByteArrays((byte[][])null, (DataOutput)((Object)hdos));
                    }
                }
            } else {
                DataValueDescriptor[] dvdArr = row.getRowArray();
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder::processRows: ExecRow: " + row));
                }
                DVDIOUtil.writeDVDArray(dvdArr, numEightColGroups, numPartCols, (DataOutput)((Object)hdos));
            }
            if (hasOuterJoinKeyInfo) {
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"ResultHolder::processRows: writing key info for outer join");
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::processRows: keys contained " + row.getAllRegionAndKeyInfo()));
                }
                DataSerializer.writeTreeSet(row.getAllRegionAndKeyInfo(), (DataOutput)((Object)hdos));
            }
            ++rowNumber;
            if (this.observer != null) {
                this.observer.beforeResultHolderIteration(this.wrapper, this.es);
                this.observer.afterResultHolderSerialization(this.wrapper, this.es);
            }
            if ((long)(resultSize = hdos.size()) >= GemFireXDUtils.DML_MAX_CHUNK_SIZE) {
                result = false;
                break;
            }
            if (beginsertime != 0L) {
                serDeserTime += XPLAINUtil.recordTiming(beginsertime);
            }
            if ((long)resultSize < GemFireXDUtils.DML_MIN_SIZE_FOR_STREAMING) continue;
            if (beginsertime != 0L) {
                if (serDeserTime + processTime >= 1000000L * (long)GemFireXDUtils.DML_MAX_CHUNK_MILLIS) {
                    result = false;
                    break;
                }
            } else if (rowNumber % GemFireXDUtils.DML_SAMPLE_INTERVAL == 0) {
                long currentTime = System.nanoTime();
                if (startSampleTime > 0L) {
                    if (currentTime - startSampleTime >= 1000000L * (long)GemFireXDUtils.DML_MAX_CHUNK_MILLIS) {
                        result = false;
                        break;
                    }
                } else {
                    startSampleTime = currentTime;
                }
            }
            if (rowNumber % 10 != 0 || !this.isCriticalUp()) continue;
            long beginThrottleTime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
            try {
                for (int tries = 1; tries <= 5; ++tries) {
                    Thread.sleep(4L);
                    if (this.isCriticalUp()) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                Misc.checkIfCacheClosing(ie);
            }
            if (beginThrottleTime == 0L) continue;
            throttleTime += XPLAINUtil.recordTiming(beginThrottleTime);
        }
        if (this.recordStats) {
            this.process_time += processTime;
            this.ser_deser_time += serDeserTime;
            this.throttle_time += throttleTime;
        }
        this.numRows += rowNumber - 1;
        return result;
    }

    private boolean isCriticalUp() {
        return this.thresholdListener.isCritical() || !this.sourceMessage.isLocallyExecuted() && this.thresholdListener.isCriticalUp((DistributedMember)this.sourceMessage.getSender());
    }

    public ExecRow getNext(ExecRow projRow, Activation act) throws StandardException {
        long beginitertime;
        long l = beginitertime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
        if (this.ers != null) {
            if (this.nextRowIndex >= this.candidateRowArraySize && this.hasMoreRows) {
                boolean hasNext = this.moveNextResults();
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::getNext: Local read: got next batch of size " + this.candidateRowArraySize + " hasNext=" + hasNext));
                }
            }
            if (this.nextRowIndex < this.candidateRowArraySize) {
                projRow = this.candidateRowArray[this.nextRowIndex++];
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::getNext: Local read: returning row {" + projRow + "} at index=" + (this.nextRowIndex - 1)));
                }
            } else {
                projRow = null;
            }
            if (beginitertime != 0L) {
                this.process_time += XPLAINUtil.recordTiming(beginitertime);
            }
            ++this.rows_returned;
            return projRow;
        }
        return this.readFromStream(projRow, act);
    }

    private ExecRow readFromStream(ExecRow projRow, Activation act) throws StandardException {
        long beginitertime;
        GemFireXDQueryObserver observer = this.observer;
        long l = beginitertime = this.recordStats ? XPLAINUtil.recordTiming(-1L) : 0L;
        if (this.dis.available() == 0) {
            throw new AssertionError((Object)"readFromStream should be invoked with data available");
        }
        if (observer != null) {
            observer.beforeResultSetHolderRowRead(this.rowFormatter, act);
        }
        byte state = this.state;
        boolean doProjection = GemFireXDUtils.isSet(state, (byte)2);
        boolean hasOuterJoinKeyInfo = GemFireXDUtils.isSet(state, (byte)4);
        boolean hasArrayOfBytes = GemFireXDUtils.isSet(state, (byte)8);
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder#getNext: invoked with doProjection=" + doProjection + " hasOuterJoinKeyInfo=" + hasOuterJoinKeyInfo + " hasArrayOfBytes=" + hasArrayOfBytes + " state=0x" + Integer.toHexString(state)));
        }
        if (!doProjection) {
            try {
                Object brow;
                RowFormatter rf = this.rowFormatter;
                assert (rf != null) : "ResultHolder#readFromStream: null RowFormatter is not allowed with no projection";
                if (!hasArrayOfBytes) {
                    brow = DataSerializer.readByteArray((DataInput)this.dis);
                    boolean isFullRow = rf.isTableFormatter();
                    if (projRow == null) {
                        projRow = rf.container.newExecRowFromBytes((byte[])brow, isFullRow ? rf.container.getRowFormatter((byte[])brow) : rf);
                    } else {
                        AbstractCompactExecRow crow = (AbstractCompactExecRow)projRow;
                        if (isFullRow) {
                            crow.setRowArray((byte[])brow, rf.container.getRowFormatter((byte[])brow));
                        } else {
                            crow.setRowArray((byte[])brow, rf);
                        }
                    }
                } else {
                    brow = DataSerializer.readArrayOfByteArrays((DataInput)this.dis);
                    boolean isFullRow = rf.isTableFormatter();
                    if (projRow == null) {
                        projRow = rf.container.newExecRowFromByteArrays((byte[][])brow, isFullRow ? rf.container.getRowFormatter((byte[][])brow) : rf);
                    } else {
                        AbstractCompactExecRow crow = (AbstractCompactExecRow)projRow;
                        if (isFullRow) {
                            crow.setRowArray((byte[][])brow, rf.container.getRowFormatter((byte[][])brow));
                        } else {
                            crow.setRowArray((byte[][])brow, rf);
                        }
                    }
                }
                TreeSet set = null;
                if (hasOuterJoinKeyInfo) {
                    set = DataSerializer.readTreeSet((DataInput)this.dis);
                    projRow.setAllRegionAndKeyInfo(set);
                }
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::getNext:Compact Row read: returning row = " + projRow));
                }
                this.process_time += beginitertime != 0L ? XPLAINUtil.recordTiming(beginitertime) : 0L;
                if (observer != null) {
                    observer.afterResultSetHolderRowRead(this.rowFormatter, projRow, act);
                }
                ++this.rows_returned;
                return projRow;
            }
            catch (IOException e) {
                throw GemFireXDRuntimeException.newRuntimeException("unexpected IOException", e);
            }
            catch (ClassNotFoundException e) {
                AssertionError ae = new AssertionError((Object)"unexpected ClassNotFoundException");
                ((Throwable)((Object)ae)).initCause(e);
                throw ae;
            }
        }
        assert (projRow != null) : "projRow must not be null";
        DataValueDescriptor[] dvdArr = projRow.getRowArray();
        if (this.distinctAggUnderlyingType != null) {
            if (GemFireXDUtils.TraceAggreg) {
                SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)"ResultHolder#getNext: Have distinct aggregates in the query...");
            }
            for (DataValueDescriptor dvd : dvdArr) {
                if (!(dvd instanceof DVDSet)) continue;
                ((DVDSet)dvd).setResultDescriptor(this.distinctAggUnderlyingType);
            }
            if (GemFireXDUtils.TraceAggreg) {
                for (int i = 0; i < dvdArr.length; ++i) {
                    if (!(dvdArr[i] instanceof DVDSet)) continue;
                    SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("ResultHolder::getNext: distinct aggregate's underlying type of dvdArr[" + i + "] is " + ((DVDSet)dvdArr[i]).getResultDescriptor() + " for 0x" + System.identityHashCode(dvdArr[i])));
                }
            }
        }
        int numCols = dvdArr.length;
        if (this.numEightColGrps < 0) {
            this.numEightColGrps = numCols / 8 + (numCols % 8 == 0 ? 0 : 1);
            this.numPartialCols = numCols % 8;
            if (this.numPartialCols == 0) {
                this.numPartialCols = 8;
            }
        }
        try {
            DVDIOUtil.readDVDArray(dvdArr, this.dis, this.numEightColGrps, this.numPartialCols);
            if (hasOuterJoinKeyInfo) {
                TreeSet set = DataSerializer.readTreeSet((DataInput)this.dis);
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::readFromStream: Outerjoin special case.Region & Keys received for tuple=" + set));
                }
                projRow.setAllRegionAndKeyInfo(set);
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::getNext:Value Row read: returning row = " + projRow));
            }
            this.process_time += beginitertime != 0L ? XPLAINUtil.recordTiming(beginitertime) : 0L;
            if (observer != null) {
                observer.afterResultSetHolderRowRead(this.rowFormatter, projRow, act);
            }
            ++this.rows_returned;
            return projRow;
        }
        catch (ClassNotFoundException cnfe) {
            throw StandardException.newException("XJ022.S", (Throwable)cnfe, (Object)cnfe.getMessage());
        }
        catch (IOException ioe) {
            throw StandardException.newException("XJ022.S", (Throwable)ioe, (Object)ioe.getMessage());
        }
    }

    public void applyRemoteTXChanges(DistributedMember sender) {
        TXChanges txChanges;
        if (this.ers == null && (txChanges = this.txChanges) != null) {
            try {
                txChanges.applyLocally(sender);
            }
            catch (Throwable t) {
                this.exception = t;
                this.exceptionMember = sender;
                this.dis = null;
            }
            this.txChanges = null;
        }
    }

    public final boolean hasProjectionFromRemote() {
        if (this.ers == null) {
            return GemFireXDUtils.isSet(this.state, (byte)2);
        }
        return true;
    }

    public final boolean hasNext(Activation act) throws StandardException {
        boolean hasMoreRows;
        if (this.ers != null) {
            if (this.nextRowIndex >= this.candidateRowArraySize && this.hasMoreRows) {
                boolean hasNext = this.moveNextResults();
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("ResultHolder::getNext: Local read: got next batch of size " + this.candidateRowArraySize + " hasNext=" + hasNext));
                }
            }
            boolean bl = hasMoreRows = this.nextRowIndex < this.candidateRowArraySize;
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder#hasNext: local result available=" + hasMoreRows));
            }
        } else {
            ByteArrayDataInput dis;
            Throwable t = this.exception;
            if (t != null) {
                this.processException(t, this.firstCall);
            }
            boolean bl = hasMoreRows = (dis = this.dis) != null && dis.available() > 0;
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("ResultHolder#hasNext: remote result available=" + hasMoreRows));
            }
            if (!hasMoreRows) {
                this.dis = null;
            }
        }
        this.firstCall = false;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ && !hasMoreRows) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"-- end of result holder iteration --");
        }
        if (!hasMoreRows && this.recordStats && this.process_time == 0L && this.ser_deser_time == 0L) {
            ++this.process_time;
        }
        return hasMoreRows;
    }

    private void processException(Throwable t, boolean firstCall) throws StandardException {
        if (firstCall) {
            GemFireXDUtils.throwIfRuntimeException(t);
        }
        GemFireXDUtils.processCancelException("ResultHolder::processException", t, this.exceptionMember);
        StandardException se = Misc.processFunctionException("getNext", t, this.exceptionMember, null, false);
        if (se != null) {
            throw se;
        }
        throw StandardException.newException("24000", t);
    }

    public long estimateMemoryUsage() throws StandardException {
        EmbedResultSet ers = this.ers;
        EmbedStatement es = this.es;
        if (es != null) {
            assert (ers != null);
            return Misc.estimateMemoryUsage(es.getEmbedConnection().getLanguageConnection(), ers.getSourceResultSet(), es.getSQLText());
        }
        return this.stream_size;
    }

    final Throwable getException() {
        return this.exception;
    }

    public void assertNoData() {
        if (this.dis != null) {
            SanityManager.THROWASSERT((String)"Data chunk not released ... possible memory overhead during statistics collection");
        }
    }

    public EmbedResultSet getERS() {
        try {
            SanityManager.ASSERT((this.ers == null || this.ers.isClosed() ? 1 : 0) != 0, (String)"ERS should be closed at this time, otherwise timings may not be appropriate.");
        }
        catch (SQLException ignore) {
            SanityManager.DEBUG_PRINT((String)"warning:TraceFunctionException", (String)("Ignoring exception " + ignore), (Throwable)ignore);
        }
        return this.ers;
    }

    public PreparedStatement getGPrepStmt() {
        return this.gps;
    }

    @Override
    public byte getGfxdID() {
        return 90;
    }

    public void buildResultSetString(StringBuilder builder) {
        if (this.ers != null) {
            this.ers.buildResultSetString(builder);
        }
    }

    public void freeOffHeapForCachedRowsAndCloseResultSet() {
        if (this.isGenuinelyLocallyExecuted()) {
            if (this.candidateRowArray != null && GemFireXDUtils.isOffHeapEnabled()) {
                while (this.nextRowIndex < this.candidateRowArraySize) {
                    ExecRow row;
                    if ((row = this.candidateRowArray[this.nextRowIndex++]) == null) continue;
                    row.releaseByteSource();
                }
            }
            this.close(null, null);
        }
    }

    private void freeOffHeapForCachedRows(List<ExecRow> results) {
        if (GemFireXDUtils.isOffHeapEnabled() && results != null) {
            for (ExecRow row : results) {
                if (row == null) continue;
                row.releaseByteSource();
            }
        }
    }

    public long[] snapshotStatistics() {
        return new long[]{this.ser_deser_time, this.process_time, this.throttle_time, this.numRows};
    }
}

