/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.THashMap;
import com.koloboke.function.LongObjPredicate;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.collection.LongObjectHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public final class GfxdConnectionWrapper {
    private EmbedConnection embedConn;
    private SoftReference<EmbedConnection> embedConnRef;
    private volatile String defaultSchema;
    private int flags;
    private static final int IS_REMOTE = 1;
    private static final int IS_REMOTE_DDL = 2;
    private final LongObjectHashMap<StmntWeakReference> stmntMap;
    private final long incomingConnId;
    private int syncVersion;
    private volatile boolean inUse;
    private volatile boolean hasWaiters;
    private final LongObjectHashMap<String> sqlMap;
    private final ReferenceQueue<EmbedStatement> refQueue;
    private ResultSetStatisticsVisitor visitor = null;

    GfxdConnectionWrapper(String defaultSchema, long incomingConnId, boolean isCached, boolean isRemote, boolean isRemoteDDL, Properties props) throws SQLException {
        this.defaultSchema = defaultSchema;
        this.incomingConnId = incomingConnId;
        if (isCached) {
            EmbedConnection conn;
            this.embedConn = conn = this.createConnection(defaultSchema, isRemote, isRemoteDDL, props);
            this.stmntMap = LongObjectHashMap.withExpectedSize((int)8);
            this.sqlMap = LongObjectHashMap.withExpectedSize((int)8);
            this.refQueue = new ReferenceQueue();
        } else {
            try {
                this.embedConn = GemFireXDUtils.getTSSConnection(true, isRemote, isRemoteDDL);
                if (defaultSchema != null) {
                    this.embedConn.setDefaultSchema(defaultSchema);
                } else {
                    this.embedConn.setDefaultSchema("APP");
                }
            }
            catch (StandardException sqle) {
                throw Util.generateCsSQLException(sqle);
            }
            this.stmntMap = null;
            this.sqlMap = null;
            this.refQueue = null;
        }
    }

    private EmbedConnection createConnection(String defaultSchema, boolean isRemote, boolean isRemoteDDL, Properties prop) throws SQLException {
        ConnectionStats stats;
        Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
        Properties props = new Properties(prop);
        GemFireStore store = Misc.getMemStoreBooting();
        props.putAll((Map<?, ?>)store.getDatabase().getAuthenticationService().getBootCredentials());
        String protocol = store.isSnappyStore() ? "jdbc:snappydata:" : "jdbc:gemfirexd:";
        EmbedConnection conn = InternalDriver.activeDriver().connect(protocol, props, -2L, this.incomingConnId, true, 0);
        conn.setInternalConnection();
        if (isRemote) {
            this.flags = GemFireXDUtils.set(this.flags, 1);
            if (isRemoteDDL) {
                this.flags = GemFireXDUtils.set(this.flags, 2);
            }
            LanguageConnectionContext lcc = conn.getLanguageConnection();
            lcc.setIsConnectionForRemote(true);
            lcc.setIsConnectionForRemoteDDL(isRemoteDDL);
            lcc.setSkipLocks(true);
        }
        conn.setTransactionIsolation(0);
        conn.setAutoCommit(false);
        if (defaultSchema != null) {
            conn.setDefaultSchema(defaultSchema);
        }
        if ((stats = InternalDriver.activeDriver().getConnectionStats()) != null) {
            stats.incInternalConnectionsOpen();
            stats.incInternalConnectionsOpened();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedStatement getStatement(String sql, long stmtId, boolean isPrepStmnt, boolean needGfxdSubActivation, boolean flattenSubquery, boolean allReplicated, THashMap ncjMetaData, boolean isCallableStmtWithCohort, long rootID, int stmtLevel) throws SQLException {
        EmbedStatement stmnt = null;
        if (isPrepStmnt) {
            if (this.stmntMap != null) {
                EmbedConnection conn = this.getConnection();
                assert (Thread.holdsLock(conn.getConnectionSynchronization()));
                LongObjectHashMap<StmntWeakReference> longObjectHashMap = this.stmntMap;
                synchronized (longObjectHashMap) {
                    this.cleanUpStmntMap();
                    Object sr = this.stmntMap.get(stmtId);
                    if (sr != null) {
                        stmnt = (EmbedStatement)((StmntWeakReference)sr).get();
                    }
                    if (stmnt == null || !stmnt.isActive() || isCallableStmtWithCohort) {
                        if (sql == null && (sql = (String)this.sqlMap.get(stmtId)) == null) {
                            throw new GemFireXDRuntimeException("unexpected null SQL string for statement with ID=" + stmtId + " for connId=" + this.incomingConnId + " connection: " + conn + ", for " + this);
                        }
                        stmnt = !isCallableStmtWithCohort ? this.getPreparedStatement(conn, stmtId, sql, needGfxdSubActivation, flattenSubquery, allReplicated, ncjMetaData, rootID, stmtLevel) : (EmbedStatement)((Object)this.getConnection().prepareCall(sql, stmtId));
                        this.stmntMap.justPut(stmtId, (Object)new StmntWeakReference(stmnt, stmtId, this.refQueue));
                        if (this.defaultSchema == null || !this.defaultSchema.equalsIgnoreCase("SNAPPY_HIVE_METASTORE")) {
                            this.sqlMap.justPut(stmtId, (Object)sql);
                        }
                        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GfxdConnectionWrapper: cached PreparedStatement with stmtId=" + stmtId + " for connId=" + this.incomingConnId + " SQL: " + sql + ", for " + this + " SQLMapSize = " + this.sqlMap.size()));
                        }
                    }
                }
            } else {
                stmnt = this.getPreparedStatement(this.getConnection(), stmtId, sql, needGfxdSubActivation, flattenSubquery, allReplicated, ncjMetaData, rootID, stmtLevel);
            }
        } else if (this.stmntMap != null) {
            EmbedConnection conn = this.getConnection();
            Assert.assertHoldsLock((Object)conn.getConnectionSynchronization(), (boolean)true);
            LongObjectHashMap<StmntWeakReference> longObjectHashMap = this.stmntMap;
            synchronized (longObjectHashMap) {
                this.cleanUpStmntMap();
                stmnt = (EmbedStatement)this.getConnection().createStatement(stmtId);
                this.stmntMap.justPut(stmtId, (Object)new StmntWeakReference(stmnt, stmtId, this.refQueue));
                if (GemFireXDUtils.TraceQuery) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GfxdConnectionWrapper: cached un-prepared statement with stmtId=" + stmtId + " for connId=" + this.incomingConnId + " SQL: " + sql + ", for " + this));
                }
            }
        } else {
            stmnt = (EmbedStatement)this.getConnection().createStatement(stmtId);
        }
        if (stmnt != null) {
            if (stmnt.getRootID() == 0L && rootID > 0L) {
                stmnt.setRootID(rootID);
            }
            if (stmnt.getStatementLevel() == 0L && stmtLevel > 0) {
                stmnt.setStatementLevel(stmtLevel);
            }
        }
        return stmnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedStatement getStatementForCancellation(long stmtId, long executionId) {
        EmbedStatement stmnt = null;
        if (this.stmntMap != null) {
            LongObjectHashMap<StmntWeakReference> longObjectHashMap = this.stmntMap;
            synchronized (longObjectHashMap) {
                this.cleanUpStmntMap();
                Object sr = this.stmntMap.get(stmtId);
                if (sr != null) {
                    stmnt = (EmbedStatement)((StmntWeakReference)sr).get();
                }
                if (stmnt != null) {
                    if (!stmnt.isActive()) {
                        return null;
                    }
                    if (executionId != 0L && (long)stmnt.getExecutionID() != executionId) {
                        return null;
                    }
                }
            }
        }
        return stmnt;
    }

    private EmbedConnection getEmbedConnection() {
        if (this.embedConn != null) {
            return this.embedConn;
        }
        assert (this.embedConnRef != null);
        return this.embedConnRef.get();
    }

    public final EmbedConnection getConnectionOrNull() {
        EmbedConnection conn = this.embedConn;
        if (conn != null && conn.isActive()) {
            return conn;
        }
        return null;
    }

    private EmbedConnection getConnection() throws SQLException {
        EmbedConnection conn = this.getConnectionOrNull();
        if (conn != null) {
            return conn;
        }
        SQLException sqle = Util.noCurrentConnection();
        Misc.checkIfCacheClosing(sqle);
        throw sqle;
    }

    public EmbedConnection getConnectionForSynchronization() throws SQLException {
        return this.getConnectionForSynchronization(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedConnection getConnectionForSynchronization(boolean incrementSyncVersion) throws SQLException {
        EmbedConnection conn;
        boolean doClearStatementMap = false;
        GfxdConnectionWrapper gfxdConnectionWrapper = this;
        synchronized (gfxdConnectionWrapper) {
            conn = this.getEmbedConnection();
            if (conn == null || !conn.isActive()) {
                int flags = this.flags;
                doClearStatementMap = true;
                this.embedConn = conn = this.createConnection(this.defaultSchema, GemFireXDUtils.isSet(flags, 1), GemFireXDUtils.isSet(flags, 2), null);
                this.embedConnRef = null;
            } else if (this.embedConnRef != null) {
                this.embedConn = conn;
                this.embedConnRef = null;
            }
            if (incrementSyncVersion) {
                ++this.syncVersion;
            }
        }
        if (doClearStatementMap) {
            this.clearStatementMap();
        }
        if (GemFireXDUtils.TraceLock) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GfxdConnectionWrapper: getting connection for lock on " + conn));
        }
        return conn;
    }

    public int convertToHardReference(EmbedConnection conn) throws SQLException {
        if (this.embedConn == null) {
            assert (this.embedConnRef != null);
            this.embedConn = this.embedConnRef.get();
            if (this.embedConn == null) {
                this.embedConn = conn;
            } else if (conn != this.embedConn) {
                throw new GemFireXDRuntimeException("unexpected change in Connection object while executing query");
            }
            this.embedConnRef = null;
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("converted " + conn + " to hard reference"));
            }
        }
        this.inUse = true;
        return this.syncVersion;
    }

    public synchronized boolean convertToSoftReference(int syncVersion) {
        if (this.embedConn != null && syncVersion == this.syncVersion) {
            if (GemFireXDUtils.TraceLock) {
                SanityManager.DEBUG_PRINT((String)"TraceLock_*", (String)("GfxdConnectionWrapper: converting to SoftReference and releasing any lock acquired for Connection: " + this.embedConn));
            }
            this.embedConnRef = new SoftReference<EmbedConnection>(this.embedConn);
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("converted " + this.embedConn + " to soft reference"));
            }
            this.embedConn = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnused() {
        if (this.inUse) {
            GfxdConnectionWrapper gfxdConnectionWrapper = this;
            synchronized (gfxdConnectionWrapper) {
                this.inUse = false;
                if (this.hasWaiters) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Object connForSync) {
        if (this.inUse && !Thread.holdsLock(connForSync)) {
            try {
                GfxdConnectionWrapper gfxdConnectionWrapper = this;
                synchronized (gfxdConnectionWrapper) {
                    this.hasWaiters = true;
                    int numLoops = 0;
                    while (this.inUse) {
                        this.wait(5L);
                        if (++numLoops % 1000 != 0) continue;
                        SanityManager.DEBUG_PRINT((String)"warning:WAITING", (String)("still waiting for connection " + this.incomingConnId + " to be available after " + numLoops + " tries"));
                    }
                    this.hasWaiters = false;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                Misc.checkIfCacheClosing(ie);
            }
        }
    }

    public static void restoreContextStack(EmbedStatement es, EmbedResultSet ers) {
        try {
            if (ers != null) {
                ers.popStatementContext();
            }
        }
        catch (Exception ignore) {
            if (GemFireXDUtils.TraceFunctionException) {
                SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("Got exception in popStatementContext " + ignore));
            }
        }
        finally {
            block14: {
                try {
                    es.restoreContextStack();
                }
                catch (Exception ignore) {
                    if (!GemFireXDUtils.TraceFunctionException) break block14;
                    SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)("Got exception in restoreContextStack " + ignore));
                }
            }
        }
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultSchema(String defaultSchema) throws SQLException {
        if (!(defaultSchema == null && this.defaultSchema == null || ArrayUtils.objectEquals((Object)defaultSchema, (Object)this.defaultSchema))) {
            EmbedConnection conn = this.getConnectionForSynchronization(false);
            Object object = conn.getConnectionSynchronization();
            synchronized (object) {
                if (defaultSchema != null) {
                    conn.setDefaultSchema(defaultSchema);
                } else {
                    conn.setDefaultSchema("APP");
                }
                this.defaultSchema = defaultSchema;
            }
        }
    }

    public long getIncomingConnectionId() {
        return this.incomingConnId;
    }

    private EmbedStatement getPreparedStatement(EmbedConnection conn, long stmtId, String sql, boolean needGfxdSubActivation, boolean flattenSubquery, boolean allReplicated, THashMap ncjMetaData, long rootID, int stmtLevel) throws SQLException {
        return (EmbedStatement)((Object)conn.prepareStatementByPassQueryInfo(stmtId, sql, needGfxdSubActivation, flattenSubquery, allReplicated, ncjMetaData, rootID, stmtLevel));
    }

    public Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.getConnection().prepareStatement(sql);
    }

    public void enableOpLogger() throws SQLException {
        LanguageConnectionContext lcc = this.getConnection().getLanguageConnection();
        lcc.getTransactionExecute().enableLogging();
    }

    public void disableOpLogger() throws SQLException {
        assert (this.embedConn != null);
        EmbedConnection conn = this.embedConn;
        if (!conn.isClosed()) {
            LanguageConnectionContext lcc = conn.getLanguageConnection();
            lcc.getTransactionExecute().disableLogging();
        }
    }

    public void close() {
        this.close(true, true);
    }

    public void close(boolean closeEmbedConn, boolean force) {
        EmbedConnection conn = this.getEmbedConnection();
        if (closeEmbedConn && conn != null && !conn.isActive()) {
            return;
        }
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("Closing connection: " + conn));
        }
        if (this.clearStatementMap()) {
            this.sqlMap.clear();
        }
        if (closeEmbedConn && conn != null) {
            try {
                conn.close(false);
            }
            catch (Exception e) {
                if (force) {
                    conn.forceClose();
                }
                throw GemFireXDRuntimeException.newRuntimeException("GfxdConnectionWrapper#close: unexpected exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearStatementMap() {
        if (this.stmntMap == null) {
            return false;
        }
        ArrayList<Object> stmts = null;
        LongObjectHashMap<StmntWeakReference> longObjectHashMap = this.stmntMap;
        synchronized (longObjectHashMap) {
            if (this.stmntMap.size() > 0) {
                CollectStmts collectStmts = new CollectStmts();
                this.stmntMap.forEachWhile((LongObjPredicate)collectStmts);
                stmts = collectStmts.stmts;
                this.stmntMap.clear();
            }
        }
        if (stmts != null) {
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            for (Object e : stmts) {
                EmbedStatement stmt = (EmbedStatement)e;
                try {
                    if (!stmt.isClosed()) {
                        stmt.close();
                    }
                    if (observer == null) continue;
                    observer.afterClosingWrapperPreparedStatement(stmt.getID(), this.incomingConnId);
                }
                catch (SQLException sqle) {
                    if (!GemFireXDUtils.TraceFunctionException) continue;
                    SanityManager.DEBUG_PRINT((String)"TraceFunctionException", (String)"GfxdConnectionWrapper#close: unexpected exception", (Throwable)sqle);
                }
            }
        }
        return true;
    }

    public boolean isClosed() {
        EmbedConnection conn = this.getEmbedConnection();
        if (conn != null) {
            return !conn.isActive();
        }
        return true;
    }

    public boolean isCached() {
        return this.stmntMap != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement(long statementID) throws SQLException {
        EmbedStatement es;
        Object stmt;
        LongObjectHashMap<StmntWeakReference> longObjectHashMap = this.stmntMap;
        synchronized (longObjectHashMap) {
            stmt = this.stmntMap.remove(statementID);
            this.cleanUpStmntMap();
        }
        if (stmt != null && (es = (EmbedStatement)((StmntWeakReference)stmt).get()) != null) {
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            es.close();
            if (observer != null) {
                observer.afterClosingWrapperPreparedStatement(statementID, this.incomingConnId);
            }
        }
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    public final EmbedStatement getStatementForTEST(long statementID) {
        Object sr;
        if (this.stmntMap != null && (sr = this.stmntMap.get(statementID)) != null) {
            return (EmbedStatement)((StmntWeakReference)sr).get();
        }
        return null;
    }

    public LongObjectHashMap<StmntWeakReference> getStatementMapForTEST() {
        return this.stmntMap;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getConnection().setAutoCommit(autoCommit);
    }

    public final LanguageConnectionContext getLanguageConnectionContext() throws SQLException {
        return this.getConnection().getLanguageConnection();
    }

    public void setLccFlags(LanguageConnectionContext lcc, boolean isPossibleDuplicate, boolean enableStats, boolean enableTimeStats, StatementExecutorMessage<?> message) throws SQLException {
        lcc.setPossibleDuplicate(isPossibleDuplicate);
        lcc.setStatsEnabled(enableStats, enableTimeStats, message != null && message.explainConnectionEnabled());
        lcc.setQueryHDFS(message != null && message.getQueryHDFS());
        if (lcc.getRunTimeStatisticsMode()) {
            try {
                this.visitor = lcc.getLanguageConnectionFactory().getExecutionFactory().getXPLAINFactory().getXPLAINVisitor(lcc, lcc.statsEnabled(), lcc.explainConnection());
            }
            catch (StandardException e) {
                throw PublicAPI.wrapStandardException(e);
            }
        } else {
            this.visitor = null;
        }
        if (message != null) {
            if (message.isSkipListeners()) {
                lcc.setSkipListeners();
            }
            lcc.setSkipConstraintChecks(message.isSkipConstraintChecks());
            if (message.getNCJMetaDataOnRemote() != null) {
                lcc.setNcjBatchSize(NcjHashMapWrapper.getBatchSize(message.getNCJMetaDataOnRemote()));
                lcc.setNcjCacheSize(NcjHashMapWrapper.getCacheSize(message.getNCJMetaDataOnRemote()));
            }
        }
    }

    public void setLccFlags(LanguageConnectionContext lcc, boolean isPossibleDuplicate, boolean enableStats, boolean enableTimeStats, ParameterValueSet constantValueSet, StatementExecutorMessage<?> message) throws SQLException {
        this.setLccFlags(lcc, isPossibleDuplicate, enableStats, enableTimeStats, message);
        if (constantValueSet != null) {
            lcc.setConstantValueSet(null, constantValueSet);
        }
    }

    public static final void checkForTransaction(EmbedConnection conn, GemFireTransaction tran, TXStateInterface tx) throws SQLException {
        int currentIsolationLevel = conn.getTransactionIsolation();
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GfxdConnectionWrapper#checkForTransaction: GFE TX ID=" + TXManagerImpl.getCurrentTXId() + " current isolation level=" + currentIsolationLevel + "; required isolation level=" + (tx == null ? 0 : tx.getIsolationLevel().getJdbcIsolationLevel())));
        }
        if (tx == null) {
            tran.clearActiveTXState(false, true);
            return;
        }
        int reqIsolationLevel = tx.getIsolationLevel().getJdbcIsolationLevel();
        if (tx.isSnapshot()) {
            tran.setActiveTXState(tx, false);
            return;
        }
        if (reqIsolationLevel == currentIsolationLevel) {
            tran.setActiveTXState(tx, true);
            return;
        }
        if (currentIsolationLevel != 0) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"StatementQueryExecutor#checkForTransaction: TX boundary changing -- executing commit");
            }
            conn.setTransactionIsolation(reqIsolationLevel);
        } else {
            conn.setTransactionIsolation(reqIsolationLevel);
        }
        tran.setActiveTXState(tx, true);
    }

    private void cleanUpStmntMap() {
        StmntWeakReference sRef;
        while ((sRef = (StmntWeakReference)this.refQueue.poll()) != null) {
            long stmntId = sRef.getStatementId();
            this.removeWeakReferenceFromStmntMap(stmntId, sRef);
        }
    }

    private void removeWeakReferenceFromStmntMap(long stmntId, StmntWeakReference sRef) {
        assert (Thread.holdsLock(this.stmntMap));
        if (this.stmntMap.get(stmntId) == sRef && GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GfxdConnectionWrapper#removeWeakReferenceFromStmntMap: removing statement with id: " + stmntId));
            this.stmntMap.remove(stmntId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStmtFromMap(long stmntId) {
        if (this.stmntMap != null) {
            LongObjectHashMap<StmntWeakReference> longObjectHashMap = this.stmntMap;
            synchronized (longObjectHashMap) {
                this.stmntMap.remove(stmntId);
            }
        }
    }

    public final <T> void process(EmbedConnection conn, ResultHolder rh, EmbedStatement estmt, StatementExecutorMessage<T> executorMessage) throws StandardException {
        if (this.visitor == null) {
            return;
        }
        if (rh != null) {
            this.visitor.process(conn, executorMessage, rh, executorMessage.isLocallyExecuted());
        } else {
            this.visitor.process(conn, executorMessage, estmt, executorMessage.isLocallyExecuted());
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.afterQueryPlanGeneration();
        }
    }

    public static class StmntWeakReference
    extends WeakReference<EmbedStatement> {
        private final long stmntId;

        public StmntWeakReference(EmbedStatement stmnt, long stmntId, ReferenceQueue<EmbedStatement> refQueue) {
            super(stmnt, refQueue);
            this.stmntId = stmntId;
        }

        public long getStatementId() {
            return this.stmntId;
        }
    }

    private static final class CollectStmts
    implements LongObjPredicate<StmntWeakReference> {
        ArrayList<Object> stmts;

        private CollectStmts() {
        }

        public boolean test(long id, StmntWeakReference stmtRef) {
            Object stmt = stmtRef.get();
            if (stmt != null) {
                if (this.stmts == null) {
                    this.stmts = new ArrayList();
                }
                this.stmts.add(stmt);
            }
            return true;
        }
    }
}

