/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.internal.cache.PolicyTableData;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.diag.HiveTablesVTI;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysPoliciesVTI
extends GfxdVTITemplate
implements GfxdVTITemplateNoAllNodesRoute {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Iterator<PolicyTableData> policyDatas;
    private PolicyTableData currentPolicyMeta;
    private static final String POLICYNAME = "NAME";
    private static final String SCHEMANAME = "SCHEMANAME";
    private static final String TABLE = "TABLENAME";
    private static final String FOR = "POLICYFOR";
    private static final String APPLYTO = "APPLYTO";
    private static final String FILTER = "FILTER";
    private static final String OWNER = "OWNER";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("NAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("POLICYFOR", 12, false, 64), EmbedResultSetMetaData.getResultColumnDescriptor("APPLYTO", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("FILTER", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("OWNER", 12, true, 512)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public boolean next() {
        if (this.policyDatas == null) {
            ExternalCatalog hiveCatalog;
            if (!Boolean.TRUE.equals(HiveTablesVTI.SKIP_HIVE_TABLE_CALLS.get()) && (hiveCatalog = Misc.getMemStore().getExternalCatalog()) != null) {
                try {
                    this.policyDatas = hiveCatalog.getPolicies(true).iterator();
                }
                catch (Exception e) {
                    this.logger.warn("ERROR in retrieving Policies : " + e.toString());
                    this.policyDatas = Collections.emptyIterator();
                }
            } else {
                this.policyDatas = Collections.emptyIterator();
            }
        }
        if (this.policyDatas.hasNext()) {
            this.currentPolicyMeta = this.policyDatas.next();
            return true;
        }
        this.currentPolicyMeta = null;
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        switch (columnNumber) {
            case 1: {
                return this.currentPolicyMeta.policyName;
            }
            case 2: {
                return this.currentPolicyMeta.schemaName;
            }
            case 3: {
                return this.currentPolicyMeta.tableName;
            }
            case 4: {
                return this.currentPolicyMeta.policyFor;
            }
            case 5: {
                return this.currentPolicyMeta.policyApplyTo;
            }
            case 6: {
                return this.currentPolicyMeta.filter;
            }
            case 7: {
                return this.currentPolicyMeta.owner;
            }
        }
        throw new GemFireXDRuntimeException("unexpected column=" + columnNumber + " for HiveTablesVTI");
    }
}

