/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractDBSynchronizerMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class CacheLoadedDBSynchronizerMessage
extends AbstractDBSynchronizerMessage {
    private boolean transactional;
    private static final short IS_TRANSACTIONAL = 64;

    public CacheLoadedDBSynchronizerMessage() {
    }

    public CacheLoadedDBSynchronizerMessage(LocalRegion rgn, Object key, Object value, boolean isTransactional) {
        super(rgn);
        this.transactional = isTransactional;
        EntryEventImpl event = this.getEntryEventImpl();
        event.disallowOffHeapValues();
        event.setKey(key);
        event.setNewValue(value);
        event.setCallbackArgument((Object)GemFireXDUtils.wrapCallbackArgs(null, null, isTransactional, false, true, true, true, false, false));
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.transactional = (this.flags & 0x40) != 0;
        try {
            EntryEventImpl event = this.getEntryEventImpl();
            if (event != null) {
                event.disallowOffHeapValues();
                event.setKey(DataSerializer.readObject((DataInput)in));
                event.setNewValue(DataSerializer.readObject((DataInput)in));
                event.setCallbackArgument((Object)GemFireXDUtils.wrapCallbackArgs(null, null, this.transactional, false, true, true, true, false, false));
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        try {
            EntryEventImpl event = this.getEntryEventImpl();
            DataSerializer.writeObject((Object)event.getKey(), (DataOutput)out);
            DataSerializer.writeObject((Object)event.getNewValueAsOffHeapDeserializedOrRaw(), (DataOutput)out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected final short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.transactional) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        EntryEventImpl event = this.getEntryEventImpl();
        if (event != null) {
            sb.append(";key=").append(event.getKey()).append(";value=").append(event.getRawNewValue()).append(";transactional=").append(this.transactional);
        }
    }

    @Override
    public byte getGfxdID() {
        return 35;
    }

    @Override
    EnumListenerEvent getListenerEvent() {
        return EnumListenerEvent.AFTER_CREATE;
    }

    @Override
    Operation getOperation() {
        return Operation.NET_LOAD_CREATE;
    }

    @Override
    boolean skipListeners() {
        return true;
    }
}

