/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.AbstractOperationMessage;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLFinishMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessageProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdWaitingReplyProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GfxdDDLReplayInProgressException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import io.snappydata.collection.LongObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GfxdDDLMessage
extends GfxdMessage
implements MessageWithReply {
    DDLArgs args;
    private static final LongObjectHashMap<GfxdDDLMessage> pendingDDLMessages = LongObjectHashMap.withExpectedSize((int)4);
    private static final DDLListener departedLister = new DDLListener();

    public static void send(InternalDistributedSystem system, GfxdWaitingReplyProcessor processor, Set<DistributedMember> members, DDLConflatable ddl, long connId, long ddlId, LanguageConnectionContext lcc) throws StandardException, SQLException {
        GfxdDDLMessage.send(system, processor, members, ddl, connId, ddlId, lcc, false);
    }

    public static void send(InternalDistributedSystem system, GfxdReplyMessageProcessor processor, Set<DistributedMember> members, DDLConflatable ddl, long connId, long ddlId, LanguageConnectionContext lcc, boolean persistOnHDFS) throws StandardException, SQLException {
        GfxdDDLMessage msg = new GfxdDDLMessage();
        msg.args = new DDLArgs(ddl, connId, ddlId, lcc.statsEnabled(), lcc.timeStatsEnabled(), persistOnHDFS);
        msg.setRecipients(members);
        msg.send(system, system.getDistributionManager(), processor, true, false);
    }

    public static MembershipListener getMemberDepartedListener() {
        return departedLister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void processMessage(DistributionManager dm) throws GemFireCheckedException {
        GemFireStore memStore = Misc.getMemStore();
        LogWriter logger = dm.getLoggerI18n().convertToLogWriter();
        DDLConflatable ddl = this.args.getDDL();
        long ddlId = this.args.id;
        if (!memStore.initialDDLReplayDone()) {
            throw new GfxdDDLReplayInProgressException("Received ddl " + ddl + " from sender " + this.getSender() + " while ddl replay is still in progress");
        }
        String schemaForTable = ddl.getSchemaForTableNoThrow();
        if (!(GemFireXDUtils.getMyVMKind().isAccessorOrStore() || !FabricDatabase.disallowMetastoreOnLocator && schemaForTable != null && Misc.isSnappyHiveMetaTable(schemaForTable))) {
            if (GemFireXDUtils.TraceDDLQueue) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + " Skipping execution of DDL on " + GemFireXDUtils.getMyVMKind() + " JVM"));
            }
            LongObjectHashMap<GfxdDDLMessage> longObjectHashMap = pendingDDLMessages;
            // MONITORENTER : longObjectHashMap
            this.args.connId = -1L;
            pendingDDLMessages.justPut(ddlId, (Object)this);
            // MONITOREXIT : longObjectHashMap
            return;
        }
        if (GemFireXDUtils.TraceDDLReplay || !Misc.isSnappyHiveMetaTable(ddl.getCurrentSchema())) {
            SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)(this.toString() + " Starting execution"));
        }
        GfxdConnectionWrapper wrapper = null;
        String ddlStatement = ddl.getValueToConflate();
        boolean success = false;
        LanguageConnectionContext lcc = null;
        int oldFlags = 0;
        Object oldContext = null;
        try {
            wrapper = GfxdConnectionHolder.getOrCreateWrapper(ddl.getCurrentSchema(), this.args.connId, true, null);
            EmbedConnection conn = wrapper.getConnectionForSynchronization();
            Object object = conn.getConnectionSynchronization();
            // MONITORENTER : object
            wrapper.convertToHardReference(conn);
            lcc = wrapper.getLanguageConnectionContext();
            oldFlags = lcc.getFlags();
            wrapper.setLccFlags(lcc, false, this.args.statsEnabled(), this.args.timeStatsEnabled(), null);
            GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
            tran.clearActiveTXState(true, false);
            oldContext = lcc.getContextObject();
            lcc.setContextObject(ddl.getAdditionalArgs());
            lcc.setDefaultPersistent(ddl.defaultPersistent());
            lcc.setPersistMetaStoreInDataDictionary(ddl.persistMetaStoreInDataDictionary());
            lcc.setQueryRoutingFlag(false);
            tran.setDDLId(ddlId);
            wrapper.enableOpLogger();
            Statement stmt = wrapper.createStatement();
            try {
                stmt.execute(ddlStatement);
                if (stmt.getWarnings() != null) {
                    GfxdDDLMessage.logWarnings(stmt, ddlStatement, this.toString() + " SQL warning in executing DDL: ", logger);
                }
                if (this.args.persistOnHDFS()) {
                    ArrayList<HDFSStoreImpl> destinationhdfsStores;
                    if (GemFireXDUtils.TraceDDLReplay) {
                        SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)("GfxdDDLMessage: Persisting statement on HDFS: " + ddl.getValueToConflate()));
                    }
                    if ((destinationhdfsStores = EmbedStatement.getDestinationHDFSStoreForDDL(ddl, lcc)) != null && destinationhdfsStores.size() != 0) {
                        EmbedStatement.persistOnHDFS(ddl, lcc, destinationhdfsStores);
                    }
                }
                success = true;
            }
            finally {
                block38: {
                    block37: {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {
                            if (!logger.severeEnabled()) break block37;
                            logger.severe(this.toString() + " Unexpected exception in closing DDL", (Throwable)ex);
                        }
                    }
                    if (!success) {
                        if (GemFireXDUtils.TraceDDLReplay) {
                            SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)(this.toString() + " rolling back"));
                        }
                        try {
                            if (wrapper != null) {
                                wrapper.rollback();
                            }
                        }
                        catch (SQLException ex) {
                            if (!logger.severeEnabled()) break block38;
                            logger.severe(this.toString() + " SQL exception in rolling back DDL", (Throwable)ex);
                        }
                    }
                }
            }
            LongObjectHashMap<GfxdDDLMessage> longObjectHashMap = pendingDDLMessages;
            // MONITORENTER : longObjectHashMap
            pendingDDLMessages.justPut(ddlId, (Object)this);
            // MONITOREXIT : longObjectHashMap
            // MONITOREXIT : object
            if (GemFireXDUtils.TraceDDLReplay) {
                SanityManager.DEBUG_PRINT((String)"TraceDDLReplay", (String)(this.toString() + " Successfully executed"));
            }
            if (lcc != null) {
                lcc.setFlags(oldFlags);
                lcc.setPersistMetaStoreInDataDictionary(true);
                lcc.setContextObject(oldContext);
            }
            if (success) return;
            if (wrapper == null) return;
            wrapper.markUnused();
            return;
        }
        catch (StandardException ex) {
            try {
                if (!logger.warningEnabled()) throw new ReplyException("Unexpected StandardException on member " + dm.getDistributionManagerId(), (Throwable)ex);
                logger.warning(this.toString() + " Standard exception in executing DDL", (Throwable)ex);
                throw new ReplyException("Unexpected StandardException on member " + dm.getDistributionManagerId(), (Throwable)ex);
                catch (SQLException ex2) {
                    if (!logger.warningEnabled()) throw new ReplyException("Unexpected SQLException on member " + dm.getDistributionManagerId(), (Throwable)ex2);
                    logger.warning(this.toString() + " SQL exception in executing DDL", (Throwable)ex2);
                    throw new ReplyException("Unexpected SQLException on member " + dm.getDistributionManagerId(), (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                if (lcc != null) {
                    lcc.setFlags(oldFlags);
                    lcc.setPersistMetaStoreInDataDictionary(true);
                    lcc.setContextObject(oldContext);
                }
                if (success) throw throwable;
                if (wrapper == null) throw throwable;
                wrapper.markUnused();
                throw throwable;
            }
        }
    }

    @Override
    protected void sendReply(ReplyException ex, DistributionManager dm) {
        ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, (ReplyException)ex, (ReplySender)dm, (AbstractOperationMessage)this);
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return false;
    }

    @Override
    protected void handleReplyException(String exPrefix, ReplyException re, GfxdReplyMessageProcessor processor) throws StandardException {
        try {
            super.handleReplyException(exPrefix, re, processor);
            GemFireStore.VMKind myKind = GemFireXDUtils.getMyVMKind();
            if (myKind == null || !myKind.isStore()) {
                int numStores = 0;
                InternalDistributedMember[] recipients = this.getRecipients();
                GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
                Map<DistributedMember, ReplyException> exceptions = processor.getReplyExceptions();
                for (InternalDistributedMember m : recipients) {
                    GfxdDistributionAdvisor.GfxdProfile profile = advisor.getProfile(m);
                    if (profile == null || !profile.getVMKind().isStore()) continue;
                    if (exceptions != null && !exceptions.containsKey(m)) {
                        return;
                    }
                    ++numStores;
                }
                if (exceptions != null || numStores <= 1) {
                    this.handleUnexpectedReplyException(exPrefix, re);
                }
            }
        }
        catch (SQLException sqle) {
            throw Misc.wrapRemoteSQLException(sqle, re, (DistributedMember)re.getSender());
        }
    }

    @Override
    protected void handleProcessorReplyException(String exPrefix, ReplyException replyEx) throws SQLException, StandardException {
        Throwable t = replyEx.getCause();
        if (!GemFireXDUtils.nodeFailureException(t)) {
            this.handleUnexpectedReplyException(exPrefix, replyEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GfxdDDLMessage removePendingDDLMessage(long ddlId) {
        LongObjectHashMap<GfxdDDLMessage> longObjectHashMap = pendingDDLMessages;
        synchronized (longObjectHashMap) {
            return (GfxdDDLMessage)pendingDDLMessages.remove(ddlId);
        }
    }

    @Override
    public byte getGfxdID() {
        return 1;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject((Object)this.args, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.args = (DDLArgs)DataSerializer.readObject((DataInput)in);
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; connectionID=").append(this.args.connId).append("; statementID=").append(this.args.id).append("; ddl=").append(this.args.ddl);
    }

    private static final class DDLListener
    implements MembershipListener {
        private DDLListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void memberDeparted(InternalDistributedMember member, boolean crashed) {
            ArrayList memberPendingMessages = new ArrayList(4);
            LongObjectHashMap longObjectHashMap = pendingDDLMessages;
            synchronized (longObjectHashMap) {
                pendingDDLMessages.forEachWhile((ddlId, pendingMessage) -> {
                    if (member.equals(pendingMessage.getSender())) {
                        memberPendingMessages.add(pendingMessage);
                        pendingDDLMessages.remove(ddlId);
                    }
                    return true;
                });
            }
            InternalDistributedSystem sys = Misc.getDistributedSystem();
            for (GfxdDDLMessage pendingMessage2 : memberPendingMessages) {
                String actionStr;
                boolean doCommit = pendingMessage2.args.ddl.isDropStatement();
                if (doCommit) {
                    actionStr = "committed";
                    GfxdDDLFinishMessage.doPutInDDLRegion(pendingMessage2.args.id, pendingMessage2.args.ddl, -1L, "MembershipListener for DDLs:");
                } else {
                    actionStr = "rolled back";
                }
                if (pendingMessage2.args.connId == -1L) continue;
                long connId = pendingMessage2.args.connId;
                GfxdConnectionWrapper wrapper = GfxdConnectionHolder.getHolder().removeWrapper(connId);
                boolean[] markUnused = new boolean[]{false};
                try {
                    GfxdDDLFinishMessage.doCommitOrRollback(wrapper, doCommit, sys.getDistributionManager(), pendingMessage2.args.id, connId, "MembershipListener for DDLs: successfully " + actionStr + " [" + pendingMessage2 + "] for failed origin node " + member, markUnused);
                }
                catch (SQLException sqle) {
                    LogWriter logger = sys.getLogWriter();
                    if (!logger.warningEnabled()) continue;
                    logger.warning("Membership listener for " + this.toString() + ": Failure in rolling back for failed origin node " + member);
                }
                finally {
                    if (wrapper == null || !markUnused[0]) continue;
                    wrapper.markUnused();
                }
            }
        }

        public void memberJoined(InternalDistributedMember member) {
        }

        public void memberSuspect(InternalDistributedMember member, InternalDistributedMember whoSuspected) {
        }

        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }
    }

    public static final class DDLArgs
    extends GfxdDataSerializable {
        private DDLConflatable ddl;
        private long connId;
        private long id;
        private byte flags;
        private static final byte ENABLE_STATS = 1;
        private static final byte ENABLE_TIMESTATS = 2;
        private static final byte PERSIST_ON_HDFS = 4;

        public DDLArgs() {
        }

        DDLArgs(DDLConflatable ddl, long connId, long id, boolean enableStats, boolean enableTimeStats, boolean persistOnHDFS) {
            this.ddl = ddl;
            this.connId = connId;
            this.id = id;
            if (enableStats) {
                this.flags = GemFireXDUtils.set(this.flags, (byte)1);
                if (enableTimeStats) {
                    this.flags = GemFireXDUtils.set(this.flags, (byte)2);
                }
            }
            if (persistOnHDFS) {
                this.flags = GemFireXDUtils.set(this.flags, (byte)4);
            }
        }

        @Override
        public byte getGfxdID() {
            return 96;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writePrimitiveByte((byte)this.flags, (DataOutput)out);
            out.writeLong(this.connId);
            out.writeLong(this.id);
            InternalDataSerializer.invokeToData((DataSerializableFixedID)this.ddl, (DataOutput)out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.flags = DataSerializer.readPrimitiveByte((DataInput)in);
            this.connId = in.readLong();
            this.id = in.readLong();
            this.ddl = new DDLConflatable();
            InternalDataSerializer.invokeFromData((DataSerializableFixedID)this.ddl, (DataInput)in);
        }

        public long getDDLUniqueId() {
            return this.id;
        }

        public long getUniqueConnId() {
            return this.connId;
        }

        public DDLConflatable getDDL() {
            return this.ddl;
        }

        public boolean statsEnabled() {
            return GemFireXDUtils.isSet(this.flags, (byte)1);
        }

        public boolean timeStatsEnabled() {
            return GemFireXDUtils.isSet(this.flags, (byte)2);
        }

        public boolean persistOnHDFS() {
            return GemFireXDUtils.isSet(this.flags, (byte)4);
        }
    }
}

