/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.query.IndexMaintenanceException;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTHashSet;
import com.gemstone.gemfire.internal.concurrent.MapCallback;
import com.gemstone.gemfire.internal.concurrent.MapCallbackAdapter;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.Hash1IndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemIndexOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexInsertOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexRefreshIndexKeyOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.WrapperRowLocationForTxn;
import java.io.IOException;

public final class SortedMap2IndexDeleteOperation
extends MemIndexOperation {
    protected final boolean isUnique;
    protected boolean deleteSuccess;
    private final Object deletedValue;
    static final Object UPDATE_MAPKEY_SKIPPED_TOKEN = new Object();
    static final UpdateReplacementValue deleteCb = new UpdateReplacementValue(){

        public Object removeValue(Object key, Object value, Object existingValue, GemFireContainer container, Object deletedValue) {
            Object result = null;
            Class<?> cls = existingValue.getClass();
            if (cls == RowLocation[].class) {
                result = SortedMap2IndexDeleteOperation.deleteFromRowLocationArray(key, value, existingValue);
            } else if (cls == ConcurrentTHashSet.class) {
                result = SortedMap2IndexDeleteOperation.deleteFromHashSet(key, value, existingValue, container);
            } else if (value == existingValue) {
                result = MemIndexOperation.TOK_INDEX_KEY_DEL;
            } else if (!(existingValue instanceof RowLocation)) {
                SortedMap2IndexDeleteOperation.snapshotKeyBytesOnError(key, deletedValue);
                if (GemFireXDUtils.TracePersistIndex) {
                    MemIndexOperation.dumpIndex(container, "Unknown Data type in index");
                }
                GemFireXDUtils.throwAssert("Unknown data type in index with type: " + cls + "; oldValue: " + existingValue);
            }
            if (result != null) {
                if (result != MemIndexOperation.TOK_INDEX_KEY_DEL) {
                    return result;
                }
                return null;
            }
            SortedMap2IndexDeleteOperation.snapshotKeyBytesOnError(key, deletedValue);
            throw new IndexMaintenanceException((Throwable)GemFireXDUtils.newOldValueNotFoundException(key, value, existingValue, container));
        }

        public void postRemove(Object mapKey, Object value, Object existingValue, GemFireContainer container, Object deletedValue) {
            if (mapKey instanceof CompactCompositeIndexKey) {
                if (GemFireXDUtils.TraceIndex) {
                    GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp::postRemove snap shotting key bytes in index key= %s", mapKey);
                }
                if (((CompactCompositeIndexKey)mapKey).snapshotKeyFromValue() == null) {
                    GemFireXDUtils.throwAssert("key bytes cannot be null");
                }
            }
        }

        public Object onOperationFailed(Object key, Object oldValue, Object updatedValue, Object newValue, GemFireContainer container, Object params) {
            if (updatedValue instanceof ConcurrentTHashSet) {
                return !((ConcurrentTHashSet)updatedValue).contains(oldValue) ? updatedValue : null;
            }
            return null;
        }
    };

    public SortedMap2IndexDeleteOperation(GemFireContainer container, Object key, RowLocation deletedRow, boolean isUnique, Object deletedValue) {
        super(container, key, deletedRow);
        this.isUnique = isUnique;
        this.deletedValue = deletedValue;
    }

    @Override
    public void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.deleteSuccess = SortedMap2IndexDeleteOperation.doMe(null, this.memcontainer, this.key, this.row, this.isUnique, this.deletedValue);
    }

    public static boolean doMe(GemFireTransaction tran, GemFireContainer container, Object key, RowLocation deletedRow, boolean isUnique, Object deletedValue) throws StandardException {
        if (tran != null && tran.needLogging()) {
            SortedMap2IndexDeleteOperation op = new SortedMap2IndexDeleteOperation(container, key, deletedRow, isUnique, deletedValue);
            tran.logAndDo(op);
            return op.deleteSuccess;
        }
        return SortedMap2IndexDeleteOperation.deleteFromSkipListMap(container, key, deletedRow, isUnique, deletedValue);
    }

    private static boolean deleteFromSkipListMap(GemFireContainer container, Object key, RowLocation deletedRow, boolean isUnique, Object deletedValue) throws StandardException {
        boolean success;
        ConcurrentSkipListMap<Object, Object> skipListMap = container.getSkipListMap();
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp: deleting key=%s with value=(%s) from %s", key, deletedRow, container);
        }
        assert (key != null) : "The key for index operation cannot be null";
        assert (deletedRow != null) : "The value for index operation cannot be null";
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null && deletedRow.getTXId() != null && !(deletedRow instanceof WrapperRowLocationForTxn)) {
            observer = null;
        }
        deletedRow.markDeleteFromIndexInProgress();
        try {
            if (observer != null) {
                observer.keyAndContainerBeforeLocalIndexDelete(key, deletedRow, container);
            }
            Object cbArg = SortedMap2IndexDeleteOperation.getRowByteSource(deletedValue);
            success = skipListMap.remove(key, (Object)deletedRow, (MapCallback)deleteCb, (Object)container, cbArg, null);
            if (observer != null) {
                observer.keyAndContainerAfterLocalIndexDelete(key, deletedRow, container);
            }
            if (GemFireXDUtils.TraceIndex | GemFireXDUtils.TraceQuery) {
                GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp: %s deleted key=%s with value=(%s) from %s", success ? "successfully" : "unsuccessfully", key, GemFireXDUtils.TraceIndex ? deletedRow : ArrayUtils.objectRefString((Object)deletedRow), container);
            }
        }
        catch (IndexMaintenanceException ime) {
            throw (StandardException)ime.getCause();
        }
        finally {
            deletedRow.unmarkDeleteFromIndexInProgress();
        }
        return success;
    }

    private static Object deleteFromRowLocationArray(Object key, Object deletedRow, Object existingValue) {
        RowLocation[] existingRows = (RowLocation[])existingValue;
        assert (existingRows.length > 1) : existingRows.length;
        int newLength = existingRows.length - 1;
        RowLocation[] newValues = newLength > 1 ? new RowLocation[newLength] : null;
        Object newValue = newValues;
        boolean foundDeleted = false;
        int index = 0;
        for (RowLocation existingRow : existingRows) {
            if (existingRow == deletedRow) {
                if (!foundDeleted) {
                    foundDeleted = true;
                    continue;
                }
                throw new AssertionError((Object)("RowLocation array should not contain same RegionEntry tuple present more than once. Problematic RowLocation is: " + deletedRow + " Matched with: " + existingRow));
            }
            if (newValues != null) {
                if (index == newLength) {
                    return null;
                }
                newValues[index++] = existingRow;
                continue;
            }
            newValue = existingRow;
        }
        if (foundDeleted) {
            return newValue;
        }
        return null;
    }

    private static Object deleteFromHashSet(Object key, Object deletedRow, Object existingValue, GemFireContainer container) {
        ConcurrentTHashSet existingValues = (ConcurrentTHashSet)existingValue;
        if (!existingValues.remove(deletedRow)) {
            return null;
        }
        if (!existingValues.isEmpty()) {
            return existingValues;
        }
        return TOK_INDEX_KEY_DEL;
    }

    public static Object getRowLocationByteSourceForKey(CompactCompositeIndexKey ccKey, RowLocation rl) {
        Object valueBytes = SortedMap2IndexDeleteOperation.getRowLocationByteSource(rl);
        if (valueBytes != null) {
            if (ccKey.equalsValueBytes(valueBytes)) {
                return valueBytes;
            }
            if (valueBytes instanceof OffHeapByteSource) {
                ((OffHeapByteSource)((Object)valueBytes)).release();
            }
        }
        return null;
    }

    public static Object getRowLocationByteSource(RowLocation rl) {
        if (rl.getTXId() != null) {
            return null;
        }
        Object rawValue = rl.getRawValue();
        return SortedMap2IndexDeleteOperation.getRowByteSource(rawValue);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getRowByteSource(Object rawValue) {
        void var1_6;
        if (rawValue == null) return null;
        Class<?> vClass = rawValue.getClass();
        if (vClass == byte[].class) {
            byte[] byArray = (byte[])rawValue;
            return var1_6;
        } else if (vClass == byte[][].class) {
            byte[] byArray = ((byte[][])rawValue)[0];
            return var1_6;
        } else if (vClass == OffHeapRow.class) {
            OffHeapRow obs = (OffHeapRow)((Object)rawValue);
            if (OffHeapRegionEntryHelper.isAddressInvalidOrRemoved((long)obs.getMemoryAddress())) return null;
            Object object = rawValue;
            return var1_6;
        } else if (vClass == OffHeapRowWithLobs.class) {
            OffHeapRowWithLobs obs = (OffHeapRowWithLobs)((Object)rawValue);
            if (OffHeapRegionEntryHelper.isAddressInvalidOrRemoved((long)obs.getMemoryAddress())) return null;
            OffHeapRowWithLobs offHeapRowWithLobs = obs;
            return var1_6;
        } else {
            if (Token.isInvalidOrRemoved((Object)rawValue)) {
                return null;
            }
            if (rawValue instanceof DataValueDescriptor || rawValue instanceof DataValueDescriptor[]) {
                return null;
            }
            Assert.fail((Object)("getRowByteSource: unexpected raw value: " + rawValue + "(class=" + rawValue.getClass() + ")"));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void snapshotKeyBytesOnError(Object key, Object deletedValue) {
        if (key instanceof CompactCompositeIndexKey) {
            CompactCompositeIndexKey ccik = (CompactCompositeIndexKey)key;
            Object indexBytes = ccik.getValueByteSource();
            try {
                if (deletedValue != null && SortedMap2IndexRefreshIndexKeyOperation.bytesSameAsCCIKBytes(deletedValue, indexBytes)) {
                    ccik.snapshotKeyFromValue();
                }
            }
            finally {
                ccik.releaseValueByteSource(indexBytes);
            }
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        RegionEntry entry;
        if (this.row != null && (entry = this.row.getRegionEntry()).isDestroyedOrRemoved()) {
            this.row = Hash1IndexScanController.fetchRowLocation(entry.getKeyCopy(), this.memcontainer.getBaseContainer().getRegion());
        }
        SortedMap2IndexInsertOperation undoOp = new SortedMap2IndexInsertOperation(this.memcontainer, this.key, this.row, this.isUnique);
        return undoOp;
    }

    @Override
    public final boolean shouldBeConflated() {
        return true;
    }

    static class UpdateReplacementValue
    extends MapCallbackAdapter<Object, Object, GemFireContainer, Object> {
        UpdateReplacementValue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object beforeReplace(Object mapKey, Object newValue, GemFireContainer container, Object cbArg) {
            block14: {
                if (mapKey instanceof CompactCompositeIndexKey) {
                    CompactCompositeIndexKey ck = (CompactCompositeIndexKey)mapKey;
                    Object deletedBytes = cbArg;
                    Object vbs = ck.getValueByteSource();
                    try {
                        if ((deletedBytes == null || !SortedMap2IndexRefreshIndexKeyOperation.bytesSameAsCCIKBytes(deletedBytes, vbs)) && (deletedBytes != null || vbs == null)) break block14;
                        if (GemFireXDUtils.TraceIndex) {
                            GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp::beforeReplace byte source being deleted = %s is present in index key", deletedBytes);
                        }
                        Object replacementValue = null;
                        Class<?> valClass = newValue.getClass();
                        if (valClass == RowLocation[].class) {
                            for (RowLocation value : (RowLocation[])newValue) {
                                if (value == null || !value.useRowLocationForIndexKey()) continue;
                                replacementValue = value;
                                break;
                            }
                        } else if (valClass == ConcurrentTHashSet.class) {
                            ConcurrentTHashSet concurrentTHashSet = (ConcurrentTHashSet)newValue;
                            for (Object rl : concurrentTHashSet) {
                                if (rl == null || !((RowLocation)rl).useRowLocationForIndexKey()) continue;
                                replacementValue = rl;
                                break;
                            }
                        } else if (((RowLocation)newValue).useRowLocationForIndexKey()) {
                            replacementValue = newValue;
                        }
                        if (GemFireXDUtils.TraceIndex) {
                            GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp::beforeReplace replacement byte source =%S", replacementValue);
                        }
                        Object object = replacementValue;
                        return object;
                    }
                    finally {
                        ck.releaseValueByteSource(vbs);
                    }
                }
            }
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp::beforeReplace returning token = UPDATE_MAPKEY_SKIPPED_TOKEN", new Object[0]);
            }
            return UPDATE_MAPKEY_SKIPPED_TOKEN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void afterReplace(Object mapKey, Object newValue, Object beforeResult, GemFireContainer container, Object cbArg) {
            block18: {
                Object vBytesToUse = null;
                try {
                    if (beforeResult == UPDATE_MAPKEY_SKIPPED_TOKEN) break block18;
                    CompactCompositeIndexKey ck = (CompactCompositeIndexKey)mapKey;
                    if (beforeResult != null) {
                        RowLocation rlToUse = (RowLocation)beforeResult;
                        try {
                            vBytesToUse = SortedMap2IndexDeleteOperation.getRowLocationByteSourceForKey(ck, rlToUse);
                            if (vBytesToUse != null) {
                                Object deletedBytes = cbArg;
                                if (deletedBytes != null) {
                                    if (ck.update(vBytesToUse, deletedBytes)) {
                                        if (GemFireXDUtils.TraceIndex) {
                                            GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp::afterReplace: replacement of deleted bytes = %s with bytes = %s done", deletedBytes, vBytesToUse);
                                        }
                                    } else if (GemFireXDUtils.TraceIndex) {
                                        GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp::afterReplace: replacement of deleted bytes = %s with bytes = %s not doneas CCIK possibly updated by another thread", deletedBytes, vBytesToUse);
                                    }
                                } else {
                                    if (GemFireXDUtils.TraceIndex) {
                                        GfxdIndexManager.traceIndex("SortedMap2IndexDeleteOp::afterReplace: For some unexpected reason the deleted bytes is null, to prevent index key from containing released bytes, replace it with %s", vBytesToUse);
                                    }
                                    ck.setValueBytes(vBytesToUse);
                                }
                            } else if (ck.snapshotKeyFromValue() == null) {
                                throw new AssertionError((Object)"key bytes cannot be null");
                            }
                            break block18;
                        }
                        finally {
                            rlToUse.endIndexKeyUpdate();
                        }
                    }
                    if (ck.snapshotKeyFromValue() == null) {
                        throw new AssertionError((Object)"key bytes cannot be null");
                    }
                }
                finally {
                    OffHeapHelper.release(vBytesToUse);
                }
            }
        }

        public void onReplaceFailed(Object mapKey, Object newValue, Object beforeResult, GemFireContainer container, Object cbArg) {
            if (beforeResult != null && beforeResult != UPDATE_MAPKEY_SKIPPED_TOKEN) {
                ((RowLocation)beforeResult).endIndexKeyUpdate();
            }
        }
    }
}

