/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.PersistentService;
import com.pivotal.gemfirexd.internal.io.StorageFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public final class GemFireService
implements PersistentService {
    private static final String serviceType = "gemfirexd";
    private String serviceName;

    @Override
    public String getType() {
        return serviceType;
    }

    @Override
    public Enumeration getBootTimeServices() {
        return null;
    }

    @Override
    public Properties getServiceProperties(String serviceName, Properties defaultProperties) throws StandardException {
        Properties service = new Properties(defaultProperties);
        service.setProperty("gemfirexd.serviceProtocol", "com.pivotal.gemfirexd.internal.database.Database");
        service.setProperty("gemfirexd.engineType", Integer.toString(this.getEngineType()));
        service.setProperty("gemfirexd.access", "memstore");
        return service;
    }

    @Override
    public void saveServiceProperties(String serviceName, StorageFactory storageFactory, Properties properties, boolean replace) throws StandardException {
    }

    @Override
    public void saveServiceProperties(String serviceName, Properties properties, boolean replace) throws StandardException {
    }

    @Override
    public String createServiceRoot(String name, boolean deleteExisting) throws StandardException {
        this.serviceName = name;
        return name;
    }

    @Override
    public boolean removeServiceRoot(String serviceName) {
        return true;
    }

    @Override
    public String getCanonicalServiceName(String name) throws StandardException {
        if (serviceType.equals(name) || "sqlfire".equals(name)) {
            return serviceType;
        }
        if ("snappydata".equals(name)) {
            return "snappydata";
        }
        throw StandardException.newException("XJ004.C", name);
    }

    @Override
    public String getUserServiceName(String serviceName) {
        try {
            return this.getCanonicalServiceName(serviceName);
        }
        catch (StandardException e) {
            AssertionError ae = new AssertionError((Object)"unexpected exception");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    @Override
    public boolean isSameService(String serviceName1, String serviceName2) {
        return serviceName1.equals(serviceName2);
    }

    @Override
    public boolean hasStorageFactory() {
        return false;
    }

    @Override
    public StorageFactory getStorageFactoryInstance(boolean useHome, String databaseName, String tempDirName, String uniqueName) throws StandardException, IOException {
        return null;
    }

    private int getEngineType() {
        return 2;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }
}

