/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.catalog.types;

import com.pivotal.gemfirexd.internal.catalog.IndexDescriptor;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class IndexDescriptorImpl
implements IndexDescriptor,
Formatable {
    private boolean isUnique;
    private int[] baseColumnPositions;
    private boolean[] isAscending;
    private int numberOfOrderedColumns;
    private String indexType;
    private boolean isUniqueWithDuplicateNulls;

    public IndexDescriptorImpl(String indexType, boolean isUnique, boolean isUniqueWithDuplicateNulls, int[] baseColumnPositions, boolean[] isAscending, int numberOfOrderedColumns) {
        this.indexType = indexType;
        this.isUnique = isUnique;
        this.isUniqueWithDuplicateNulls = isUniqueWithDuplicateNulls;
        this.baseColumnPositions = baseColumnPositions;
        this.isAscending = isAscending;
        this.numberOfOrderedColumns = numberOfOrderedColumns;
    }

    public IndexDescriptorImpl() {
    }

    @Override
    public boolean isUniqueWithDuplicateNulls() {
        return this.isUniqueWithDuplicateNulls;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique || this.isUniqueWithDuplicateNulls;
    }

    @Override
    public int[] baseColumnPositions() {
        return this.baseColumnPositions;
    }

    @Override
    public Integer getKeyColumnPosition(Integer heapColumnPosition) {
        return this.getKeyColumnPosition((int)heapColumnPosition);
    }

    @Override
    public int getKeyColumnPosition(int heapColumnPosition) {
        int keyPosition = 0;
        for (int index = 0; index < this.baseColumnPositions.length; ++index) {
            if (this.baseColumnPositions[index] != heapColumnPosition) continue;
            keyPosition = index + 1;
            break;
        }
        return keyPosition;
    }

    @Override
    public int numberOfOrderedColumns() {
        return this.numberOfOrderedColumns;
    }

    @Override
    public String indexType() {
        return this.indexType;
    }

    @Override
    public boolean isAscending(Integer keyColumnPosition) {
        int i = keyColumnPosition - 1;
        if (i < 0 || i >= this.baseColumnPositions.length) {
            return false;
        }
        return this.isAscending[i];
    }

    @Override
    public boolean isDescending(Integer keyColumnPosition) {
        int i = keyColumnPosition - 1;
        if (i < 0 || i >= this.baseColumnPositions.length) {
            return false;
        }
        return !this.isAscending[i];
    }

    @Override
    public boolean[] isAscending() {
        return this.isAscending;
    }

    @Override
    public void setBaseColumnPositions(int[] baseColumnPositions) {
        this.baseColumnPositions = baseColumnPositions;
    }

    @Override
    public void setIsAscending(boolean[] isAscending) {
        this.isAscending = isAscending;
    }

    @Override
    public void setNumberOfOrderedColumns(int numberOfOrderedColumns) {
        this.numberOfOrderedColumns = numberOfOrderedColumns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        if (this.isUnique) {
            sb.append("UNIQUE ");
        } else if (this.isUniqueWithDuplicateNulls) {
            sb.append("UNIQUE WITH DUPLICATE NULLS");
        }
        sb.append(this.indexType);
        sb.append(" (");
        for (int i = 0; i < this.baseColumnPositions.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.baseColumnPositions[i]);
            if (this.isAscending[i]) continue;
            sb.append(" DESC");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.isUnique = fh.getBoolean("isUnique");
        int bcpLength = fh.getInt("keyLength");
        this.baseColumnPositions = new int[bcpLength];
        this.isAscending = new boolean[bcpLength];
        for (int i = 0; i < bcpLength; ++i) {
            this.baseColumnPositions[i] = fh.getInt("bcp" + i);
            this.isAscending[i] = fh.getBoolean("isAsc" + i);
        }
        this.numberOfOrderedColumns = fh.getInt("orderedColumns");
        this.indexType = (String)fh.get("indexType");
        this.isUniqueWithDuplicateNulls = fh.containsKey("isUniqueWithDuplicateNulls") ? fh.getBoolean("isUniqueWithDuplicateNulls") : false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FormatableHashtable fh = new FormatableHashtable();
        fh.putBoolean("isUnique", this.isUnique);
        fh.putInt("keyLength", this.baseColumnPositions.length);
        for (int i = 0; i < this.baseColumnPositions.length; ++i) {
            fh.putInt("bcp" + i, this.baseColumnPositions[i]);
            fh.putBoolean("isAsc" + i, this.isAscending[i]);
        }
        fh.putInt("orderedColumns", this.numberOfOrderedColumns);
        fh.put("indexType", this.indexType);
        fh.putBoolean("isUniqueWithDuplicateNulls", this.isUniqueWithDuplicateNulls);
        out.writeObject(fh);
    }

    @Override
    public int getTypeFormatId() {
        return 387;
    }

    public boolean equals(Object other) {
        boolean retval = false;
        if (other instanceof IndexDescriptorImpl) {
            IndexDescriptorImpl id = (IndexDescriptorImpl)other;
            if (id.isUnique == this.isUnique && id.isUniqueWithDuplicateNulls == this.isUniqueWithDuplicateNulls && id.baseColumnPositions.length == this.baseColumnPositions.length && id.numberOfOrderedColumns == this.numberOfOrderedColumns && id.indexType.equals(this.indexType)) {
                retval = true;
                for (int i = 0; i < this.baseColumnPositions.length; ++i) {
                    if (id.baseColumnPositions[i] == this.baseColumnPositions[i] && id.isAscending[i] == this.isAscending[i]) continue;
                    retval = false;
                    break;
                }
            }
        }
        return retval;
    }

    public int hashCode() {
        int retval = this.isUnique ? 1 : 2;
        retval *= this.numberOfOrderedColumns;
        for (int i = 0; i < this.baseColumnPositions.length; ++i) {
            retval *= this.baseColumnPositions[i];
        }
        return retval *= this.indexType.hashCode();
    }
}

