/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapred;

import com.pivotal.gemfirexd.hadoop.mapreduce.Key;
import com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce.OutputFormatUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="IO format classes in hadoop world seem to follow this convention for new and old MR apis.")
public class RowOutputFormat<VALUE>
extends com.pivotal.gemfirexd.hadoop.mapreduce.RowOutputFormat<VALUE>
implements OutputFormat<Key, VALUE> {
    public static final String OUTPUT_TABLE = "gfxd.output.tablename";
    public static final String OUTPUT_URL = "gfxd.output.dburl";
    public static final String OUTPUT_BATCH_SIZE = "gfxd.output.batchsize";
    private OutputFormatUtil util = new OutputFormatUtil();
    private final Logger logger = LoggerFactory.getLogger(RowOutputFormat.class);

    public void checkOutputSpecs(FileSystem fs, JobConf job) throws IOException {
        RowOutputFormat.validateConfiguration((Configuration)job);
    }

    public RecordWriter<Key, VALUE> getRecordWriter(FileSystem fs, JobConf job, String name, Progressable progress) throws IOException {
        return new MapRedGfxdRecordWriter((Configuration)job);
    }

    public class MapRedGfxdRecordWriter
    implements RecordWriter<Key, VALUE> {
        private final OutputFormatUtil.RowCommandBatchExecutor batchExecutor;
        List<Method> columnSetters = new ArrayList<Method>();
        private String tableName;

        public MapRedGfxdRecordWriter(Configuration conf) throws IOException {
            this.tableName = conf.get(RowOutputFormat.OUTPUT_TABLE);
            try {
                OutputFormatUtil outputFormatUtil = RowOutputFormat.this.util;
                outputFormatUtil.getClass();
                this.batchExecutor = outputFormatUtil.new OutputFormatUtil.RowCommandBatchExecutor(RowOutputFormat.getDriver(conf), conf.get(RowOutputFormat.OUTPUT_URL), conf.getInt(RowOutputFormat.OUTPUT_BATCH_SIZE, 10000));
            }
            catch (ClassNotFoundException e) {
                RowOutputFormat.this.logger.error("Gemfirexd client classes are missing from the classpath", (Throwable)e);
                throw new InvalidJobConfException((Throwable)e);
            }
        }

        public void write(Key key, VALUE value) throws IOException {
            try {
                if (this.batchExecutor.isNotInitialized()) {
                    this.columnSetters = RowOutputFormat.this.util.spotTableColumnSetters(value);
                    String query = RowOutputFormat.this.util.createQuery(this.tableName, this.columnSetters);
                    RowOutputFormat.this.logger.debug("Query to be executed by record writer is: " + query);
                    this.batchExecutor.initStatement(query);
                }
                this.batchExecutor.executeWriteStatement(value, this.columnSetters);
            }
            catch (SQLException e) {
                RowOutputFormat.this.logger.error("Failed to upload data into Gemfirexd", (Throwable)e);
                throw new IOException(e);
            }
        }

        public void close(Reporter reporter) throws IOException {
            this.batchExecutor.close();
        }
    }
}

