/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapred;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HDFSSplitIterator;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowRecordReader;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class MapRedRowRecordReader
extends RowRecordReader
implements RecordReader<Key, Row> {
    Row row;

    void initialize(InputSplit split, Configuration job) throws IOException {
        Path[] path = this.getSplitPaths(split);
        long[] start = this.getStartOffsets(split);
        long[] len = this.getLengths(split);
        FileSystem fs = this.getSplitPaths(split)[0].getFileSystem(job);
        long startTS = job.getLong("gfxd.input.starttimemillis", 0L);
        long endTS = job.getLong("gfxd.input.endtimemillis", 0L);
        this.splitIterator = HDFSSplitIterator.newInstance((FileSystem)fs, (Path[])path, (long[])start, (long[])len, (long)startTS, (long)endTS);
        this.instantiateGfxdLoner(job);
    }

    protected Path[] getSplitPaths(InputSplit split) {
        CombineFileSplit combineSplit = (CombineFileSplit)split;
        return combineSplit.getPaths();
    }

    protected long[] getStartOffsets(InputSplit split) {
        CombineFileSplit combineSplit = (CombineFileSplit)split;
        return combineSplit.getStartOffsets();
    }

    protected long[] getLengths(InputSplit split) {
        CombineFileSplit combineSplit = (CombineFileSplit)split;
        return combineSplit.getLengths();
    }

    public final Key createKey() {
        return new Key();
    }

    public final Row createValue() {
        this.row = new Row(this.rs);
        return this.row;
    }

    public final boolean next(Key key, Row value) throws IOException {
        if (this.nextRow()) {
            key.setKey(super.getRowKeyBytes());
            return true;
        }
        key.setKey(null);
        return false;
    }

    public long getPos() throws IOException {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public float getProgress() throws IOException {
        return super.getResultSetProgress();
    }
}

