/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.snappy;

import com.gemstone.gemfire.internal.ClassPathLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ComplexTypeSerializer {
    private static final Constructor<?> implConstructor;

    protected ComplexTypeSerializer() {
    }

    public static ComplexTypeSerializer create(String tableName, String columnName, Connection connection) {
        if (implConstructor != null) {
            try {
                return (ComplexTypeSerializer)implConstructor.newInstance(tableName, columnName, connection);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                throw new IllegalArgumentException(cause.getMessage(), cause);
            }
        }
        throw new UnsupportedOperationException("complex types are supported only with the SnappyData product.");
    }

    public byte[] serialize(Object v) {
        return this.serialize(v, false);
    }

    public abstract byte[] serialize(Object var1, boolean var2);

    public Object deserialize(byte[] bytes) {
        return this.deserialize(bytes, 0, bytes.length);
    }

    public abstract Object deserialize(byte[] var1, int var2, int var3);

    public Object deserialize(Blob blob) throws SQLException {
        int length = (int)blob.length();
        byte[] bytes = blob.getBytes(1L, length);
        return this.deserialize(bytes, 0, length);
    }

    static {
        Constructor cons;
        try {
            Class implClass = ClassPathLoader.getLatest().forName("io.snappydata.impl.ComplexTypeSerializerImpl");
            cons = implClass.getConstructor(String.class, String.class, Connection.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            cons = null;
        }
        implConstructor = cons;
    }
}

