/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.xact;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerLock;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RowLock;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.NoLocking;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.RowLockingRR;

public class RowLocking2
extends RowLockingRR {
    private static final LockingPolicy NO_LOCK = new NoLocking();

    protected RowLocking2(LockFactory lf) {
        super(lf);
    }

    @Override
    public boolean lockContainer(Transaction t, ContainerHandle container, boolean waitForLock, boolean forUpdate) throws StandardException {
        ContainerLock qualifier = forUpdate ? ContainerLock.CIX : ContainerLock.CIS;
        Object group = forUpdate ? t : container.getUniqueId();
        boolean gotLock = this.lf.lockObject(t.getCompatibilitySpace(), group, container.getId(), qualifier, waitForLock ? -2 : 0);
        if (gotLock) {
            if (this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), ContainerLock.CX)) {
                this.lf.unlockGroup(t.getCompatibilitySpace(), container.getUniqueId());
                container.setLockingPolicy(NO_LOCK);
            } else if (!forUpdate && this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), ContainerLock.CS)) {
                this.lf.transfer(t.getCompatibilitySpace(), group, t);
                container.setLockingPolicy(NO_LOCK);
            }
        }
        return gotLock;
    }

    @Override
    public boolean lockRecordForRead(Transaction t, ContainerHandle container_handle, RecordHandle record, boolean waitForLock, boolean forUpdate) throws StandardException {
        RowLock qualifier = forUpdate ? RowLock.RU2 : RowLock.RS2;
        return this.lf.lockObject(t.getCompatibilitySpace(), container_handle.getUniqueId(), record, qualifier, waitForLock ? -2 : 0);
    }

    @Override
    public void unlockRecordAfterRead(Transaction t, ContainerHandle container_handle, RecordHandle record, boolean forUpdate, boolean row_qualified) throws StandardException {
        RowLock qualifier = forUpdate ? RowLock.RU2 : RowLock.RS2;
        int count = this.lf.unlock(t.getCompatibilitySpace(), container_handle.getUniqueId(), record, qualifier);
        if (count != 1 && count != 0) {
            SanityManager.THROWASSERT((String)("count = " + count + "record.getContainerId() = " + record.getContainerId()));
        }
    }

    @Override
    public void unlockContainer(Transaction t, ContainerHandle container_handle) {
        this.lf.unlockGroup(t.getCompatibilitySpace(), container_handle.getUniqueId());
    }
}

