/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class RemoveFile
implements Serviceable,
PrivilegedExceptionAction {
    private final StorageFile fileToGo;

    RemoveFile(StorageFile fileToGo) {
        this.fileToGo = fileToGo;
    }

    @Override
    public int performWork(ContextManager context) throws StandardException {
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException e) {
            throw (StandardException)e.getException();
        }
        return 1;
    }

    @Override
    public boolean serviceASAP() {
        return false;
    }

    @Override
    public boolean serviceImmediately() {
        return true;
    }

    public Object run() throws StandardException {
        if (this.fileToGo.exists() && !this.fileToGo.delete()) {
            throw StandardException.newException("XSDF4.S", this.fileToGo);
        }
        return null;
    }
}

