/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.Serviceable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageTimeStamp;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.DataFactory;

public final class ReclaimSpace
implements Serviceable {
    private boolean serviceASAP;
    private ContainerKey containerId;
    private PageKey pageId;
    private RecordHandle headRowHandle;
    private int columnId;
    private long columnPageId;
    private int columnRecordId;
    private PageTimeStamp timeStamp;
    private int attempts;
    private DataFactory processor;
    private int reclaim;
    public static final int CONTAINER = 1;
    public static final int PAGE = 2;
    public static final int ROW_RESERVE = 3;
    public static final int COLUMN_CHAIN = 4;

    private void initContainerInfo(ContainerKey containerId, int reclaim, DataFactory processor, boolean serviceASAP) {
        this.containerId = containerId;
        this.reclaim = reclaim;
        this.attempts = 0;
        this.processor = processor;
        this.serviceASAP = serviceASAP;
    }

    public ReclaimSpace(int reclaim, ContainerKey containerId, DataFactory processor, boolean serviceASAP) {
        SanityManager.ASSERT((reclaim == 1 ? 1 : 0) != 0);
        this.initContainerInfo(containerId, reclaim, processor, serviceASAP);
    }

    public ReclaimSpace(int reclaim, PageKey pageId, DataFactory processor, boolean serviceASAP) {
        SanityManager.ASSERT((reclaim == 2 ? 1 : 0) != 0);
        this.initContainerInfo(pageId.getContainerId(), reclaim, processor, serviceASAP);
        this.pageId = pageId;
    }

    public ReclaimSpace(int reclaim, RecordHandle headRowHandle, DataFactory processor, boolean serviceASAP) {
        SanityManager.ASSERT((reclaim == 3 ? 1 : 0) != 0);
        this.initContainerInfo(headRowHandle.getContainerId(), reclaim, processor, serviceASAP);
        this.headRowHandle = headRowHandle;
    }

    public ReclaimSpace(int reclaim, RecordHandle headRowHandle, int columnId, long ovPageId, int ovRecordId, PageTimeStamp timeStamp, DataFactory processor, boolean serviceASAP) {
        SanityManager.ASSERT((reclaim == 4 ? 1 : 0) != 0);
        this.initContainerInfo(headRowHandle.getContainerId(), reclaim, processor, serviceASAP);
        this.headRowHandle = headRowHandle;
        this.columnId = columnId;
        this.columnPageId = ovPageId;
        this.columnRecordId = ovRecordId;
        this.timeStamp = timeStamp;
    }

    @Override
    public boolean serviceASAP() {
        return this.serviceASAP;
    }

    @Override
    public int performWork(ContextManager context) throws StandardException {
        SanityManager.ASSERT((context != null ? 1 : 0) != 0, (String)"context is null");
        SanityManager.ASSERT((this.processor != null ? 1 : 0) != 0, (String)"processor is null");
        return this.processor.reclaimSpace(this, context);
    }

    @Override
    public boolean serviceImmediately() {
        return true;
    }

    public final ContainerKey getContainerId() {
        return this.containerId;
    }

    public final PageKey getPageId() {
        return this.pageId;
    }

    public final RecordHandle getHeadRowHandle() {
        return this.headRowHandle;
    }

    public final int getColumnId() {
        return this.columnId;
    }

    public final long getColumnPageId() {
        return this.columnPageId;
    }

    public final int getColumnRecordId() {
        return this.columnRecordId;
    }

    public final PageTimeStamp getPageTimeStamp() {
        return this.timeStamp;
    }

    public final int reclaimWhat() {
        return this.reclaim;
    }

    public final int incrAttempts() {
        return ++this.attempts;
    }

    public String toString() {
        if (this.reclaim == 1) {
            return "Reclaim CONTAINER (" + this.containerId + ")";
        }
        if (this.reclaim == 2) {
            return "Reclaim PAGE (" + this.pageId + ") head row at " + this.headRowHandle;
        }
        if (this.reclaim == 3) {
            return "Reclaim ROW_RESERVE (" + this.pageId + ")." + this.headRowHandle + ")";
        }
        if (this.reclaim == 4) {
            return "Reclaim COLUMN_CHAIN (" + this.pageId + ").(" + this.headRowHandle + "," + this.columnId + ") at (" + this.columnPageId + "," + this.columnRecordId + ")";
        }
        return null;
    }
}

