/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Undoable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.LogicalPageOperation;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.PageBasicOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LogicalUndoOperation
extends PageBasicOperation
implements Compensation {
    protected int recordId;
    private transient LogicalPageOperation undoOp = null;

    protected LogicalUndoOperation(BasePage page) {
        super(page);
    }

    public LogicalUndoOperation(BasePage page, int recordId, LogicalPageOperation op) {
        super(page);
        this.undoOp = op;
        this.recordId = recordId;
    }

    public LogicalUndoOperation() {
    }

    @Override
    public int getTypeFormatId() {
        return 104;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.recordId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.recordId = CompressedNumber.readInt(in);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) {
        SanityManager.THROWASSERT((String)"cannot call restore me on PhysicalUndoOperation");
    }

    @Override
    public void setUndoOp(Undoable op) {
        SanityManager.ASSERT((boolean)(op instanceof LogicalPageOperation));
        this.undoOp = (LogicalPageOperation)op;
    }

    @Override
    public final void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        long oldversion = 0L;
        LogInstant oldLogInstant = null;
        oldLogInstant = this.page.getLastLogInstant();
        oldversion = this.page.getPageVersion();
        SanityManager.ASSERT((oldversion == this.getPageVersion() ? 1 : 0) != 0);
        SanityManager.ASSERT((oldLogInstant == null || instant == null || oldLogInstant.lessThan(instant) ? 1 : 0) != 0);
        this.undoOp.undoMe(xact, this.page, this.recordId, instant, in);
        SanityManager.ASSERT((oldversion < this.page.getPageVersion() ? 1 : 0) != 0);
        SanityManager.ASSERT((instant == null || instant.equals(this.page.getLastLogInstant()) ? 1 : 0) != 0);
        this.releaseResource(xact);
    }

    @Override
    public void releaseResource(Transaction xact) {
        if (this.undoOp != null) {
            this.undoOp.releaseResource(xact);
        }
        super.releaseResource(xact);
    }

    @Override
    public int group() {
        return super.group() | 4 | 0x100;
    }

    @Override
    public final ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public String toString() {
        String str = "CLR : (logical undo) " + super.toString() + " undoRecordId = " + this.recordId;
        str = this.undoOp != null ? str + "\n" + this.undoOp.toString() : str + " undo Operation not set";
        return str;
    }
}

