/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.gemstone.gnu.trove.TIntArrayList;
import com.gemstone.gnu.trove.TLongArrayList;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.MergeSort;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.MergeSortInfo;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.SortBuffer;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

final class MergeInserter
implements SortController {
    private MergeSort sort;
    private TransactionManager tran;
    private TLongArrayList mergeRuns;
    private SortBuffer sortBuffer;
    private long beginFreeMemory;
    private long beginTotalMemory;
    private long estimatedMemoryUsed;
    private boolean avoidMergeRun;
    private int runSize;
    private int totalRunSize;
    String stat_sortType;
    int stat_numRowsInput;
    int stat_numRowsOutput;
    int stat_numMergeRuns;
    TIntArrayList stat_mergeRunsSize;
    final GfxdHeapThresholdListener thresholdListener = Misc.getMemStore().thresholdListener();

    MergeInserter() {
    }

    @Override
    public boolean insert(ExecRow row) throws StandardException {
        SanityManager.ASSERT((this.sort != null ? 1 : 0) != 0);
        this.sort.checkColumnTypes(row);
        int insertResult = this.sortBuffer.insert(row);
        ++this.stat_numRowsInput;
        if (insertResult != 1) {
            ++this.stat_numRowsOutput;
        }
        if (insertResult == 2) {
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null) {
                this.avoidMergeRun = observer.avoidMergeRuns();
            }
            if (this.thresholdListener.isEviction() || this.thresholdListener.isCritical()) {
                this.avoidMergeRun = false;
            }
            if (this.avoidMergeRun) {
                Runtime jvm = Runtime.getRuntime();
                long currentFreeMemory = jvm.freeMemory();
                long currentTotalMemory = jvm.totalMemory();
                this.estimatedMemoryUsed = currentTotalMemory - currentFreeMemory - (this.beginTotalMemory - this.beginFreeMemory);
                if (GemFireXDUtils.TraceSortTuning) {
                    SanityManager.DEBUG_PRINT((String)"SortTuning", (String)("Growing sortBuffer dynamically, current sortBuffer capacity= " + this.sortBuffer.capacity() + " estimatedMemoryUsed = " + this.estimatedMemoryUsed + " currentTotalMemory = " + currentTotalMemory + " currentFreeMemory = " + currentFreeMemory + " numcolumn = " + row.nColumns() + " real per row memory = " + this.estimatedMemoryUsed / (long)this.sortBuffer.capacity()));
                }
                if (this.thresholdListener.isEvictionDisabled() && this.estimatedMemoryUsed > 0L && 2L * this.estimatedMemoryUsed >= (this.estimatedMemoryUsed + currentFreeMemory) / 2L && (2L * this.estimatedMemoryUsed >= 0x100000L || currentTotalMemory >= 0x500000L)) {
                    this.avoidMergeRun = false;
                } else {
                    boolean tryInsert = false;
                    if (this.sortBuffer.capacity() < 0x3FFFFFFE) {
                        tryInsert = true;
                        this.sortBuffer.grow(100);
                    }
                    if (tryInsert && this.sortBuffer.insert(row) != 2) {
                        return true;
                    }
                    this.avoidMergeRun = false;
                }
            }
            this.stat_sortType = "external";
            long conglomid = this.sort.createMergeRun(this.tran, this.sortBuffer);
            if (this.mergeRuns == null) {
                this.mergeRuns = new TLongArrayList();
            }
            this.mergeRuns.add(conglomid);
            ++this.stat_numMergeRuns;
            this.runSize = this.stat_numRowsInput - this.totalRunSize - 1;
            this.totalRunSize += this.runSize;
            this.stat_mergeRunsSize.add(this.runSize);
            this.sortBuffer.insert(row);
            return true;
        }
        return insertResult != 1;
    }

    @Override
    public void completedInserts() {
        if (this.sort != null) {
            this.sort.doneInserting(this, this.sortBuffer, this.mergeRuns);
        }
        if (this.stat_sortType == "external") {
            ++this.stat_numMergeRuns;
            this.stat_mergeRunsSize.add(this.stat_numRowsInput - this.totalRunSize);
        }
        this.tran.closeMe(this);
        this.sort = null;
        this.tran = null;
        this.mergeRuns = null;
        this.sortBuffer = null;
    }

    @Override
    public long estimateMemoryUsage(ExecRow sortResultRow) throws StandardException {
        return (long)this.stat_numRowsOutput * (sortResultRow != null ? sortResultRow.estimateRowSize() : 1L);
    }

    @Override
    public SortInfo getSortInfo() throws StandardException {
        return new MergeSortInfo(this);
    }

    @SuppressWarnings(value={"DM_GC"})
    boolean initialize(MergeSort sort, TransactionManager tran) {
        Runtime jvm = Runtime.getRuntime();
        if (GemFireXDUtils.TraceSortTuning) {
            jvm.gc();
            jvm.gc();
            jvm.gc();
        }
        this.beginFreeMemory = jvm.freeMemory();
        this.beginTotalMemory = jvm.totalMemory();
        this.estimatedMemoryUsed = 0L;
        this.avoidMergeRun = true;
        this.stat_sortType = "internal";
        this.stat_numMergeRuns = 0;
        this.stat_numRowsInput = 0;
        this.stat_numRowsOutput = 0;
        this.stat_mergeRunsSize = new TIntArrayList();
        this.runSize = 0;
        this.totalRunSize = 0;
        if (SanityManager.DEBUG_ON((String)"testSort")) {
            this.avoidMergeRun = false;
        }
        this.sort = sort;
        this.tran = tran;
        this.sortBuffer = new SortBuffer(sort);
        return this.sortBuffer.init();
    }
}

