/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute.rts;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RunTimeStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.ResultSetStatistics;
import java.sql.Timestamp;
import java.util.Vector;

public final class RunTimeStatisticsImpl
implements RunTimeStatistics {
    public String statementText;
    public String statementName;
    public String spsName;
    public long parseTime;
    public long bindTime;
    public long optimizeTime;
    public long generateTime;
    public long compileTime;
    public long executeTime;
    public Timestamp beginCompilationTimestamp;
    public Timestamp endCompilationTimestamp;
    public Timestamp beginExecutionTimestamp;
    public Timestamp endExecutionTimestamp;
    public ResultSetStatistics topResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RunTimeStatisticsImpl(String spsName, String statementName, String statementText, long compileTime, long parseTime, long bindTime, long optimizeTime, long generateTime, long executeTime, Timestamp beginCompilationTimestamp, Timestamp endCompilationTimestamp, Timestamp beginExecutionTimestamp, Timestamp endExecutionTimestamp, ResultSetStatistics[] subqueryTrackingArray, ResultSetStatistics topResultSetStatistics) {
        this.spsName = spsName;
        this.statementName = statementName;
        this.statementText = statementText;
        this.compileTime = compileTime;
        this.parseTime = parseTime;
        this.bindTime = bindTime;
        this.optimizeTime = optimizeTime;
        this.generateTime = generateTime;
        this.executeTime = executeTime;
        this.beginCompilationTimestamp = beginCompilationTimestamp;
        this.endCompilationTimestamp = endCompilationTimestamp;
        this.beginExecutionTimestamp = beginExecutionTimestamp;
        this.endExecutionTimestamp = endExecutionTimestamp;
        this.subqueryTrackingArray = subqueryTrackingArray;
        this.topResultSetStatistics = topResultSetStatistics;
    }

    @Override
    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    @Override
    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    @Override
    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    @Override
    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    @Override
    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    @Override
    public long getExecuteTimeInMillis() {
        return this.executeTime;
    }

    @Override
    public Timestamp getBeginCompilationTimestamp() {
        return this.beginCompilationTimestamp;
    }

    @Override
    public Timestamp getEndCompilationTimestamp() {
        return this.endCompilationTimestamp;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        return this.beginExecutionTimestamp;
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        return this.endExecutionTimestamp;
    }

    @Override
    public String getStatementName() {
        return this.statementName;
    }

    @Override
    public String getSPSName() {
        return this.spsName;
    }

    @Override
    public String getStatementText() {
        return this.statementText;
    }

    @Override
    public double getEstimatedRowCount() {
        if (this.topResultSetStatistics == null) {
            return 0.0;
        }
        return this.topResultSetStatistics.getEstimatedRowCount();
    }

    @Override
    public String getStatementExecutionPlanText() {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String subqueryInfo = "";
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    subqueryInfo = MessageService.getTextMessage("43Y21.U") + ":\n";
                    foundAttached = true;
                }
                subqueryInfo = subqueryInfo + this.subqueryTrackingArray[index].getStatementExecutionPlanText(1);
            }
        }
        return subqueryInfo + this.topResultSetStatistics.getStatementExecutionPlanText(0);
    }

    @Override
    public String getScanStatisticsText() {
        return this.topResultSetStatistics == null ? (String)null : this.topResultSetStatistics.getScanStatisticsText(null, 0);
    }

    @Override
    public String getScanStatisticsText(String tableName) {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String s = this.topResultSetStatistics.getScanStatisticsText(tableName, 0);
        return s.equals("") ? null : s;
    }

    public String toString() {
        String spstext = this.spsName != null ? "Stored Prepared Statement Name: \n\t" + this.spsName + "\n" : "";
        return spstext + MessageService.getTextMessage("43Y22.U") + ": \n\t" + this.statementName + "\n" + MessageService.getTextMessage("43Y23.U") + ": \n\t" + this.statementText + "\n" + MessageService.getTextMessage("43Y24.U") + ": " + this.parseTime + "\n" + MessageService.getTextMessage("43Y25.U") + ": " + this.bindTime + "\n" + MessageService.getTextMessage("43Y26.U") + ": " + this.optimizeTime + "\n" + MessageService.getTextMessage("43Y27.U") + ": " + this.generateTime + "\n" + MessageService.getTextMessage("43Y28.U") + ": " + this.compileTime + "\n" + MessageService.getTextMessage("43Y29.U") + ": " + this.executeTime + "\n" + MessageService.getTextMessage("43Y30.U") + " : " + this.beginCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y31.U") + " : " + this.endCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y32.U") + " : " + this.beginExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y33.U") + " : " + this.endExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y44.U") + ": \n" + this.getStatementExecutionPlanText();
    }

    public Vector getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.topResultSetStatistics);
        return children;
    }
}

