/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class ValueRow
implements ExecRow {
    private DataValueDescriptor[] column;
    private final int ncols;
    private TreeSet<RegionAndKey> setOfKeys;

    public ValueRow(int ncols) {
        this.column = new DataValueDescriptor[ncols];
        this.ncols = ncols;
    }

    @Override
    public final int nColumns() {
        return this.ncols;
    }

    @Override
    public void getNewObjectArray() {
        this.column = new DataValueDescriptor[this.ncols];
    }

    @Override
    public final DataValueDescriptor getColumn(int position) {
        if (position <= this.column.length) {
            return this.column[position - 1];
        }
        return null;
    }

    @Override
    public final void setColumn(int position, DataValueDescriptor col) {
        if (position > this.column.length) {
            this.realloc(position);
        }
        this.column[position - 1] = col;
    }

    public ValueRow(DataValueDescriptor[] row) {
        this.column = row;
        this.ncols = row.length;
    }

    @Override
    public final void setColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        int i;
        int n = i = columns == null ? 0 : columns.anySetBit();
        while (i != -1 && i < values.length) {
            this.setColumn(i + 1, values[i]);
            i = columns == null ? i + 1 : columns.anySetBit(i);
        }
    }

    @Override
    public final void setColumns(FormatableBitSet columns, ExecRow srcRow) throws StandardException {
        if (columns == null) {
            for (int i = 0; i < this.ncols; ++i) {
                if (this.column[i] != null) {
                    this.column[i].setValue(srcRow.getColumn(i + 1));
                    continue;
                }
                this.column[i] = srcRow.getColumn(i + 1);
            }
            return;
        }
        int i = columns.anySetBit();
        while (i != -1 && i < this.ncols) {
            if (this.column[i] != null) {
                this.column[i].setValue(srcRow.getColumn(i + 1));
            } else {
                this.column[i] = srcRow.getColumn(i + 1);
            }
            i = columns.anySetBit(i);
        }
    }

    @Override
    public final void setCompactColumns(FormatableBitSet columns, ExecRow srcRow, int[] baseColumnMap, boolean copyColumns) throws StandardException {
        block6: {
            int nSrcCols;
            block5: {
                nSrcCols = srcRow.nColumns();
                if (columns == null) break block5;
                int i = columns.anySetBit();
                for (int pos = 0; i != -1 && i < nSrcCols && pos < this.ncols; ++pos) {
                    if (copyColumns) {
                        this.column[pos] = srcRow.getColumn(i + 1);
                    }
                    if (baseColumnMap != null) {
                        baseColumnMap[pos] = i;
                    }
                    i = columns.anySetBit(i);
                }
                break block6;
            }
            if (!copyColumns) break block6;
            if (this.ncols < nSrcCols) {
                nSrcCols = this.ncols;
            }
            for (int i = 0; i < nSrcCols; ++i) {
                this.column[i] = srcRow.getColumn(i + 1);
            }
        }
    }

    @Override
    public final void setColumns(int[] columns, boolean zeroBased, ExecRow srcRow) throws StandardException {
        if (columns == null) {
            for (int i = 0; i < this.ncols; ++i) {
                if (this.column[i] != null) {
                    this.column[i].setValue(srcRow.getColumn(i + 1));
                    continue;
                }
                this.column[i] = srcRow.getColumn(i + 1);
            }
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            int col = columns[i];
            if (zeroBased) {
                ++col;
            }
            this.column[i] = srcRow.getColumn(col);
        }
    }

    @Override
    public final void setColumns(int nCols, ExecRow srcRow) throws StandardException {
        for (int i = 0; i < nCols; ++i) {
            if (this.column[i] != null) {
                this.column[i].setValue(srcRow.getColumn(i + 1));
                continue;
            }
            this.column[i] = srcRow.getColumn(i + 1);
        }
    }

    @Override
    public ExecRow getClone() {
        return this.getClone(null);
    }

    public ExecRow getClone(boolean increaseUseCount) {
        return this.getClone(null);
    }

    @Override
    public ExecRow getClone(FormatableBitSet clonedCols) {
        int numColumns = this.column.length;
        ValueRow rowClone = this.cloneMe();
        for (int colCtr = 0; colCtr < numColumns; ++colCtr) {
            if (clonedCols != null && !clonedCols.get(colCtr + 1)) {
                rowClone.setColumn(colCtr + 1, this.column[colCtr]);
                continue;
            }
            if (this.column[colCtr] == null) continue;
            rowClone.setColumn(colCtr + 1, this.column[colCtr].getClone());
        }
        return rowClone;
    }

    @Override
    public ExecRow getNewNullRow() {
        int numColumns = this.column.length;
        ValueRow rowClone = this.cloneMe();
        for (int colCtr = 0; colCtr < numColumns; ++colCtr) {
            if (this.column[colCtr] == null) continue;
            if (this.column[colCtr] instanceof RowLocation) {
                rowClone.setColumn(colCtr + 1, this.column[colCtr].getClone());
                continue;
            }
            rowClone.setColumn(colCtr + 1, this.column[colCtr].getNewNull());
        }
        return rowClone;
    }

    ValueRow cloneMe() {
        return new ValueRow(this.ncols);
    }

    @Override
    public final void resetRowArray() {
        for (int i = 0; i < this.column.length; ++i) {
            if (this.column[i] == null) continue;
            this.column[i] = this.column[i].recycle();
        }
        if (this.setOfKeys != null) {
            this.setOfKeys.clear();
        }
    }

    @Override
    public final DataValueDescriptor cloneColumn(int columnPosition) {
        return this.column[columnPosition - 1].getClone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        for (int index = 0; index < this.column.length; ++index) {
            DataValueDescriptor dvd;
            if (index != 0) {
                sb.append(", ");
            }
            if ((dvd = this.column[index]) != null) {
                if (RowFormatter.isLob(dvd.getTypeFormatId())) {
                    try {
                        sb.append('(').append(dvd.getTypeName()).append(";length=").append(dvd.getLength()).append(";hashCode=0x").append(Integer.toHexString(dvd.hashCode())).append(')');
                        continue;
                    }
                    catch (StandardException se) {
                        throw GemFireXDRuntimeException.newRuntimeException("unexpected exception in ValueRow.toString", se);
                    }
                }
                sb.append(dvd.toString());
                continue;
            }
            sb.append("(NULL)");
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public final DataValueDescriptor[] getRowArray() {
        return this.column;
    }

    @Override
    public final DataValueDescriptor[] getRowArrayClone() {
        int numColumns = this.column.length;
        DataValueDescriptor[] columnClones = new DataValueDescriptor[numColumns];
        for (int colCtr = 0; colCtr < numColumns; ++colCtr) {
            if (this.column[colCtr] == null) continue;
            columnClones[colCtr] = this.column[colCtr].getClone();
        }
        return columnClones;
    }

    @Override
    public final void setRowArray(DataValueDescriptor[] value) {
        this.column = value;
    }

    @Override
    public final void setRowArray(ExecRow otherRow) {
        this.setRowArray(otherRow.getRowArray());
    }

    @Override
    public final ExecRow getShallowClone() {
        ValueRow clone = this.cloneMe();
        clone.setRowArray(this.column);
        return clone;
    }

    @Override
    public final Object getRawRowValue(boolean doClone) {
        if (doClone) {
            return this.getRowArrayClone();
        }
        return this.column;
    }

    @Override
    public final void setRowArrayClone(ExecRow otherRow, TreeSet<RegionAndKey> allKeys) {
        this.column = otherRow.getRowArrayClone();
        this.setOfKeys = allKeys;
    }

    @Override
    public final void addRegionAndKey(String regionName, Object key, boolean isRep) {
        if (this.setOfKeys == null) {
            this.setOfKeys = new TreeSet();
        }
        this.setOfKeys.add(new RegionAndKey(regionName, key, isRep));
    }

    @Override
    public final void addRegionAndKey(RegionAndKey rak) {
        if (rak != null) {
            if (this.setOfKeys == null) {
                this.setOfKeys = new TreeSet();
            }
            this.setOfKeys.add(rak);
        }
    }

    @Override
    public final void addAllKeys(TreeSet<RegionAndKey> allKeys) {
        if (allKeys == null) {
            return;
        }
        if (this.setOfKeys == null) {
            this.setOfKeys = new TreeSet();
        }
        this.setOfKeys.addAll(allKeys);
    }

    @Override
    public final void setAllRegionAndKeyInfo(TreeSet<RegionAndKey> keys) {
        this.setOfKeys = keys;
    }

    @Override
    public final TreeSet<RegionAndKey> getAllRegionAndKeyInfo() {
        return this.setOfKeys;
    }

    @Override
    public final void clearAllRegionAndKeyInfo() {
        this.setOfKeys = null;
    }

    protected void realloc(int ncols) {
        DataValueDescriptor[] newcol = new DataValueDescriptor[ncols];
        System.arraycopy(this.column, 0, newcol, 0, this.column.length);
        this.column = newcol;
    }

    @Override
    public long estimateRowSize() throws StandardException {
        long sz = ValueRow.estimateDVDArraySize(this.column);
        sz += (long)ClassSize.refSize;
        if (this.setOfKeys != null) {
            try {
                Iterator<RegionAndKey> iterator = this.setOfKeys.iterator();
                while (iterator.hasNext()) {
                    sz += (long)ClassSize.refSize + iterator.next().estimateMemoryUsage();
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return sz;
    }

    public static long estimateDVDArraySize(DataValueDescriptor[] dvdarr) {
        long sz = ClassSize.estimateArrayOverhead();
        for (int i = dvdarr.length - 1; i >= 0; --i) {
            sz += (long)ClassSize.refSize;
            if (dvdarr[i] == null) continue;
            sz += (long)dvdarr[i].estimateMemoryUsage();
        }
        return sz;
    }

    @Override
    public final int compare(ExecRow row, int colIdx, boolean nullsOrderedLow) throws StandardException {
        return this.column[colIdx - 1].compare(row.getColumn(colIdx), nullsOrderedLow);
    }

    @Override
    public final int compare(ExecRow row, int colIdx, long thisOffsetWidth, boolean nullsOrderedLow) throws StandardException {
        assert (ValueRow.class.isInstance(row));
        return this.column[colIdx - 1].compare(row.getColumn(colIdx), nullsOrderedLow);
    }

    @Override
    public final int computeHashCode(int position, int hash) {
        DataValueDescriptor column = this.column[position - 1];
        if (!column.isNull()) {
            return column.computeHashCode(-1, hash);
        }
        return ResolverUtils.addByteToBucketHash((byte)0, (int)hash, (int)column.getTypeFormatId());
    }

    @Override
    public final void setValue(int columnIndex, DataValueDescriptor value) throws StandardException {
        DataValueDescriptor[] column = this.column;
        DataValueDescriptor dvd = column[columnIndex];
        if (dvd != null) {
            if (value != null && !value.isNull()) {
                dvd.setValue(value);
            } else {
                dvd.restoreToNull();
            }
        } else {
            column[columnIndex] = value;
        }
    }

    @Override
    public final void setValuesInto(int[] srcColumns, boolean zeroBased, ExecRow targetRow) throws StandardException {
        DataValueDescriptor[] column = this.column;
        int nsrcCols = srcColumns.length;
        int ncols = column.length;
        for (int targetIndex = 0; targetIndex < nsrcCols; ++targetIndex) {
            int colIndex = srcColumns[targetIndex];
            if (!zeroBased) {
                --colIndex;
            }
            if (colIndex < 0) continue;
            if (colIndex < ncols) {
                targetRow.setValue(targetIndex, column[colIndex]);
                continue;
            }
            targetRow.setValue(targetIndex, null);
        }
    }

    @Override
    public final DataValueDescriptor getLastColumn() {
        return this.column[this.ncols - 1];
    }

    @Override
    public final long isNull(int logicalPosition) {
        return this.column[logicalPosition - 1].isNull() ? -7L : 0L;
    }

    @Override
    public final Object getBaseByteSource() {
        return null;
    }

    @Override
    public final Object getByteSource() {
        return null;
    }

    @Override
    public final void releaseByteSource() {
    }

    @Override
    public final byte[] getRowBytes(RowFormatter formatter) throws StandardException {
        if (!formatter.hasLobs()) {
            return formatter.generateBytes(this.column);
        }
        throw new UnsupportedOperationException("ValueRow does not support byte[] with LOBs");
    }

    @Override
    public final byte[][] getRowByteArrays(RowFormatter formatter) throws StandardException {
        if (formatter.hasLobs()) {
            return formatter.generateByteArrays(this.column);
        }
        throw new UnsupportedOperationException("ValueRow does not support byte[][] without LOBs");
    }
}

