/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.StatisticsImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatisticsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.GenericScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

class UpdateStatisticsConstantAction
extends DDLConstantAction {
    private UUID tableUUID;
    private UUID[] objectUUID;
    private String objectName;
    private boolean forTable;
    private long[] conglomerateNumber;
    private ExecIndexRow[] indexRow;
    private DataValueDescriptor[][] rowBufferArray;
    private DataValueDescriptor[] rowBuffer;
    private DataValueDescriptor[] lastUniqueKey;
    private static final int GROUP_FETCH_SIZE = 16;

    public UpdateStatisticsConstantAction() {
    }

    public UpdateStatisticsConstantAction(boolean forTable, String objectName, UUID tableUUID, UUID[] objectUUID, long[] conglomerateNumber, ExecIndexRow[] indexRow) {
        this.forTable = forTable;
        this.objectName = objectName;
        this.tableUUID = tableUUID;
        this.objectUUID = objectUUID;
        this.conglomerateNumber = conglomerateNumber;
        this.indexRow = indexRow;
    }

    public String toString() {
        return "UPDATE STATISTICS FOR " + (this.forTable ? "TABLE" : "INDEX") + " " + this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        GenericScanController gsc = null;
        TransactionController tc = activation.getTransactionController();
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        dd.startWriting(lcc);
        TableDescriptor td = dd.getTableDescriptor(this.tableUUID);
        dm.invalidateFor(td, 40, lcc);
        for (int indexNumber = 0; indexNumber < this.conglomerateNumber.length; ++indexNumber) {
            if (this.conglomerateNumber[indexNumber] == -1L) continue;
            int numCols = this.indexRow[indexNumber].nColumns() - 1;
            long[] cardinality = new long[numCols];
            long numRows = 0L;
            this.initializeRowBuffers(this.indexRow[indexNumber]);
            try {
                gsc = tc.openGroupFetchScan(this.conglomerateNumber[indexNumber], false, 0, 6, 1, null, null, 0, null, null, 0);
                boolean firstRow = true;
                int rowsFetched = 0;
                while ((rowsFetched = gsc.fetchNextGroup(this.rowBufferArray, null)) > 0) {
                    for (int i = 0; i < rowsFetched; ++i) {
                        int whichPositionChanged = this.compareWithPrevKey(i, firstRow);
                        firstRow = false;
                        if (whichPositionChanged >= 0) {
                            int j = whichPositionChanged;
                            while (j < cardinality.length) {
                                int n = j++;
                                cardinality[n] = cardinality[n] + 1L;
                            }
                        }
                        ++numRows;
                    }
                    DataValueDescriptor[] tmp = this.rowBufferArray[15];
                    this.rowBufferArray[15] = this.lastUniqueKey;
                    this.lastUniqueKey = tmp;
                }
            }
            finally {
                if (gsc != null) {
                    gsc.close();
                    gsc = null;
                }
            }
            if (numRows == 0L) break;
            dd.dropStatisticsDescriptors(this.tableUUID, this.objectUUID[indexNumber], tc);
            for (int i = 0; i < this.indexRow[indexNumber].nColumns() - 1; ++i) {
                StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), this.objectUUID[indexNumber], this.tableUUID, "I", new StatisticsImpl(numRows, cardinality[i]), i + 1);
                dd.addDescriptor(statDesc, null, 14, true, tc);
            }
        }
    }

    private void initializeRowBuffers(ExecIndexRow ir) {
        this.rowBufferArray = new DataValueDescriptor[16][];
        this.lastUniqueKey = ir.getRowArrayClone();
        this.rowBufferArray[0] = ir.getRowArray();
    }

    private int compareWithPrevKey(int index, boolean firstRow) throws StandardException {
        if (firstRow) {
            return 0;
        }
        DataValueDescriptor[] prev = index == 0 ? this.lastUniqueKey : this.rowBufferArray[index - 1];
        DataValueDescriptor[] curr = this.rowBufferArray[index];
        for (int i = 0; i < prev.length - 1; ++i) {
            DataValueDescriptor dvd = prev[i];
            if (dvd.isNull()) {
                return i;
            }
            if (prev[i].compare(curr[i]) == 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public boolean isReplayable() {
        return false;
    }
}

