/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DMLVTIResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import java.sql.ResultSet;
import java.util.Properties;

class DeleteVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public DeleteVTIResultSet(NoPutResultSet source, Activation activation) throws StandardException {
        super(source, activation);
    }

    @Override
    protected void openCore() throws StandardException {
        this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        ExecRow row = this.getNextRowCore(this.sourceResultSet);
        if (row != null) {
            this.rs = this.activation.getTargetVTI();
            SanityManager.ASSERT((this.rs != null ? 1 : 0) != 0, (String)"rs expected to be non-null");
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
            if (null == this.rowHolder) {
                this.rowHolder = new TemporaryRowHolderImpl(this.activation, new Properties());
            }
        }
        try {
            while (row != null) {
                if (!this.constants.deferred) {
                    this.rs.deleteRow();
                } else {
                    ValueRow rowId = new ValueRow(1);
                    rowId.setColumn(1, new SQLInteger(this.rs.getRow()));
                    this.rowHolder.insert(rowId);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    row = null;
                    continue;
                }
                row = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (this.constants.deferred) {
            CursorResultSet tempRS = this.rowHolder.getResultSet();
            try {
                ExecRow deferredRowBuffer = null;
                tempRS.open();
                while ((deferredRowBuffer = tempRS.getNextRow()) != null) {
                    int rowNumber = deferredRowBuffer.getColumn(1).getInt();
                    this.rs.absolute(rowNumber);
                    this.rs.deleteRow();
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                tempRS.close(false);
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }
}

