/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoRowsResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdatableVTIConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.WriteCursorConstantAction;
import java.io.InputStream;

public abstract class DMLWriteResultSet
extends NoRowsResultSetImpl {
    protected WriteCursorConstantAction constantAction;
    protected int[] baseRowReadMap;
    protected int[] streamStorableHeapColIds;
    protected ExecRow deferredSparseRow;
    protected DynamicCompiledOpenConglomInfo heapDCOCI;
    protected DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private boolean needToObjectifyStream;
    public int rowCount;

    protected DMLWriteResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation);
        this.constantAction = (WriteCursorConstantAction)constantAction;
        this.baseRowReadMap = this.constantAction.getBaseRowReadMap();
        this.streamStorableHeapColIds = this.constantAction.getStreamStorableHeapColIds();
        TransactionController tc = activation.getTransactionController();
        if (!(constantAction instanceof UpdatableVTIConstantAction)) {
            this.heapDCOCI = tc.getDynamicCompiledConglomInfo(this.constantAction.conglomId);
            if (this.constantAction.indexCIDS.length != 0) {
                this.indexDCOCIs = new DynamicCompiledOpenConglomInfo[this.constantAction.indexCIDS.length];
                for (int index = 0; index < this.constantAction.indexCIDS.length; ++index) {
                    this.indexDCOCIs[index] = tc.getDynamicCompiledConglomInfo(this.constantAction.indexCIDS[index]);
                }
            }
        }
        this.needToObjectifyStream = this.constantAction.getTriggerInfo() != null;
    }

    @Override
    public final int modifiedRowCount() {
        return this.rowCount;
    }

    protected ExecRow getNextRowCore(NoPutResultSet source) throws StandardException {
        ExecRow row = source.getNextRowCore();
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("DMLWriteResultSet::getNextRowCore: ExecRow retrieved = " + row + ". Source of retrieval = " + source));
        }
        if (this.needToObjectifyStream) {
            this.objectifyStreams(row);
        }
        return row;
    }

    private void objectifyStreams(ExecRow row) throws StandardException {
        if (row != null && this.streamStorableHeapColIds != null) {
            for (int ix = 0; ix < this.streamStorableHeapColIds.length; ++ix) {
                int heapIx = this.streamStorableHeapColIds[ix];
                int readIx = this.baseRowReadMap == null ? heapIx : this.baseRowReadMap[heapIx];
                DataValueDescriptor col = row.getColumn(readIx + 1);
                InputStream stream = ((StreamStorable)((Object)col)).returnStream();
                ((StreamStorable)((Object)col)).loadStream();
                if (stream == null) continue;
                for (int i = 1; i <= row.nColumns(); ++i) {
                    DataValueDescriptor c = row.getColumn(i);
                    if (!(c instanceof StreamStorable) || ((StreamStorable)((Object)c)).returnStream() != stream) continue;
                    row.setColumn(i, col.getClone());
                }
            }
        }
    }

    protected ExecRow makeDeferredSparseRow(ExecRow deferredBaseRow, FormatableBitSet baseRowReadList, LanguageConnectionContext lcc) throws StandardException {
        ExecRow deferredSparseRow;
        if (baseRowReadList == null) {
            deferredSparseRow = deferredBaseRow;
        } else {
            deferredSparseRow = RowUtil.getEmptyValueRow(baseRowReadList.getLength() - 1, lcc);
            int fromPosition = 1;
            for (int i = 1; i <= deferredSparseRow.nColumns(); ++i) {
                if (!baseRowReadList.isSet(i)) continue;
                deferredSparseRow.setColumn(i, deferredBaseRow.getColumn(fromPosition++));
            }
        }
        return deferredSparseRow;
    }

    int decodeLockMode(int lockMode) {
        SanityManager.ASSERT((!this.isClosed() ? 1 : 0) != 0);
        if (lockMode >>> 16 == 0) {
            return lockMode;
        }
        int isolationLevel = this.lcc.getCurrentIsolationLevel();
        if (isolationLevel == 4) {
            return lockMode >>> 16;
        }
        return lockMode & 0xFF;
    }

    String getIndexNameFromCID(long indexCID) {
        return this.constantAction.getIndexNameFromCID(indexCID);
    }

    protected void distributeBulkOpToDBSynchronizer() throws StandardException {
        GenericPreparedStatement gps = (GenericPreparedStatement)((BaseActivation)this.activation).getPreparedStatement();
        if (GemFireXDUtils.TraceDBSynchronizer) {
            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("DMLWriteResultset::distributeBulkOpToDBSynchronizer: DML under consideration for hub distribution: " + gps.getUserQueryString(this.lcc)));
        }
        boolean dbSyncToBeDone = this.lcc.dbSyncToBeDone();
        if (gps.createQueryInfo() || dbSyncToBeDone) {
            LocalRegion region;
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("DMLWriteResultset::distributeBulkOpToDBSynchronizer: eligible for distribution: " + gps.getUserQueryString(this.lcc) + " and dbSync flag in lcc: " + this.lcc.dbSyncToBeDone() + ", gps.getpartitionedregion: " + gps.getPartitionedRegion()));
            }
            LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("DMLWriteResultset::distributeBulkOpToDBSynchronizer: activation is: " + this.activation + ", activation param count: " + this.activation.getParameterValueSet().getParameterCount() + ", skip listeners: " + lcc.isSkipListeners()));
            }
            if ((region = gps.getLocalRegion()) == null) {
                assert (dbSyncToBeDone);
                region = gps.getPartitionedRegion();
            }
            this.activation.distributeBulkOpToDBSynchronizer(region, this.activation.getParameterValueSet().getParameterCount() > 0, (GemFireTransaction)lcc.getTransactionExecute(), lcc.isSkipListeners(), null);
        } else if (GemFireXDUtils.TraceDBSynchronizer) {
            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("DMLWriteResultset::distributeBulkOpToDBSynchronizer:: NOT eligible for distribution: " + gps.getUserQueryString(this.lcc)));
        }
    }
}

