/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRowToBaseRowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;

class CurrentOfResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private boolean next;
    private RowLocation rowLocation;
    private CursorResultSet cursor;
    private CursorResultSet target;
    private ExecRow sparseRow;
    private final String cursorName;

    CurrentOfResultSet(String cursorName, Activation activation, int resultSetNumber) {
        super(activation, resultSetNumber, 0.0, 0.0);
        SanityManager.ASSERT((cursorName != null ? 1 : 0) != 0, (String)"current of scan must get cursor name");
        this.cursorName = cursorName;
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"CurrentOfResultSet already open");
        this.isOpen = true;
        this.getCursor();
        this.next = false;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isOpen) {
            if (!this.next) {
                TableScanResultSet scan;
                this.next = true;
                SanityManager.ASSERT((!this.cursor.isClosed() ? 1 : 0) != 0, (String)"cursor closed");
                ExecRow cursorRow = this.cursor.getCurrentRow();
                if (cursorRow == null) {
                    throw StandardException.newException("24000");
                }
                this.rowLocation = this.cursor.getRowLocation();
                this.currentRow = this.target.getCurrentRow();
                if (this.rowLocation == null || cursorRow != null && this.currentRow == null) {
                    this.activation.addWarning(StandardException.newWarning("01001"));
                    return null;
                }
                if (this.target instanceof TableScanResultSet) {
                    scan = (TableScanResultSet)this.target;
                    if (scan.indexCols != null && this.currentRow != null) {
                        this.currentRow = this.getSparseRow(this.currentRow, scan.indexCols);
                    }
                }
                if ((scan = (TableScanResultSet)this.activation.getForUpdateIndexScan()) != null) {
                    if (this.target instanceof IndexRowToBaseRowResultSet) {
                        scan.setCompareToLastKey(((IndexRowToBaseRowResultSet)this.target).currentRowPrescanned);
                    } else if (this.target instanceof TableScanResultSet) {
                        scan.setCompareToLastKey(((TableScanResultSet)this.target).currentRowPrescanned());
                    }
                }
            } else {
                this.currentRow = null;
                this.rowLocation = null;
            }
        } else {
            this.currentRow = null;
            this.rowLocation = null;
        }
        this.setCurrentRow(this.currentRow);
        return this.currentRow;
    }

    private ExecRow getSparseRow(ExecRow row, int[] indexCols) throws StandardException {
        int colPos;
        if (this.sparseRow == null) {
            int numCols = 1;
            for (int i = 0; i < indexCols.length; ++i) {
                int n = colPos = indexCols[i] > 0 ? indexCols[i] : -indexCols[i];
                if (colPos <= numCols) continue;
                numCols = colPos;
            }
            this.sparseRow = new ValueRow(numCols);
        }
        for (int i = 1; i <= indexCols.length; ++i) {
            colPos = indexCols[i - 1] > 0 ? indexCols[i - 1] : -indexCols[i - 1];
            this.sparseRow.setColumn(colPos, row.getColumn(i));
        }
        return this.sparseRow;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of CurrentOfResultSet repeated");
        }
    }

    @Override
    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int type, int timeType) {
        return 0L;
    }

    @Override
    public RowLocation getRowLocation() {
        return this.rowLocation;
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private void getCursor() throws StandardException {
        LanguageConnectionContext lcc;
        CursorActivation cursorActivation;
        if (this.cursor != null && this.cursor.isClosed()) {
            this.cursor = null;
            this.target = null;
        }
        if (this.cursor == null && (cursorActivation = (lcc = this.getLanguageConnectionContext()).lookupCursorActivation(this.cursorName)) != null) {
            this.cursor = cursorActivation.getCursorResultSet();
            this.target = cursorActivation.getTargetResultSet();
            this.activation.setForUpdateIndexScan(cursorActivation.getForUpdateIndexScan());
            if (cursorActivation.getHeapConglomerateController() != null) {
                cursorActivation.getHeapConglomerateController().close();
            }
            cursorActivation.setHeapConglomerateController(this.activation.getHeapConglomerateController());
        }
        if (this.cursor == null || this.cursor.isClosed()) {
            throw StandardException.newException("42X30", this.cursorName);
        }
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        ((NoPutResultSet)((Object)this.cursor)).updateRow(row);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        ((NoPutResultSet)((Object)this.cursor)).markRowAsDeleted();
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.upgradeReadLockToWrite(this.rowLocation, null);
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) {
        if (localTXState != null) {
            this.releaseRowLocationLock(this.rowLocation, null);
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "CURRENT-OF");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber));
        }
    }
}

