/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortObserver;
import java.util.ArrayList;
import java.util.List;

public class BasicSortObserver
implements SortObserver {
    protected boolean doClone;
    protected final boolean distinct;
    private final boolean reuseWrappers;
    private ExecRow execRow;
    private final List<ExecRow> array;

    public BasicSortObserver(boolean doClone, boolean distinct, ExecRow execRow, boolean reuseWrappers) {
        this.doClone = doClone;
        this.distinct = distinct;
        this.execRow = execRow;
        this.reuseWrappers = reuseWrappers;
        this.array = new ArrayList<ExecRow>();
    }

    @Override
    public ExecRow insertNonDuplicateKey(ExecRow insertRow) throws StandardException {
        return this.doClone ? this.getClone(insertRow) : insertRow;
    }

    @Override
    public ExecRow insertDuplicateKey(ExecRow insertRow, ExecRow existingRow) throws StandardException {
        return this.distinct ? null : (this.doClone ? this.getClone(insertRow) : insertRow);
    }

    @Override
    public void addToFreeList(ExecRow objectArray, int maxFreeListSize) {
        if (this.reuseWrappers && this.array.size() < maxFreeListSize) {
            this.array.add(objectArray);
        }
    }

    @Override
    public ExecRow getArrayClone() throws StandardException {
        int lastElement = this.array.size();
        if (lastElement > 0) {
            ExecRow retval = this.array.remove(lastElement - 1);
            return retval;
        }
        return this.execRow.getClone();
    }

    public boolean eliminateDuplicate(Object insertRow, Object existingRow) {
        return this.distinct;
    }

    public boolean canSkipDuplicate() {
        return this.distinct;
    }

    @Override
    public void setTemplateRow(ExecRow row) {
        this.execRow = row;
    }

    @Override
    public ExecRow getRowArray() throws StandardException {
        int lastElement = this.array.size();
        if (lastElement > 0) {
            ExecRow retval = this.array.remove(lastElement - 1);
            return retval;
        }
        return this.execRow;
    }

    private ExecRow getClone(ExecRow origArray) {
        ExecRow clone = origArray.getClone();
        clone.setAllRegionAndKeyInfo(origArray.getAllRegionAndKeyInfo());
        return clone;
    }

    public final boolean isDistinct() {
        return this.distinct;
    }
}

