/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNodeVector;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;

public class SubqueryList
extends QueryTreeNodeVector {
    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        for (int index = 0; index < this.size(); ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            subqueryNode.treePrint(depth + 1);
        }
    }

    public void addSubqueryNode(SubqueryNode subqueryNode) throws StandardException {
        this.addElement(subqueryNode);
    }

    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            subqueryNode.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
    }

    public void optimize(DataDictionary dataDictionary, double outerRows) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            subqueryNode.optimize(dataDictionary, outerRows);
        }
    }

    public void modifyAccessPaths() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            subqueryNode.modifyAccessPaths();
        }
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            if (subqueryNode.isMaterializable() || !subqueryNode.getResultSet().referencesTarget(name, baseTable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            if (!subqueryNode.getResultSet().referencesSessionSchema()) continue;
            return true;
        }
        return false;
    }

    public void setPointOfAttachment(int pointOfAttachment) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            subqueryNode.setPointOfAttachment(pointOfAttachment);
        }
    }

    void decrementLevel(int decrement) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((SubqueryNode)this.elementAt(index)).getResultSet().decrementLevel(decrement);
        }
    }

    public void markHavingSubqueries() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            subqueryNode.setHavingSubquery(true);
        }
    }

    public void markWhereSubqueries() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            SubqueryNode subqueryNode = (SubqueryNode)this.elementAt(index);
            subqueryNode.setWhereSubquery(true);
        }
    }
}

