/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.DistributedProcedureCallNode;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProxy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SQLToJavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StaticMethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class JavaToSQLValueNode
extends ValueNode {
    JavaValueNode javaNode;
    ProcedureProxy procProxy;

    public ProcedureProxy getProcedureProxy() {
        return this.procProxy;
    }

    @Override
    public void init(Object value) {
        this.javaNode = (JavaValueNode)value;
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.javaNode.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.javaNode.returnValueToSQLDomain();
        boolean hasReceiver = this.javaNode.generateReceiver(acb, mb);
        if (hasReceiver) {
            String nullValueClass = this.getTypeCompiler().interfaceName();
            LocalField nullValueField = acb.newFieldDeclaration(2, nullValueClass);
            mb.conditionalIfNull();
            mb.getField(nullValueField);
            acb.generateNullWithExpress(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
            mb.startElseCode();
        }
        TypeId resultType = this.getTypeId();
        TypeCompiler tc = this.getTypeCompiler();
        String resultTypeName = tc.interfaceName();
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        this.javaNode.generateExpression(acb, mb);
        acb.generateDataValue(mb, tc, this.getTypeServices().getCollationType(), field);
        if (hasReceiver) {
            mb.completeConditional();
        }
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "javaNode: ");
        this.javaNode.treePrint(depth + 1);
    }

    public JavaValueNode getJavaValueNode() {
        return this.javaNode;
    }

    @Override
    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        if (this.javaNode != null) {
            this.javaNode.disablePrivilegeCollection();
        }
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        DataTypeDescriptor dts;
        this.javaNode.checkReliability(this);
        this.javaNode = this.javaNode.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.javaNode.getStatementType() == -1) {
            this.procProxy = ((DistributedProcedureCallNode)this.javaNode).getProcedureProxy();
        }
        if ((dts = this.javaNode.getDataType()) == null) {
            throw StandardException.newException("X0X57.S", this.javaNode.getJavaTypeName());
        }
        this.setType(dts);
        if (dts.getTypeId().isStringTypeId()) {
            this.setCollationInfo(this.javaNode.getCollationType(), 1);
        }
        return this;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.javaNode = this.javaNode.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.javaNode.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.javaNode.getOrderableVariantType();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.javaNode != null && !v.stopTraversal()) {
            this.javaNode = (JavaValueNode)this.javaNode.accept(v);
        }
        return returnNode;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) {
        return false;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return null;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            outerResultColumns.addResultColumn(parentRC);
            return this;
        }
        if (this.javaNode instanceof SQLToJavaValueNode) {
            this.javaNode = ((SQLToJavaValueNode)this.javaNode).genExpressionOperands(outerResultColumns, null, remapToNew);
        }
        return this;
    }

    @Override
    public String ncjGenerateSql() {
        if (this.javaNode instanceof StaticMethodCallNode) {
            StaticMethodCallNode smCall = (StaticMethodCallNode)this.javaNode;
            if (smCall.javaClassName.contains("Like")) {
                return "false";
            }
        }
        return super.ncjGenerateSql();
    }
}

