/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PrivilegeNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GrantNode
extends DDLStatementNode {
    private PrivilegeNode privileges;
    private List grantees;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = this.grantees.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(it.next().toString());
        }
        return super.toString() + this.privileges.toString() + "TO: \n" + sb.toString() + "\n";
    }

    @Override
    public String statementToString() {
        return "GRANT";
    }

    @Override
    public void init(Object privileges, Object grantees) {
        this.privileges = (PrivilegeNode)privileges;
        this.grantees = (List)grantees;
    }

    @Override
    public void bindStatement() throws StandardException {
        this.privileges = (PrivilegeNode)this.privileges.bind(new HashMap(), this.grantees, true);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getGrantConstantAction(this.privileges.makePrivilegeInfo(), this.grantees);
    }
}

