/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.types.BitDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;

public class BitConstantNode
extends ConstantNode {
    private int bitLength;

    @Override
    public void init(Object arg1) throws StandardException {
        super.init(arg1, Boolean.TRUE, ReuseFactory.getInteger(0));
    }

    @Override
    public void init(Object arg1, Object arg2) throws StandardException {
        String a1 = (String)arg1;
        byte[] nv = StringUtil.fromHexString(a1, 0, a1.length());
        Integer bitLengthO = (Integer)arg2;
        this.bitLength = bitLengthO;
        this.init(TypeId.getBuiltInTypeId(-2), Boolean.FALSE, bitLengthO);
        BitDataValue dvd = this.getDataValueFactory().getBitDataValue(nv);
        dvd.setWidth(this.bitLength, 0, false);
        this.setValue(dvd);
    }

    @Override
    public Object getConstantValueAsObject() throws StandardException {
        return this.value.getBytes();
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        byte[] bytes = this.value.getBytes();
        String hexLiteral = StringUtil.toHexString(bytes, 0, bytes.length);
        mb.push(hexLiteral);
        mb.push(0);
        mb.push(hexLiteral.length());
        mb.callMethod((short)184, "com.pivotal.gemfirexd.internal.iapi.util.StringUtil", "fromHexString", "byte[]", 3);
    }
}

