/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class XPLAINStatementTimingsDescriptor
extends XPLAINTableDescriptor {
    private UUID timing_id;
    private Long parse_time;
    private Long bind_time;
    private Long optimize_time;
    private Long routing_info_time;
    private Long generate_time;
    private Long compile_time;
    private Long execute_time;
    private Timestamp begin_comp_time;
    private Timestamp end_comp_time;
    private Timestamp begin_exe_time;
    private Timestamp end_exe_time;
    static final String TABLENAME_STRING = "SYSXPLAIN_STATEMENT_TIMINGS";
    private static final String[][] indexColumnNames = new String[][]{{"TIMING_ID"}};

    protected XPLAINStatementTimingsDescriptor() {
    }

    public XPLAINStatementTimingsDescriptor(UUID timing_id, Long parse_time, Long bind_time, Long optimize_time, Long routing_info_time, Long generate_time, Long compile_time, Long execute_time, Timestamp begin_comp_time, Timestamp end_comp_time, Timestamp begin_exe_time, Timestamp end_exe_time) {
        this.timing_id = timing_id;
        this.parse_time = parse_time;
        this.bind_time = bind_time;
        this.optimize_time = optimize_time;
        this.routing_info_time = routing_info_time;
        this.generate_time = generate_time;
        this.compile_time = compile_time;
        this.execute_time = execute_time;
        this.begin_comp_time = begin_comp_time;
        this.end_comp_time = end_comp_time;
        this.begin_exe_time = begin_exe_time;
        this.end_exe_time = end_exe_time;
    }

    public void setStatementParameters(PreparedStatement ps) throws SQLException {
        ps.setString(1, this.timing_id.toString());
        if (this.parse_time != null) {
            ps.setLong(2, this.parse_time);
        } else {
            ps.setNull(2, -5);
        }
        if (this.bind_time != null) {
            ps.setLong(3, this.bind_time);
        } else {
            ps.setNull(3, -5);
        }
        if (this.optimize_time != null) {
            ps.setLong(4, this.optimize_time);
        } else {
            ps.setNull(4, -5);
        }
        if (this.routing_info_time != null) {
            ps.setLong(5, this.routing_info_time);
        } else {
            ps.setNull(5, -5);
        }
        if (this.generate_time != null) {
            ps.setLong(6, this.generate_time);
        } else {
            ps.setNull(6, -5);
        }
        if (this.compile_time != null) {
            ps.setLong(7, this.compile_time);
        } else {
            ps.setNull(7, -5);
        }
        if (this.execute_time != null) {
            ps.setLong(8, this.execute_time);
        } else {
            ps.setNull(8, -5);
        }
        ps.setTimestamp(9, this.begin_comp_time);
        ps.setTimestamp(10, this.end_comp_time);
        ps.setTimestamp(11, this.begin_exe_time);
        ps.setTimestamp(12, this.end_exe_time);
    }

    @Override
    public String getCatalogName() {
        return TABLENAME_STRING;
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TIMING_ID", false), SystemColumnImpl.getColumn("PARSE_TIME", -5, false), SystemColumnImpl.getColumn("BIND_TIME", -5, false), SystemColumnImpl.getColumn("OPTIMIZE_TIME", -5, false), SystemColumnImpl.getColumn("ROUTING_INFO_TIME", -5, false), SystemColumnImpl.getColumn("GENERATE_TIME", -5, false), SystemColumnImpl.getColumn("COMPILE_TIME", -5, false), SystemColumnImpl.getColumn("EXECUTE_TIME", -5, false), SystemColumnImpl.getColumn("BEGIN_COMP_TIME", 93, false), SystemColumnImpl.getColumn("END_COMP_TIME", 93, false), SystemColumnImpl.getColumn("BEGIN_EXE_TIME", 93, false), SystemColumnImpl.getColumn("END_EXE_TIME", 93, false)};
    }

    @Override
    protected void addConstraints(StringBuilder sb) {
    }

    public long getExecuteTime() {
        return this.execute_time != null ? this.execute_time : 0L;
    }

    public String toString() {
        return super.toString() + " TIMING_ID=" + this.timing_id + " COMPILE_TIME=" + this.compile_time + " EXECUTE_TIME=" + this.execute_time + " BEGIN_EXECUTE_TIME=" + this.begin_exe_time + " END_EXECUTE_TIME=" + this.end_exe_time;
    }

    @Override
    protected void createIndex(StringBuilder idx, String schemaName) {
    }
}

