/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.XPLAINDistPropsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINScanPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINSortPropsDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.tools.planexporter.StatisticsCollectionObserver;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class XPLAINResultSetDescriptor
extends XPLAINTableDescriptor
implements Comparable<XPLAINResultSetDescriptor> {
    public static final double oneMillisNanos = 1000000.0;
    public final String rs_name;
    public final int num_children;
    private int insert_order;
    private double totalExecutionTimeNanos;
    private UUID rs_id;
    private String op_identifier;
    private String op_details;
    private Integer no_opens;
    private Integer no_index_updates;
    private String lock_granularity;
    private String lock_mode;
    private UUID parent_rs_id;
    private Double est_row_count;
    private Double est_cost;
    private Integer affected_rows;
    private String deferred_rows;
    private Integer input_rows;
    private Integer seen_rows;
    private Integer seen_rows_right;
    private Integer filtered_rows;
    private Integer returned_rows;
    private Integer empty_right_rows;
    private String index_key_optimization;
    private transient XPLAINScanPropsDescriptor scan;
    private transient XPLAINSortPropsDescriptor sort;
    private UUID stmt_id;
    private transient XPLAINResultSetTimingsDescriptor timing;
    private transient XPLAINDistPropsDescriptor dist;
    private int rank;
    static final String TABLENAME_STRING = "SYSXPLAIN_RESULTSETS";
    private static final String[][] indexColumnNames = new String[][]{{"RS_ID"}};

    protected XPLAINResultSetDescriptor() {
        this.rs_name = "protected-constructor";
        this.num_children = -1;
    }

    public XPLAINResultSetDescriptor(String rs_name, int num_children, int insert_order, UUID rs_id, String op_identifier, String op_details, Integer no_opens, Integer no_index_updates, String lock_mode, String lock_granularity, UUID parent_rs_id, Double est_row_count, Double est_cost, Integer affected_rows, String deferred_rows, Integer input_rows, Integer seen_rows, Integer seen_rows_right, Integer filtered_rows, Integer returned_rows, Integer empty_right_rows, String index_key_optimization, XPLAINScanPropsDescriptor scan, XPLAINSortPropsDescriptor sort, UUID stmt_id, XPLAINResultSetTimingsDescriptor timing, XPLAINDistPropsDescriptor distdesc) {
        this.rs_name = rs_name;
        this.num_children = num_children;
        this.insert_order = insert_order;
        this.rs_id = rs_id;
        this.op_identifier = op_identifier;
        this.op_details = op_details;
        this.no_opens = no_opens;
        this.no_index_updates = no_index_updates;
        this.lock_granularity = lock_granularity;
        this.lock_mode = lock_mode;
        this.parent_rs_id = parent_rs_id;
        this.est_row_count = est_row_count;
        this.est_cost = est_cost;
        this.affected_rows = affected_rows;
        this.deferred_rows = deferred_rows;
        this.input_rows = input_rows;
        this.seen_rows = seen_rows;
        this.seen_rows_right = seen_rows_right;
        this.filtered_rows = filtered_rows;
        this.returned_rows = returned_rows;
        this.empty_right_rows = empty_right_rows;
        this.index_key_optimization = index_key_optimization;
        this.scan = scan;
        this.sort = sort;
        this.stmt_id = stmt_id;
        this.timing = timing;
        this.dist = distdesc;
    }

    public static final void setStatementParameters(Connection conn, PreparedStatement ps, UUID stmt_id, StringBuilder xmlFragment) throws SQLException {
        Clob c;
        block3: {
            ps.setString(1, stmt_id != null ? stmt_id.toString() : null);
            c = conn.createClob();
            try {
                c.setCharacterStream(1L).write(xmlFragment.toString());
            }
            catch (IOException e) {
                if (GemFireXDUtils.TracePlanAssertion) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanAssertion", (String)"couldn't set clob stream.", (Throwable)e);
                }
                if (!GemFireXDUtils.TracePlanGeneration) break block3;
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)"couldn't set clob stream.");
            }
        }
        ps.setClob(2, c);
    }

    public void setStatementParameters(PreparedStatement ps) throws SQLException {
        ps.setString(1, this.rs_id.toString());
        ps.setString(2, this.op_identifier);
        ps.setString(3, this.op_details);
        if (this.no_opens != null) {
            ps.setInt(4, this.no_opens);
        } else {
            ps.setNull(4, 4);
        }
        if (this.no_index_updates != null) {
            ps.setInt(5, this.no_index_updates);
        } else {
            ps.setNull(5, 4);
        }
        ps.setString(6, this.lock_mode);
        ps.setString(7, this.lock_granularity);
        ps.setString(8, this.parent_rs_id != null ? this.parent_rs_id.toString() : null);
        if (this.est_row_count != null) {
            ps.setDouble(9, this.est_row_count);
        } else {
            ps.setNull(9, 8);
        }
        if (this.est_cost != null) {
            ps.setDouble(10, this.est_cost);
        } else {
            ps.setNull(10, 8);
        }
        if (this.affected_rows != null) {
            ps.setInt(11, this.affected_rows);
        } else {
            ps.setNull(11, 4);
        }
        ps.setString(12, this.deferred_rows);
        if (this.input_rows != null) {
            ps.setInt(13, this.input_rows);
        } else {
            ps.setNull(13, 4);
        }
        if (this.seen_rows != null) {
            ps.setInt(14, this.seen_rows);
        } else {
            ps.setNull(14, 4);
        }
        if (this.seen_rows_right != null) {
            ps.setInt(15, this.seen_rows_right);
        } else {
            ps.setNull(15, 4);
        }
        if (this.filtered_rows != null) {
            ps.setInt(16, this.filtered_rows);
        } else {
            ps.setNull(16, 4);
        }
        if (this.returned_rows != null) {
            ps.setInt(17, this.returned_rows);
        } else {
            ps.setNull(17, 4);
        }
        if (this.empty_right_rows != null) {
            ps.setInt(18, this.empty_right_rows);
        } else {
            ps.setNull(18, 4);
        }
        ps.setString(19, this.index_key_optimization);
        ps.setString(20, this.scan != null ? this.scan.getRSID().toString() : null);
        ps.setString(21, this.sort != null ? this.sort.getRSID().toString() : null);
        ps.setString(22, this.stmt_id != null ? this.stmt_id.toString() : null);
        ps.setString(23, "-");
        ps.setInt(24, this.insert_order);
        ps.setString(25, this.dist != null ? this.dist.getRSID().toString() : null);
        ps.setInt(26, this.rank);
    }

    @Override
    public String getCatalogName() {
        return TABLENAME_STRING;
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("STMT_ID", false), SystemColumnImpl.getColumn("PLAN_XML_FRAGMENT", 2005, false)};
    }

    @Override
    protected void addConstraints(StringBuilder sb) {
    }

    public String toString() {
        return "ResultSet@" + System.identityHashCode(this) + " rank=" + this.rank + " OP_IDENTIFIER=" + this.op_identifier + " RS_ID=" + this.rs_id + " STMT_ID=" + this.stmt_id + (this.timing != null ? " TIMING=" + this.timing.getTimingID() : "") + (this.dist != null ? " DIST_ID=" + this.dist.getRSID() : "") + (this.scan != null ? " SCAN_ID=" + this.scan.getRSID() : "") + (this.sort != null ? " SORT_ID=" + this.sort.getRSID() : "") + " OP_DETAILS=" + this.op_details;
    }

    public void setInputRows(int rows) {
        if (rows != -1) {
            this.input_rows = rows;
        }
    }

    public void setIndexKeyOptimization(String yesNo) {
        this.index_key_optimization = yesNo;
    }

    public void setRowsSeenRight(int rows) {
        if (rows != -1) {
            this.seen_rows_right = rows;
        }
    }

    public void setRowsSeen(int rows) {
        if (rows != -1) {
            this.seen_rows = rows;
        }
    }

    public void setEmptyRightRowsReturned(int rows) {
        if (rows != -1) {
            this.empty_right_rows = rows;
        }
    }

    public void setAffectedRows(int rows) {
        this.affected_rows = rows;
    }

    public void setDeferredRows(boolean deferred) {
        this.deferred_rows = XPLAINUtil.getYesNoCharFromBoolean(deferred);
    }

    public void setIndexesUpdated(int numIndex) {
        this.no_index_updates = numIndex;
    }

    public long getExecuteTime() {
        long executeTime = this.timing != null ? this.timing.getExecuteTime() : (this.dist != null ? this.dist.getExecuteTime() : 0L);
        return executeTime;
    }

    public UUID getRSID() {
        return this.rs_id;
    }

    @Override
    protected void createIndex(StringBuilder idx, String schemaName) {
    }

    public boolean equals(Object obj) {
        return this.compareTo((XPLAINResultSetDescriptor)obj) == 0;
    }

    public int hashCode() {
        long executeTime = this.getExecuteTime();
        return (int)(executeTime ^ executeTime >>> 32);
    }

    @Override
    public int compareTo(XPLAINResultSetDescriptor other) {
        long _other;
        assert (other != null);
        long _this = this.getExecuteTime();
        return _this > (_other = other.getExecuteTime()) ? -1 : (_this < _other ? 1 : 0);
    }

    public void setRank(int i) {
        this.rank = i;
    }

    public void setTotalExecuteTimeNanos(double executeTime) {
        this.totalExecutionTimeNanos = executeTime == 0.0 ? 1.0 : executeTime;
    }

    public StringBuilder getXMLAttributes(StringBuilder sb, StatisticsCollectionObserver observer) {
        PlanUtils.xmlAttribute(sb, "rs_name", this.rs_name);
        PlanUtils.xmlAttribute(sb, "no_children", this.num_children);
        PlanUtils.xmlAttribute(sb, "name", this.op_identifier);
        PlanUtils.xmlAttribute(sb, "rank", this.rank);
        long executeTime = this.getExecuteTime();
        PlanUtils.xmlAttribute(sb, "execute_time", (double)executeTime / 1000000.0, "ms");
        if (this.timing != null) {
            if (this.rank <= 5) {
                PlanUtils.xmlAttribute(sb, "construct_time", (double)this.timing.constructor_time / 1000000.0, "ms");
                PlanUtils.xmlAttribute(sb, "open_time", (double)this.timing.open_time / 1000000.0, "ms");
                PlanUtils.xmlAttribute(sb, "next_time", (double)this.timing.next_time / 1000000.0, "ms");
                PlanUtils.xmlAttribute(sb, "close_time", (double)this.timing.close_time / 1000000.0, "ms");
            }
            if (this.timing.avg_next_time_per_row >= 0L) {
                PlanUtils.xmlAttribute(sb, "avg_next_time_per_row", (double)this.timing.avg_next_time_per_row / 1000000.0, "ms");
            }
            if (this.timing.projection_time >= 0L) {
                PlanUtils.xmlAttribute(sb, "projection_time", (double)this.timing.projection_time / 1000000.0, "ms");
            }
            if (this.timing.restriction_time >= 0L) {
                PlanUtils.xmlAttribute(sb, "restriction_time", (double)this.timing.restriction_time / 1000000.0, "ms");
            }
            if (this.timing.temp_cong_create_time >= 0L) {
                PlanUtils.xmlAttribute(sb, "temp_cong_create_time", (double)this.timing.temp_cong_create_time / 1000000.0, "ms");
            }
            if (this.timing.temp_cong_fetch_time >= 0L) {
                PlanUtils.xmlAttribute(sb, "temp_cong_fetch_time", (double)this.timing.temp_cong_fetch_time / 1000000.0, "ms");
            }
            if (observer != null) {
                observer.processedResultSetTimingDescriptor(this.timing);
            }
        }
        double delta = (double)executeTime / this.totalExecutionTimeNanos;
        double percent = delta * 100.0;
        PlanUtils.xmlAttribute(sb, "percent_exec_time", PlanUtils.format.format(percent));
        if (this.no_opens != null) {
            PlanUtils.xmlAttribute(sb, "no_opens", this.no_opens.intValue());
        }
        if (this.input_rows != null) {
            PlanUtils.xmlAttribute(sb, "input_rows", this.input_rows.intValue());
        }
        if (this.returned_rows != null) {
            PlanUtils.xmlAttribute(sb, "returned_rows", this.returned_rows.intValue());
        }
        if (this.scan != null) {
            PlanUtils.xmlAttribute(sb, "scanned_object", this.scan.scan_object_name);
            PlanUtils.xmlAttribute(sb, "scan_type", this.scan.scan_type);
            if (this.scan.no_visited_pages != null) {
                PlanUtils.xmlAttribute(sb, "visited_pages", this.scan.no_visited_pages.intValue());
            }
            if (this.scan.no_visited_rows != null) {
                PlanUtils.xmlAttribute(sb, "visited_rows", this.scan.no_visited_rows.intValue());
            }
            PlanUtils.xmlAttribute(sb, "scan_qualifiers", this.scan.scan_qualifiers);
            PlanUtils.xmlAttribute(sb, "next_qualifiers", this.scan.next_qualifiers);
            if (observer != null) {
                observer.processedScanPropsDescriptor(this.scan);
            }
        }
        if (this.sort != null) {
            PlanUtils.xmlAttribute(sb, "sort_type", this.sort.sort_type);
            if (this.sort.no_input_rows != null) {
                PlanUtils.xmlAttribute(sb, "sorter_input", this.sort.no_input_rows.intValue());
            }
            if (this.sort.no_output_rows != null) {
                PlanUtils.xmlAttribute(sb, "sorter_output", this.sort.no_output_rows.intValue());
            }
            if (observer != null) {
                observer.processedSortPropsDescriptor(this.sort);
            }
        }
        PlanUtils.xmlAttribute(sb, "node_details", this.op_details);
        if (this.dist != null) {
            String objectType;
            if (this.rank <= 5) {
                PlanUtils.xmlAttribute(sb, "ser_deser_time", (double)this.dist.getSerDeSerTime() / 1000000.0, "ms");
                PlanUtils.xmlAttribute(sb, "process_time", (double)this.dist.getProcessTime() / 1000000.0, "ms");
                PlanUtils.xmlAttribute(sb, "throttle_time", (double)this.dist.getThrottleTime() / 1000000.0, "ms");
            }
            String member_node = "QUERY-SEND".equals(objectType = this.dist.getDistObjectType()) || "RESULT-SEND".equals(objectType) ? this.dist.getTargetMember() : ("QUERY-SCATTER".equals(objectType) ? this.dist.getPrunedMemberList() : this.dist.getOriginator());
            PlanUtils.xmlAttribute(sb, "member_node", member_node);
            if (observer != null) {
                observer.processedDistPropsDescriptor(this.dist);
            }
        }
        return sb;
    }
}

