/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.ClassBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class GClass
implements ClassBuilder {
    protected ByteArray bytecode;
    protected final ClassFactory cf;
    protected final String qualifiedName;

    public GClass(ClassFactory cf, String qualifiedName) {
        this.cf = cf;
        this.qualifiedName = qualifiedName;
    }

    @Override
    public String getFullName() {
        return this.qualifiedName;
    }

    @Override
    public GeneratedClass getGeneratedClass() throws StandardException {
        return this.cf.loadGeneratedClass(this.qualifiedName, this.getClassBytecode());
    }

    protected void writeClassFile(String dir, boolean logMessage, Throwable t) throws StandardException {
        if (this.bytecode == null) {
            this.getClassBytecode();
        }
        if (dir == null) {
            dir = "";
        }
        String filename = this.getName();
        filename = filename + ".class";
        File classFile = new File(dir, filename);
        HeaderPrintWriter errorStream = Monitor.getStream();
        try {
            FileOutputStream fis = new FileOutputStream(classFile);
            fis.write(this.bytecode.getArray(), this.bytecode.getOffset(), this.bytecode.getLength());
            fis.flush();
            if (logMessage) {
                errorStream.printlnWithHeader("Wrote class " + this.getFullName() + " to file " + classFile.toString() + ". Please provide support with the file and the following exception message: " + t);
            }
            fis.close();
        }
        catch (IOException e) {
            SanityManager.THROWASSERT((String)"Unable to write .class file", (Throwable)e);
        }
    }

    final void validateType(String typeName1) {
        SanityManager.ASSERT((typeName1 != null ? 1 : 0) != 0);
        String typeName = typeName1.trim();
        if ("void".equals(typeName)) {
            return;
        }
        while (typeName.endsWith("[]")) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        SanityManager.ASSERT((typeName.length() > 0 ? 1 : 0) != 0);
        if ("boolean".equals(typeName)) {
            return;
        }
        if ("byte".equals(typeName)) {
            return;
        }
        if ("char".equals(typeName)) {
            return;
        }
        if ("double".equals(typeName)) {
            return;
        }
        if ("float".equals(typeName)) {
            return;
        }
        if ("int".equals(typeName)) {
            return;
        }
        if ("long".equals(typeName)) {
            return;
        }
        if ("short".equals(typeName)) {
            return;
        }
        try {
            if (this.cf == null) {
                Class.forName(typeName);
            } else {
                this.cf.loadApplicationClass(typeName);
            }
        }
        catch (ClassNotFoundException cnfe) {
            SanityManager.THROWASSERT((String)("Class " + typeName + " not found"), (Throwable)cnfe);
        }
    }
}

