/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.load.ExportAbstract;
import com.pivotal.gemfirexd.internal.impl.load.ImportAbstract;
import com.pivotal.gemfirexd.internal.impl.load.LoadError;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

class ColumnInfo {
    private ArrayList vtiColumnNames = new ArrayList(1);
    private ArrayList insertColumnNames = new ArrayList(1);
    private ArrayList columnTypes = new ArrayList(1);
    private ArrayList jdbcColumnTypes = new ArrayList(1);
    private int noOfColumns = 0;
    private ArrayList columnPositions;
    private boolean createolumnNames = true;
    private int expectedNumberOfCols;
    private Connection conn;
    private String tableName;
    private String schemaName;
    private HashMap udtClassNames = new HashMap();
    private boolean hasColumnDefinition;

    public ColumnInfo(Connection conn, String sName, String tName, String insertColumnList, String vtiColumnIndexes, String vtiColumnPrefix, String inputFileName, String columnDelimiter) throws SQLException {
        StringTokenizer st;
        this.conn = conn;
        this.schemaName = sName;
        this.tableName = tName;
        columnDelimiter = columnDelimiter == null ? "," : columnDelimiter;
        String insertColumnListFromFile = this.readColumnListFromFile(inputFileName, columnDelimiter);
        if (insertColumnList == null || insertColumnList.isEmpty()) {
            insertColumnList = insertColumnListFromFile;
        }
        if (insertColumnList != null) {
            st = new StringTokenizer(insertColumnList, columnDelimiter);
            while (st.hasMoreTokens()) {
                String columnName = st.nextToken().trim();
                if (this.initializeColumnInfo(columnName)) continue;
                if (this.tableExists()) {
                    throw LoadError.invalidColumnName(columnName);
                }
                String entityName = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
                throw LoadError.tableNotFound(entityName);
            }
        } else if (!this.initializeColumnInfo(null)) {
            String entityName = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
            throw LoadError.tableNotFound(entityName);
        }
        if (vtiColumnIndexes != null) {
            st = new StringTokenizer(vtiColumnIndexes, ",");
            while (st.hasMoreTokens()) {
                String columnIndex = st.nextToken().trim();
                this.vtiColumnNames.add(vtiColumnPrefix + columnIndex);
                int cIndex = Integer.parseInt(columnIndex, 10);
                if (cIndex <= this.expectedNumberOfCols) continue;
                this.expectedNumberOfCols = cIndex;
            }
        }
        if (this.vtiColumnNames.size() < 1) {
            for (int index = 1; index <= this.noOfColumns; ++index) {
                this.vtiColumnNames.add(vtiColumnPrefix + index);
            }
            this.expectedNumberOfCols = this.noOfColumns;
        }
    }

    private String readColumnListFromFile(String inputFileName, String columnDelimiter) throws SQLException {
        BufferedReader reader = null;
        String caseSensitiveColumnNameList = "";
        try {
            URL url = new URL(inputFileName);
            if (url.getProtocol().equals("file")) {
                inputFileName = url.getFile();
                throw new MalformedURLException();
            }
        }
        catch (MalformedURLException ex) {
            try {
                reader = new BufferedReader(new FileReader(inputFileName));
            }
            catch (FileNotFoundException fnfe) {
                throw LoadError.dataFileNotFound(inputFileName, fnfe);
            }
        }
        try {
            DatabaseMetaData dmd = this.conn.getMetaData();
            ResultSet rs = dmd.getColumns(null, this.schemaName, this.tableName, null);
            HashMap<String, String> colMetaData = new HashMap<String, String>();
            while (rs.next()) {
                String columnName = rs.getString(4).trim();
                colMetaData.put(columnName.toUpperCase(), columnName.trim());
            }
            String potentialColumnInfo = reader.readLine();
            if (potentialColumnInfo == null) {
                return null;
            }
            potentialColumnInfo = potentialColumnInfo.replaceAll("\"", "");
            StringTokenizer tokens = new StringTokenizer(potentialColumnInfo, columnDelimiter);
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken();
                if (t == null || t.isEmpty()) continue;
                if (!colMetaData.keySet().contains(t.trim().toUpperCase())) {
                    return null;
                }
                String currentColumn = (String)colMetaData.get(t.trim().toUpperCase());
                caseSensitiveColumnNameList = caseSensitiveColumnNameList + (caseSensitiveColumnNameList == "" ? currentColumn : columnDelimiter + currentColumn);
            }
            this.hasColumnDefinition = true;
            return caseSensitiveColumnNameList;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean initializeColumnInfo(String columnPattern) throws SQLException {
        DatabaseMetaData dmd = this.conn.getMetaData();
        ResultSet rs = dmd.getColumns(null, this.schemaName, this.tableName, columnPattern);
        boolean foundTheColumn = false;
        while (rs.next()) {
            String columnName = rs.getString(4);
            short dataType = rs.getShort(5);
            String typeName = rs.getString(6);
            int columnSize = rs.getInt(7);
            int decimalDigits = rs.getInt(9);
            int numPrecRadix = rs.getInt(10);
            foundTheColumn = true;
            if (ColumnInfo.importExportSupportedType(dataType)) {
                this.insertColumnNames.add(columnName);
                String sqlType = typeName + this.getTypeOption(typeName, columnSize, columnSize, decimalDigits);
                this.columnTypes.add(sqlType);
                this.jdbcColumnTypes.add(Integer.valueOf(dataType));
                ++this.noOfColumns;
                if (dataType != 2000) continue;
                this.udtClassNames.put("COLUMN" + this.noOfColumns, this.getUDTClassName(dmd, typeName));
                continue;
            }
            rs.close();
            throw LoadError.nonSupportedTypeColumn(columnName, typeName);
        }
        rs.close();
        return foundTheColumn;
    }

    private String getUDTClassName(DatabaseMetaData dmd, String sqlTypeName) throws SQLException {
        String className = null;
        try {
            if (sqlTypeName.charAt(0) != '\"') {
                return sqlTypeName;
            }
            String[] nameParts = IdUtil.parseMultiPartSQLIdentifier(sqlTypeName);
            String schemaName = nameParts[0];
            String unqualifiedName = nameParts[1];
            ResultSet rs = dmd.getUDTs(null, schemaName, unqualifiedName, new int[]{2000});
            if (rs.next()) {
                className = rs.getString(4);
            }
            rs.close();
        }
        catch (Exception e) {
            throw LoadError.unexpectedError(e);
        }
        if (className == null) {
            className = "???";
        }
        return className;
    }

    public static final boolean importExportSupportedType(int type) {
        return type != -7 && type != 1111 && type != 2009;
    }

    private String getTypeOption(String type, int length, int precision, int scale) {
        if ((type.equals("CHAR") || type.equals("BLOB") || type.equals("CLOB") || type.equals("VARCHAR")) && length != 0) {
            return "(" + length + ")";
        }
        if (type.equals("FLOAT") && precision != 0) {
            return "(" + precision + ")";
        }
        if (type.equals("DECIMAL") || type.equals("NUMERIC")) {
            if (precision != 0 && scale == 0) {
                return "(" + precision + ")";
            }
            if (precision != 0 && scale != 0) {
                return "(" + precision + "," + scale + ")";
            }
            if (precision == 0 && scale != 0) {
                return "(" + scale + ")";
            }
        }
        if ((type.equals("DECIMAL") || type.equals("NUMERIC")) && scale != 0) {
            return "(" + scale + ")";
        }
        return "";
    }

    public String getColumnTypeNames() throws Exception {
        return ExportAbstract.stringifyObject(this.columnTypes);
    }

    public String getUDTClassNames() throws Exception {
        return ExportAbstract.stringifyObject(this.udtClassNames);
    }

    public String getColumnNamesWithCasts() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int noOfVtiCols = this.vtiColumnNames.size();
        for (int index = 0; index < this.noOfColumns && index < noOfVtiCols; ++index) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            String type = (String)this.columnTypes.get(index);
            String columnName = (String)this.vtiColumnNames.get(index);
            if (type.startsWith("SMALLINT") || type.startsWith("INTEGER") || type.startsWith("DECIMAL") || type.startsWith("BIGINT") || type.startsWith("NUMERIC")) {
                sb.append(" cast(" + columnName + " AS " + type + ") ");
                continue;
            }
            if (type.startsWith("DOUBLE")) {
                sb.append(" DOUBLE(" + columnName + ") ");
                continue;
            }
            if (type.startsWith("REAL")) {
                sb.append("cast( DOUBLE(" + columnName + ")  AS REAL) ");
                continue;
            }
            sb.append(" " + columnName + " ");
        }
        if (first) {
            return " * ";
        }
        return sb.toString();
    }

    public String getInsertColumnNames() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int index = 0; index < this.noOfColumns; ++index) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append("\"");
            sb.append(this.insertColumnNames.get(index));
            sb.append("\"");
        }
        if (first) {
            return null;
        }
        return sb.toString();
    }

    public int getExpectedNumberOfColumnsInFile() {
        return this.expectedNumberOfCols;
    }

    private boolean tableExists() throws SQLException {
        DatabaseMetaData dmd = this.conn.getMetaData();
        ResultSet rs = dmd.getTables(null, this.schemaName, this.tableName, null);
        boolean foundTable = false;
        if (rs.next()) {
            foundTable = true;
        }
        rs.close();
        return foundTable;
    }

    public String getExpectedVtiColumnTypesAsString() {
        StringBuilder vtiColumnTypes = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.noOfColumns && i < this.vtiColumnNames.size(); ++i) {
            if (first) {
                first = false;
            } else {
                vtiColumnTypes.append(",");
            }
            vtiColumnTypes.append(this.vtiColumnNames.get(i) + ":" + this.jdbcColumnTypes.get(i));
        }
        if (first) {
            return null;
        }
        return vtiColumnTypes.toString();
    }

    public static int[] getExpectedVtiColumnTypes(String columnTypesStr, int noOfColumns) {
        int[] vtiColumnTypes = new int[noOfColumns];
        for (int i = 0; i < noOfColumns; ++i) {
            vtiColumnTypes[i] = 12;
        }
        StringTokenizer st = new StringTokenizer(columnTypesStr, ",");
        while (st.hasMoreTokens()) {
            String colTypeInfo = st.nextToken().trim();
            int colTypeOffset = colTypeInfo.indexOf(":");
            int colIndex = Integer.parseInt(colTypeInfo.substring(6, colTypeOffset), 10);
            int colType = Integer.parseInt(colTypeInfo.substring(colTypeOffset + 1), 10);
            if (colIndex > noOfColumns) continue;
            vtiColumnTypes[colIndex - 1] = colType;
        }
        return vtiColumnTypes;
    }

    public static String[] getExpectedColumnTypeNames(String columnTypeNamesString, int noOfColumns) throws Exception {
        ArrayList list = (ArrayList)ImportAbstract.destringifyObject(columnTypeNamesString);
        String[] retval = new String[list.size()];
        list.toArray(retval);
        return retval;
    }

    public static HashMap getExpectedUDTClasses(String stringVersion) throws Exception {
        HashMap stringMap = ColumnInfo.deserializeHashMap(stringVersion);
        if (stringMap == null) {
            return null;
        }
        HashMap retval = new HashMap();
        for (String columnName : stringMap.keySet()) {
            String className = (String)stringMap.get(columnName);
            Class<?> classValue = Class.forName(className);
            retval.put(columnName, classValue);
        }
        return retval;
    }

    public static HashMap deserializeHashMap(String stringVersion) throws Exception {
        if (stringVersion == null) {
            return null;
        }
        HashMap retval = (HashMap)ImportAbstract.destringifyObject(stringVersion);
        return retval;
    }

    boolean hasColumnDefinitionInFile() {
        return this.hasColumnDefinition;
    }
}

