/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc.authentication;

import com.gemstone.gemfire.internal.ClassPathLoader;
import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import java.util.Properties;

public class SpecificAuthenticationServiceImpl
extends AuthenticationServiceBase {
    private String specificAuthenticationScheme;

    @Override
    public boolean canSupport(String identifier, Properties properties) {
        this.specificAuthenticationScheme = PropertyUtil.getPropertyFromSet(properties, "gemfirexd.auth-provider");
        if (this.specificAuthenticationScheme != null && this.specificAuthenticationScheme.length() != 0 && !StringUtil.SQLEqualsIgnoreCase(this.specificAuthenticationScheme, "BUILTIN") && !this.specificAuthenticationScheme.equalsIgnoreCase("LDAP")) {
            this.checkAndSetSchemeSupported(identifier, properties, this.specificAuthenticationScheme);
            return true;
        }
        return false;
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        ReflectiveOperationException t;
        super.boot(create, properties);
        try {
            Class sasClass = ClassPathLoader.getLatest().forName(this.specificAuthenticationScheme);
            if (!UserAuthenticator.class.isAssignableFrom(sasClass)) {
                throw StandardException.newException("XBM0L.D", (Object)this.specificAuthenticationScheme, (Object)"com.pivotal.gemfirexd.internal.authentication.UserAuthenticator");
            }
            UserAuthenticator aScheme = (UserAuthenticator)sasClass.newInstance();
            this.setAuthenticationService(aScheme);
            return;
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        throw StandardException.newException("XBM0M.D", (Throwable)t, (Object)this.specificAuthenticationScheme);
    }
}

